/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.hmspicker;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import com.codetroopers.betterpickers.hmspicker.HmsPickerDialogFragment;
import java.util.Vector;

public class HmsPickerBuilder {
    private FragmentManager manager;
    private Integer styleResId;
    private Fragment targetFragment;
    private int mReference;
    private Vector<HmsPickerDialogFragment.HmsPickerDialogHandlerV2> mHmsPickerDialogHandlerV2s = new Vector();
    private int mHours;
    private int mMinutes;
    private int mSeconds;
    private Integer plusMinusVisibility;

    public HmsPickerBuilder setPlusMinusVisibility(int plusMinusVisibility) {
        this.plusMinusVisibility = plusMinusVisibility;
        return this;
    }

    public HmsPickerBuilder setFragmentManager(FragmentManager manager) {
        this.manager = manager;
        return this;
    }

    public HmsPickerBuilder setStyleResId(int styleResId) {
        this.styleResId = styleResId;
        return this;
    }

    public HmsPickerBuilder setTargetFragment(Fragment targetFragment) {
        this.targetFragment = targetFragment;
        return this;
    }

    public HmsPickerBuilder setReference(int reference) {
        this.mReference = reference;
        return this;
    }

    public HmsPickerBuilder addHmsPickerDialogHandler(HmsPickerDialogFragment.HmsPickerDialogHandlerV2 handler) {
        this.mHmsPickerDialogHandlerV2s.add(handler);
        return this;
    }

    public HmsPickerBuilder removeHmsPickerDialogHandler(HmsPickerDialogFragment.HmsPickerDialogHandlerV2 handler) {
        this.mHmsPickerDialogHandlerV2s.remove(handler);
        return this;
    }

    public HmsPickerBuilder setTime(int hours, int minutes, int seconds) {
        this.mHours = HmsPickerBuilder.bounded(hours, 0, 99);
        this.mMinutes = HmsPickerBuilder.bounded(minutes, 0, 99);
        this.mSeconds = HmsPickerBuilder.bounded(seconds, 0, 99);
        return this;
    }

    public HmsPickerBuilder setTimeInSeconds(int timeInSeconds) {
        int hours = timeInSeconds / 3600;
        int remaining = timeInSeconds % 3600;
        int minutes = remaining / 60;
        int seconds = remaining % 60;
        return this.setTime(hours, minutes, seconds);
    }

    public HmsPickerBuilder setTimeInMilliseconds(long timeInMilliseconds) {
        return this.setTimeInSeconds((int)(timeInMilliseconds / 1000L));
    }

    public void show() {
        if (this.manager == null || this.styleResId == null) {
            Log.e((String)"HmsPickerBuilder", (String)"setFragmentManager() and setStyleResId() must be called.");
            return;
        }
        FragmentTransaction ft = this.manager.beginTransaction();
        Fragment prev = this.manager.findFragmentByTag("hms_dialog");
        if (prev != null) {
            ft.remove(prev).commit();
            ft = this.manager.beginTransaction();
        }
        ft.addToBackStack(null);
        HmsPickerDialogFragment fragment = HmsPickerDialogFragment.newInstance(this.mReference, this.styleResId, this.plusMinusVisibility);
        if (this.targetFragment != null) {
            fragment.setTargetFragment(this.targetFragment, 0);
        }
        fragment.setHmsPickerDialogHandlersV2(this.mHmsPickerDialogHandlerV2s);
        if ((this.mHours | this.mMinutes | this.mSeconds) != 0) {
            fragment.setTime(this.mHours, this.mMinutes, this.mSeconds);
        }
        fragment.show(ft, "hms_dialog");
    }

    private static int bounded(int i, int min, int max) {
        return Math.min(Math.max(i, min), max);
    }
}

