/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.hmspicker;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.hmspicker.HmsPicker;
import java.util.Vector;

public class HmsPickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "HmsPickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "HmsPickerDialogFragment_ThemeResIdKey";
    private static final String PLUS_MINUS_VISIBILITY_KEY = "HmsPickerDialogFragment_PlusMinusVisibilityKey";
    private HmsPicker mPicker;
    private int mReference = -1;
    private int mTheme = -1;
    private ColorStateList mTextColor;
    private int mDialogBackgroundResId;
    private Vector<HmsPickerDialogHandlerV2> mHmsPickerDialogHandlerV2s = new Vector();
    private int mHours;
    private int mMinutes;
    private int mSeconds;
    private int mPlusMinusVisibility = 4;

    public static HmsPickerDialogFragment newInstance(int reference, int themeResId, Integer plusMinusVisibility) {
        HmsPickerDialogFragment frag = new HmsPickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        if (plusMinusVisibility != null) {
            args.putInt(PLUS_MINUS_VISIBILITY_KEY, plusMinusVisibility.intValue());
        }
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        if (args != null && args.containsKey(PLUS_MINUS_VISIBILITY_KEY)) {
            this.mPlusMinusVisibility = args.getInt(PLUS_MINUS_VISIBILITY_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.hms_picker_dialog, null);
        Button doneButton = (Button)view.findViewById(R.id.done_button);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        cancelButton.setTextColor(this.mTextColor);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HmsPickerDialogFragment.this.dismiss();
            }
        });
        doneButton.setTextColor(this.mTextColor);
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (HmsPickerDialogHandlerV2 handler : HmsPickerDialogFragment.this.mHmsPickerDialogHandlerV2s) {
                    handler.onDialogHmsSet(HmsPickerDialogFragment.this.mReference, HmsPickerDialogFragment.this.mPicker.isNegative(), HmsPickerDialogFragment.this.mPicker.getHours(), HmsPickerDialogFragment.this.mPicker.getMinutes(), HmsPickerDialogFragment.this.mPicker.getSeconds());
                }
                FragmentActivity activity = HmsPickerDialogFragment.this.getActivity();
                Fragment fragment = HmsPickerDialogFragment.this.getTargetFragment();
                if (activity instanceof HmsPickerDialogHandlerV2) {
                    HmsPickerDialogHandlerV2 act = (HmsPickerDialogHandlerV2)activity;
                    act.onDialogHmsSet(HmsPickerDialogFragment.this.mReference, HmsPickerDialogFragment.this.mPicker.isNegative(), HmsPickerDialogFragment.this.mPicker.getHours(), HmsPickerDialogFragment.this.mPicker.getMinutes(), HmsPickerDialogFragment.this.mPicker.getSeconds());
                } else if (fragment instanceof HmsPickerDialogHandlerV2) {
                    HmsPickerDialogHandlerV2 frag = (HmsPickerDialogHandlerV2)fragment;
                    frag.onDialogHmsSet(HmsPickerDialogFragment.this.mReference, HmsPickerDialogFragment.this.mPicker.isNegative(), HmsPickerDialogFragment.this.mPicker.getHours(), HmsPickerDialogFragment.this.mPicker.getMinutes(), HmsPickerDialogFragment.this.mPicker.getSeconds());
                }
                HmsPickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (HmsPicker)view.findViewById(R.id.hms_picker);
        this.mPicker.setSetButton(doneButton);
        this.mPicker.setTime(this.mHours, this.mMinutes, this.mSeconds);
        this.mPicker.setTheme(this.mTheme);
        this.mPicker.setPlusMinusVisibility(this.mPlusMinusVisibility);
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        return view;
    }

    public void setHmsPickerDialogHandlersV2(Vector<HmsPickerDialogHandlerV2> handlers) {
        this.mHmsPickerDialogHandlerV2s = handlers;
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.mHours = hours;
        this.mMinutes = minutes;
        this.mSeconds = seconds;
        if (this.mPicker != null) {
            this.mPicker.setTime(hours, minutes, seconds);
        }
    }

    public static interface HmsPickerDialogHandlerV2 {
        public void onDialogHmsSet(int var1, boolean var2, int var3, int var4, int var5);
    }
}

