/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.numberpicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.numberpicker.NumberPickerErrorTextView;
import com.codetroopers.betterpickers.numberpicker.NumberView;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class NumberPicker
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    protected int mInputSize = 20;
    protected final Button[] mNumbers = new Button[10];
    protected int[] mInput = new int[this.mInputSize];
    protected int mInputPointer = -1;
    protected Button mLeft;
    protected Button mRight;
    protected ImageButton mDelete;
    protected NumberView mEnteredNumber;
    protected final Context mContext;
    private TextView mLabel;
    private NumberPickerErrorTextView mError;
    private int mSign;
    private String mLabelText = "";
    private Button mSetButton;
    private static final int CLICKED_DECIMAL = 10;
    public static final int SIGN_POSITIVE = 0;
    public static final int SIGN_NEGATIVE = 1;
    protected View mDivider;
    private ColorStateList mTextColor;
    private int mKeyBackgroundResId;
    private int mButtonBackgroundResId;
    private int mDividerColor;
    private int mDeleteDrawableSrcResId;
    private int mTheme = -1;
    private BigDecimal mMinNumber = null;
    private BigDecimal mMaxNumber = null;

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        layoutInflater.inflate(this.getLayoutId(), (ViewGroup)this);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mKeyBackgroundResId = R.drawable.key_background_dark;
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mDeleteDrawableSrcResId = R.drawable.ic_backspace_dark;
        this.mDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
    }

    protected int getLayoutId() {
        return R.layout.number_picker_view;
    }

    public void setTheme(int themeResId) {
        this.mTheme = themeResId;
        if (this.mTheme != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mKeyBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpKeyBackground, this.mKeyBackgroundResId);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpDividerColor, this.mDividerColor);
            this.mDeleteDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDeleteIcon, this.mDeleteDrawableSrcResId);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        for (Button number : this.mNumbers) {
            if (number == null) continue;
            number.setTextColor(this.mTextColor);
            number.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(this.mDividerColor);
        }
        if (this.mLeft != null) {
            this.mLeft.setTextColor(this.mTextColor);
            this.mLeft.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mRight != null) {
            this.mRight.setTextColor(this.mTextColor);
            this.mRight.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDelete != null) {
            this.mDelete.setBackgroundResource(this.mButtonBackgroundResId);
            this.mDelete.setImageDrawable(this.getResources().getDrawable(this.mDeleteDrawableSrcResId));
        }
        if (this.mEnteredNumber != null) {
            this.mEnteredNumber.setTheme(this.mTheme);
        }
        if (this.mLabel != null) {
            this.mLabel.setTextColor(this.mTextColor);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mDivider = this.findViewById(R.id.divider);
        this.mError = (NumberPickerErrorTextView)this.findViewById(R.id.error);
        for (int i = 0; i < this.mInput.length; ++i) {
            this.mInput[i] = -1;
        }
        View v1 = this.findViewById(R.id.first);
        View v2 = this.findViewById(R.id.second);
        View v3 = this.findViewById(R.id.third);
        View v4 = this.findViewById(R.id.fourth);
        this.mEnteredNumber = (NumberView)this.findViewById(R.id.number_text);
        this.mDelete = (ImageButton)this.findViewById(R.id.delete);
        this.mDelete.setOnClickListener((View.OnClickListener)this);
        this.mDelete.setOnLongClickListener((View.OnLongClickListener)this);
        this.mNumbers[1] = (Button)v1.findViewById(R.id.key_left);
        this.mNumbers[2] = (Button)v1.findViewById(R.id.key_middle);
        this.mNumbers[3] = (Button)v1.findViewById(R.id.key_right);
        this.mNumbers[4] = (Button)v2.findViewById(R.id.key_left);
        this.mNumbers[5] = (Button)v2.findViewById(R.id.key_middle);
        this.mNumbers[6] = (Button)v2.findViewById(R.id.key_right);
        this.mNumbers[7] = (Button)v3.findViewById(R.id.key_left);
        this.mNumbers[8] = (Button)v3.findViewById(R.id.key_middle);
        this.mNumbers[9] = (Button)v3.findViewById(R.id.key_right);
        this.mLeft = (Button)v4.findViewById(R.id.key_left);
        this.mNumbers[0] = (Button)v4.findViewById(R.id.key_middle);
        this.mRight = (Button)v4.findViewById(R.id.key_right);
        this.setLeftRightEnabled();
        for (int i = 0; i < 10; ++i) {
            this.mNumbers[i].setOnClickListener((View.OnClickListener)this);
            this.mNumbers[i].setText((CharSequence)String.format("%d", i));
            this.mNumbers[i].setTag(R.id.numbers_key, (Object)new Integer(i));
        }
        this.updateNumber();
        Resources res = this.mContext.getResources();
        this.mLeft.setText((CharSequence)res.getString(R.string.number_picker_plus_minus));
        this.mRight.setText((CharSequence)res.getString(R.string.number_picker_seperator));
        this.mLeft.setOnClickListener((View.OnClickListener)this);
        this.mRight.setOnClickListener((View.OnClickListener)this);
        this.mLabel = (TextView)this.findViewById(R.id.label);
        this.mSign = 0;
        this.showLabel();
        this.restyleViews();
        this.updateKeypad();
    }

    public void setPlusMinusVisibility(int visiblity) {
        if (this.mLeft != null) {
            this.mLeft.setVisibility(visiblity);
        }
    }

    public void setDecimalVisibility(int visiblity) {
        if (this.mRight != null) {
            this.mRight.setVisibility(visiblity);
        }
    }

    public void setMin(BigDecimal min) {
        this.mMinNumber = min;
    }

    public void setMax(BigDecimal max) {
        this.mMaxNumber = max;
    }

    public void updateDeleteButton() {
        boolean enabled;
        boolean bl = enabled = this.mInputPointer != -1;
        if (this.mDelete != null) {
            this.mDelete.setEnabled(enabled);
        }
    }

    public NumberPickerErrorTextView getErrorView() {
        return this.mError;
    }

    public void onClick(View v) {
        v.performHapticFeedback(1);
        this.mError.hideImmediately();
        this.doOnClick(v);
        this.updateDeleteButton();
    }

    protected void doOnClick(View v) {
        Integer val = (Integer)v.getTag(R.id.numbers_key);
        if (val != null) {
            this.addClickedNumber(val);
        } else if (v == this.mDelete) {
            if (this.mInputPointer >= 0) {
                for (int i = 0; i < this.mInputPointer; ++i) {
                    this.mInput[i] = this.mInput[i + 1];
                }
                this.mInput[this.mInputPointer] = -1;
                --this.mInputPointer;
            }
        } else if (v == this.mLeft) {
            this.onLeftClicked();
        } else if (v == this.mRight) {
            this.onRightClicked();
        }
        this.updateKeypad();
    }

    public boolean onLongClick(View v) {
        v.performHapticFeedback(0);
        this.mError.hideImmediately();
        if (v == this.mDelete) {
            this.mDelete.setPressed(false);
            this.reset();
            this.updateKeypad();
            return true;
        }
        return false;
    }

    private void updateKeypad() {
        this.updateLeftRightButtons();
        this.updateNumber();
        this.enableSetButton();
        this.updateDeleteButton();
    }

    public void setLabelText(String labelText) {
        this.mLabelText = labelText;
        this.showLabel();
    }

    private void showLabel() {
        if (this.mLabel != null) {
            this.mLabel.setText((CharSequence)this.mLabelText);
        }
    }

    public void reset() {
        for (int i = 0; i < this.mInputSize; ++i) {
            this.mInput[i] = -1;
        }
        this.mInputPointer = -1;
        this.updateNumber();
    }

    protected void updateNumber() {
        String numberString = this.getEnteredNumberString();
        String[] split = (numberString = numberString.replaceAll("\\-", "")).split("\\.");
        if (split.length >= 2) {
            if (split[0].equals("")) {
                this.mEnteredNumber.setNumber("0", split[1], this.containsDecimal(), this.mSign == 1);
            } else {
                this.mEnteredNumber.setNumber(split[0], split[1], this.containsDecimal(), this.mSign == 1);
            }
        } else if (split.length == 1) {
            this.mEnteredNumber.setNumber(split[0], "", this.containsDecimal(), this.mSign == 1);
        } else if (numberString.equals(".")) {
            this.mEnteredNumber.setNumber("0", "", true, this.mSign == 1);
        }
    }

    protected void setLeftRightEnabled() {
        this.mLeft.setEnabled(true);
        this.mRight.setEnabled(this.canAddDecimal());
        if (!this.canAddDecimal()) {
            this.mRight.setContentDescription(null);
        }
    }

    private void addClickedNumber(int val) {
        if (this.mInputPointer < this.mInputSize - 1) {
            if (this.mInput[0] == 0 && this.mInput[1] == -1 && !this.containsDecimal() && val != 10) {
                this.mInput[0] = val;
            } else {
                for (int i = this.mInputPointer; i >= 0; --i) {
                    this.mInput[i + 1] = this.mInput[i];
                }
                ++this.mInputPointer;
                this.mInput[0] = val;
            }
        }
    }

    private void onLeftClicked() {
        this.mSign = this.mSign == 0 ? 1 : 0;
    }

    private void onRightClicked() {
        if (this.canAddDecimal()) {
            this.addClickedNumber(10);
        }
    }

    private boolean containsDecimal() {
        boolean containsDecimal = false;
        for (int i : this.mInput) {
            if (i != 10) continue;
            containsDecimal = true;
        }
        return containsDecimal;
    }

    private boolean canAddDecimal() {
        return !this.containsDecimal();
    }

    private String getEnteredNumberString() {
        String value = "";
        for (int i = this.mInputPointer; i >= 0; --i) {
            if (this.mInput[i] == -1) continue;
            value = this.mInput[i] == 10 ? value + "." : value + this.mInput[i];
        }
        return value;
    }

    public BigDecimal getEnteredNumber() {
        String value = "0";
        for (int i = this.mInputPointer; i >= 0 && this.mInput[i] != -1; --i) {
            value = this.mInput[i] == 10 ? value + "." : value + this.mInput[i];
        }
        if (this.mSign == 1) {
            value = "-" + value;
        }
        return new BigDecimal(value);
    }

    private void updateLeftRightButtons() {
        this.mRight.setEnabled(this.canAddDecimal());
    }

    private void enableSetButton() {
        if (this.mSetButton == null) {
            return;
        }
        if (this.mInputPointer == -1) {
            this.mSetButton.setEnabled(false);
            return;
        }
        this.mSetButton.setEnabled(this.mInputPointer >= 0);
    }

    public void setSetButton(Button b) {
        this.mSetButton = b;
        this.enableSetButton();
    }

    public BigInteger getNumber() {
        BigDecimal bigDecimal = this.getEnteredNumber().setScale(0, 3);
        return bigDecimal.toBigIntegerExact();
    }

    public double getDecimal() {
        return this.getEnteredNumber().remainder(BigDecimal.ONE).doubleValue();
    }

    public boolean getIsNegative() {
        return this.mSign == 1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcel = super.onSaveInstanceState();
        SavedState state = new SavedState(parcel);
        state.mInput = this.mInput;
        state.mSign = this.mSign;
        state.mInputPointer = this.mInputPointer;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mInputPointer = savedState.mInputPointer;
        this.mInput = savedState.mInput;
        if (this.mInput == null) {
            this.mInput = new int[this.mInputSize];
            this.mInputPointer = -1;
        }
        this.mSign = savedState.mSign;
        this.updateKeypad();
    }

    public void setNumber(Integer integerPart, Double decimalPart, Integer mCurrentSign) {
        this.mSign = mCurrentSign != null ? mCurrentSign : 0;
        if (decimalPart != null) {
            String decimalString = this.doubleToString(decimalPart);
            this.readAndRightDigits(TextUtils.substring((CharSequence)decimalString, (int)2, (int)decimalString.length()));
            ++this.mInputPointer;
            this.mInput[this.mInputPointer] = 10;
        }
        if (integerPart != null) {
            this.readAndRightDigits(String.valueOf(integerPart));
        }
        this.updateKeypad();
    }

    private void readAndRightDigits(String digitsToRead) {
        for (int i = digitsToRead.length() - 1; i >= 0; --i) {
            ++this.mInputPointer;
            this.mInput[this.mInputPointer] = digitsToRead.charAt(i) - 48;
        }
    }

    private String doubleToString(double value) {
        DecimalFormat format = new DecimalFormat("0.0");
        format.setMaximumFractionDigits(Integer.MAX_VALUE);
        return format.format(value);
    }

    private static class SavedState
    extends View.BaseSavedState {
        int mInputPointer;
        int[] mInput;
        int mSign;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mInputPointer = in.readInt();
            int size = in.readInt();
            if (size > 0) {
                this.mInput = new int[size];
                in.readIntArray(this.mInput);
            }
            this.mSign = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mInputPointer);
            if (this.mInput != null) {
                dest.writeInt(this.mInput.length);
                dest.writeIntArray(this.mInput);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.mSign);
        }
    }
}

