/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.radialtimepicker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.View;
import com.codetroopers.betterpickers.R;
import com.nineoldandroids.animation.Keyframe;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.PropertyValuesHolder;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.animation.AnimatorProxy;

public class RadialSelectorView
extends View {
    private static final String TAG = "RadialSelectorView";
    private static final int FULL_ALPHA = 255;
    private final Paint mPaint = new Paint();
    private boolean mIsInitialized = false;
    private boolean mDrawValuesReady;
    private float mCircleRadiusMultiplier;
    private float mAmPmCircleRadiusMultiplier;
    private float mInnerNumbersRadiusMultiplier;
    private float mOuterNumbersRadiusMultiplier;
    private float mNumbersRadiusMultiplier;
    private float mSelectionRadiusMultiplier;
    private float mAnimationRadiusMultiplier;
    private boolean mIs24HourMode;
    private boolean mHasInnerCircle;
    private int mSelectionAlpha;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;
    private float mTransitionMidRadiusMultiplier;
    private float mTransitionEndRadiusMultiplier;
    private int mLineLength;
    private int mSelectionRadius;
    private InvalidateUpdateListener mInvalidateUpdateListener;
    private int mSelectionDegrees;
    private double mSelectionRadians;
    private boolean mForceDrawDot;

    public RadialSelectorView(Context context) {
        super(context);
    }

    public void initialize(Context context, boolean is24HourMode, boolean hasInnerCircle, boolean disappearsOut, int selectionDegrees, boolean isInnerCircle) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"This RadialSelectorView may only be initialized once.");
            return;
        }
        Resources res = context.getResources();
        this.mPaint.setAntiAlias(true);
        this.mIs24HourMode = is24HourMode;
        if (is24HourMode) {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.circle_radius_multiplier_24HourMode));
        } else {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.circle_radius_multiplier));
            this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.ampm_circle_radius_multiplier));
        }
        this.mHasInnerCircle = hasInnerCircle;
        if (hasInnerCircle) {
            this.mInnerNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.numbers_radius_multiplier_inner));
            this.mOuterNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.numbers_radius_multiplier_outer));
        } else {
            this.mNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.numbers_radius_multiplier_normal));
        }
        this.mSelectionRadiusMultiplier = Float.parseFloat(res.getString(R.string.selection_radius_multiplier));
        this.mAnimationRadiusMultiplier = 1.0f;
        this.mTransitionMidRadiusMultiplier = 1.0f + 0.05f * (float)(disappearsOut ? -1 : 1);
        this.mTransitionEndRadiusMultiplier = 1.0f + 0.3f * (float)(disappearsOut ? 1 : -1);
        this.mInvalidateUpdateListener = new InvalidateUpdateListener();
        this.setSelection(selectionDegrees, isInnerCircle, false);
        this.mIsInitialized = true;
    }

    void setTheme(TypedArray themeColors) {
        this.mPaint.setColor(themeColors.getColor(R.styleable.BetterPickersDialogs_bpRadialPointerColor, R.color.bpBlue));
        this.mSelectionAlpha = themeColors.getInt(R.styleable.BetterPickersDialogs_bpRadialPointerAlpha, 35);
    }

    public void setSelection(int selectionDegrees, boolean isInnerCircle, boolean forceDrawDot) {
        this.mSelectionDegrees = selectionDegrees;
        this.mSelectionRadians = (double)selectionDegrees * Math.PI / 180.0;
        this.mForceDrawDot = forceDrawDot;
        if (this.mHasInnerCircle) {
            this.mNumbersRadiusMultiplier = isInnerCircle ? this.mInnerNumbersRadiusMultiplier : this.mOuterNumbersRadiusMultiplier;
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    public void setAnimationRadiusMultiplier(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier = animationRadiusMultiplier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDegreesFromCoords(float pointX, float pointY, boolean forceLegal, Boolean[] isInnerCircle) {
        boolean topSide;
        int maxAllowedDistance;
        int distanceToNumber;
        if (!this.mDrawValuesReady) {
            return -1;
        }
        double hypotenuse = Math.sqrt((pointY - (float)this.mYCenter) * (pointY - (float)this.mYCenter) + (pointX - (float)this.mXCenter) * (pointX - (float)this.mXCenter));
        if (this.mHasInnerCircle) {
            if (forceLegal) {
                int outerNumberRadius;
                int distanceToOuterNumber;
                int innerNumberRadius = (int)((float)this.mCircleRadius * this.mInnerNumbersRadiusMultiplier);
                int distanceToInnerNumber = (int)Math.abs(hypotenuse - (double)innerNumberRadius);
                isInnerCircle[0] = distanceToInnerNumber <= (distanceToOuterNumber = (int)Math.abs(hypotenuse - (double)(outerNumberRadius = (int)((float)this.mCircleRadius * this.mOuterNumbersRadiusMultiplier))));
            } else {
                int minAllowedHypotenuseForInnerNumber = (int)((float)this.mCircleRadius * this.mInnerNumbersRadiusMultiplier) - this.mSelectionRadius;
                int maxAllowedHypotenuseForOuterNumber = (int)((float)this.mCircleRadius * this.mOuterNumbersRadiusMultiplier) + this.mSelectionRadius;
                int halfwayHypotenusePoint = (int)((float)this.mCircleRadius * ((this.mOuterNumbersRadiusMultiplier + this.mInnerNumbersRadiusMultiplier) / 2.0f));
                if (hypotenuse >= (double)minAllowedHypotenuseForInnerNumber && hypotenuse <= (double)halfwayHypotenusePoint) {
                    isInnerCircle[0] = true;
                } else {
                    if (!(hypotenuse <= (double)maxAllowedHypotenuseForOuterNumber)) return -1;
                    if (!(hypotenuse >= (double)halfwayHypotenusePoint)) return -1;
                    isInnerCircle[0] = false;
                }
            }
        } else if (!forceLegal && (distanceToNumber = (int)Math.abs(hypotenuse - (double)this.mLineLength)) > (maxAllowedDistance = (int)((float)this.mCircleRadius * (1.0f - this.mNumbersRadiusMultiplier)))) {
            return -1;
        }
        float opposite = Math.abs(pointY - (float)this.mYCenter);
        double radians = Math.asin((double)opposite / hypotenuse);
        int degrees = (int)(radians * 180.0 / Math.PI);
        boolean rightSide = pointX > (float)this.mXCenter;
        boolean bl = topSide = pointY < (float)this.mYCenter;
        if (rightSide && topSide) {
            return 90 - degrees;
        }
        if (rightSide && !topSide) {
            return 90 + degrees;
        }
        if (!rightSide && !topSide) {
            return 270 - degrees;
        }
        if (rightSide) return degrees;
        if (!topSide) return degrees;
        return 270 + degrees;
    }

    public void onDraw(Canvas canvas) {
        int viewWidth = this.getWidth();
        if (viewWidth == 0 || !this.mIsInitialized) {
            return;
        }
        if (!this.mDrawValuesReady) {
            this.mXCenter = this.getWidth() / 2;
            this.mYCenter = this.getHeight() / 2;
            this.mCircleRadius = (int)((float)Math.min(this.mXCenter, this.mYCenter) * this.mCircleRadiusMultiplier);
            if (!this.mIs24HourMode) {
                int amPmCircleRadius = (int)((float)this.mCircleRadius * this.mAmPmCircleRadiusMultiplier);
                this.mYCenter -= amPmCircleRadius / 2;
            }
            this.mSelectionRadius = (int)((float)this.mCircleRadius * this.mSelectionRadiusMultiplier);
            this.mDrawValuesReady = true;
        }
        this.mLineLength = (int)((float)this.mCircleRadius * this.mNumbersRadiusMultiplier * this.mAnimationRadiusMultiplier);
        int pointX = this.mXCenter + (int)((double)this.mLineLength * Math.sin(this.mSelectionRadians));
        int pointY = this.mYCenter - (int)((double)this.mLineLength * Math.cos(this.mSelectionRadians));
        this.mPaint.setAlpha(this.mSelectionAlpha);
        canvas.drawCircle((float)pointX, (float)pointY, (float)this.mSelectionRadius, this.mPaint);
        if (this.mForceDrawDot | this.mSelectionDegrees % 30 != 0) {
            this.mPaint.setAlpha(255);
            canvas.drawCircle((float)pointX, (float)pointY, (float)(this.mSelectionRadius * 2 / 7), this.mPaint);
        } else {
            int lineLength = this.mLineLength;
            pointX = this.mXCenter + (int)((double)(lineLength -= this.mSelectionRadius) * Math.sin(this.mSelectionRadians));
            pointY = this.mYCenter - (int)((double)lineLength * Math.cos(this.mSelectionRadians));
        }
        this.mPaint.setAlpha(255);
        this.mPaint.setStrokeWidth(1.0f);
        canvas.drawLine((float)this.mXCenter, (float)this.mYCenter, (float)pointX, (float)pointY, this.mPaint);
    }

    public ObjectAnimator getDisappearAnimator() {
        if (!this.mIsInitialized || !this.mDrawValuesReady) {
            Log.e((String)TAG, (String)"RadialSelectorView was not ready for animation.");
            return null;
        }
        float midwayPoint = 0.2f;
        int duration = 500;
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe kf1 = Keyframe.ofFloat((float)midwayPoint, (float)this.mTransitionMidRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat((float)1.0f, (float)this.mTransitionEndRadiusMultiplier);
        PropertyValuesHolder radiusDisappear = PropertyValuesHolder.ofKeyframe((String)"animationRadiusMultiplier", (Keyframe[])new Keyframe[]{kf0, kf1, kf2});
        kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        kf1 = Keyframe.ofFloat((float)1.0f, (float)0.0f);
        PropertyValuesHolder fadeOut = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1});
        ObjectAnimator disappearAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)(AnimatorProxy.NEEDS_PROXY ? AnimatorProxy.wrap((View)this) : this), (PropertyValuesHolder[])new PropertyValuesHolder[]{radiusDisappear, fadeOut}).setDuration((long)duration);
        disappearAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mInvalidateUpdateListener);
        return disappearAnimator;
    }

    public ObjectAnimator getReappearAnimator() {
        if (!this.mIsInitialized || !this.mDrawValuesReady) {
            Log.e((String)TAG, (String)"RadialSelectorView was not ready for animation.");
            return null;
        }
        float midwayPoint = 0.2f;
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        midwayPoint = 1.0f - midwayPoint * (1.0f - delayPoint);
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)this.mTransitionEndRadiusMultiplier);
        Keyframe kf1 = Keyframe.ofFloat((float)delayPoint, (float)this.mTransitionEndRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat((float)midwayPoint, (float)this.mTransitionMidRadiusMultiplier);
        Keyframe kf3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder radiusReappear = PropertyValuesHolder.ofKeyframe((String)"animationRadiusMultiplier", (Keyframe[])new Keyframe[]{kf0, kf1, kf2, kf3});
        kf0 = Keyframe.ofFloat((float)0.0f, (float)0.0f);
        kf1 = Keyframe.ofFloat((float)delayPoint, (float)0.0f);
        kf2 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1, kf2});
        ObjectAnimator reappearAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)(AnimatorProxy.NEEDS_PROXY ? AnimatorProxy.wrap((View)this) : this), (PropertyValuesHolder[])new PropertyValuesHolder[]{radiusReappear, fadeIn}).setDuration((long)totalDuration);
        reappearAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mInvalidateUpdateListener);
        return reappearAnimator;
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            RadialSelectorView.this.invalidate();
        }
    }
}

