/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.recurrencepicker;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.SwitchCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TimeFormatException;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TableLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.calendardatepicker.CalendarDatePickerDialogFragment;
import com.codetroopers.betterpickers.recurrencepicker.EventRecurrence;
import com.codetroopers.betterpickers.recurrencepicker.Utils;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;

public class RecurrencePickerDialogFragment
extends DialogFragment
implements AdapterView.OnItemSelectedListener,
CompoundButton.OnCheckedChangeListener,
View.OnClickListener,
RadioGroup.OnCheckedChangeListener,
CalendarDatePickerDialogFragment.OnDateSetListener {
    private static final String TAG = "RecurrencePickerDialogFragment";
    private static final int MIN_SCREEN_WIDTH_FOR_SINGLE_ROW_WEEK = 450;
    private static final int INTERVAL_MAX = 99;
    private static final int INTERVAL_DEFAULT = 1;
    private static final int COUNT_MAX = 730;
    private static final int COUNT_DEFAULT = 5;
    private static final int FIFTH_WEEK_IN_A_MONTH = 5;
    public static final int LAST_NTH_DAY_OF_WEEK = -1;
    private CalendarDatePickerDialogFragment mDatePickerDialog;
    private Resources mResources;
    private EventRecurrence mRecurrence = new EventRecurrence();
    private Time mTime = new Time();
    private RecurrenceModel mModel = new RecurrenceModel();
    private Toast mToast;
    private final int[] TIME_DAY_TO_CALENDAR_DAY = new int[]{1, 2, 3, 4, 5, 6, 7};
    private View mView;
    private Spinner mFreqSpinner;
    private static final int[] mFreqModelToEventRecurrence = new int[]{3, 4, 5, 6, 7};
    public static final String BUNDLE_START_TIME_MILLIS = "bundle_event_start_time";
    public static final String BUNDLE_TIME_ZONE = "bundle_event_time_zone";
    public static final String BUNDLE_RRULE = "bundle_event_rrule";
    public static final String BUNDLE_HIDE_SWITCH_BUTTON = "bundle_hide_switch_button";
    private static final String BUNDLE_MODEL = "bundle_model";
    private static final String BUNDLE_END_COUNT_HAS_FOCUS = "bundle_end_count_has_focus";
    private static final String FRAG_TAG_DATE_PICKER = "tag_date_picker_frag";
    private SwitchCompat mRepeatSwitch;
    private EditText mInterval;
    private TextView mIntervalPreText;
    private TextView mIntervalPostText;
    private int mIntervalResId = -1;
    private Spinner mEndSpinner;
    private TextView mEndDateTextView;
    private EditText mEndCount;
    private TextView mPostEndCount;
    private boolean mHidePostEndCount;
    private ArrayList<CharSequence> mEndSpinnerArray = new ArrayList(3);
    private EndSpinnerAdapter mEndSpinnerAdapter;
    private String mEndNeverStr;
    private String mEndDateLabel;
    private String mEndCountLabel;
    private LinearLayout mWeekGroup;
    private LinearLayout mWeekGroup2;
    private ToggleButton[] mWeekByDayButtons = new ToggleButton[7];
    private String[][] mMonthRepeatByDayOfWeekStrs;
    private LinearLayout mMonthGroup;
    private RadioGroup mMonthRepeatByRadioGroup;
    private RadioButton mRepeatMonthlyByNthDayOfWeek;
    private RadioButton mRepeatMonthlyByNthDayOfMonth;
    private String mMonthRepeatByDayOfWeekStr;
    private Button mDoneButton;
    private OnRecurrenceSetListener mRecurrenceSetListener;

    public static boolean isSupportedMonthlyByNthDayOfWeek(int num) {
        return num > 0 && num <= 5 || num == -1;
    }

    public static boolean canHandleRecurrenceRule(EventRecurrence er) {
        switch (er.freq) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                return false;
            }
        }
        if (er.count > 0 && !TextUtils.isEmpty((CharSequence)er.until)) {
            return false;
        }
        int numOfByDayNum = 0;
        for (int i = 0; i < er.bydayCount; ++i) {
            if (!RecurrencePickerDialogFragment.isSupportedMonthlyByNthDayOfWeek(er.bydayNum[i])) continue;
            ++numOfByDayNum;
        }
        if (numOfByDayNum > 1) {
            return false;
        }
        if (numOfByDayNum > 0 && er.freq != 6) {
            return false;
        }
        if (er.bymonthdayCount > 1) {
            return false;
        }
        if (er.freq == 6) {
            if (er.bydayCount > 1) {
                return false;
            }
            if (er.bydayCount > 0 && er.bymonthdayCount > 0) {
                return false;
            }
        }
        return true;
    }

    private static void copyEventRecurrenceToModel(EventRecurrence er, RecurrenceModel model) {
        switch (er.freq) {
            case 3: {
                model.freq = 0;
                break;
            }
            case 4: {
                model.freq = 1;
                break;
            }
            case 6: {
                model.freq = 3;
                break;
            }
            case 7: {
                model.freq = 4;
                break;
            }
            case 5: {
                model.freq = 2;
                break;
            }
            default: {
                throw new IllegalStateException("freq=" + er.freq);
            }
        }
        if (er.interval > 0) {
            model.interval = er.interval;
        }
        model.endCount = er.count;
        if (model.endCount > 0) {
            model.end = 2;
        }
        if (!TextUtils.isEmpty((CharSequence)er.until)) {
            if (model.endDate == null) {
                model.endDate = new Time();
            }
            try {
                model.endDate.parse(er.until);
            }
            catch (TimeFormatException e) {
                model.endDate = null;
            }
            if (model.end == 2 && model.endDate != null) {
                throw new IllegalStateException("freq=" + er.freq);
            }
            model.end = 1;
        }
        Arrays.fill(model.weeklyByDayOfWeek, false);
        if (er.bydayCount > 0) {
            int count = 0;
            for (int i = 0; i < er.bydayCount; ++i) {
                int dayOfWeek = EventRecurrence.day2TimeDay(er.byday[i]);
                model.weeklyByDayOfWeek[dayOfWeek] = true;
                if (model.freq != 3 || !RecurrencePickerDialogFragment.isSupportedMonthlyByNthDayOfWeek(er.bydayNum[i])) continue;
                model.monthlyByDayOfWeek = dayOfWeek;
                model.monthlyByNthDayOfWeek = er.bydayNum[i];
                model.monthlyRepeat = 1;
                ++count;
            }
            if (model.freq == 3) {
                if (er.bydayCount != 1) {
                    throw new IllegalStateException("Can handle only 1 byDayOfWeek in monthly");
                }
                if (count != 1) {
                    throw new IllegalStateException("Didn't specify which nth day of week to repeat for a monthly");
                }
            }
        }
        if (model.freq == 3) {
            if (er.bymonthdayCount == 1) {
                if (model.monthlyRepeat == 1) {
                    throw new IllegalStateException("Can handle only by monthday or by nth day of week, not both");
                }
                model.monthlyByMonthDay = er.bymonthday[0];
                model.monthlyRepeat = 0;
            } else if (er.bymonthCount > 1) {
                throw new IllegalStateException("Can handle only one bymonthday");
            }
        }
    }

    private static void copyModelToEventRecurrence(RecurrenceModel model, EventRecurrence eventRecurrence) {
        if (model.recurrenceState == 0) {
            throw new IllegalStateException("There's no recurrence");
        }
        eventRecurrence.freq = mFreqModelToEventRecurrence[model.freq];
        eventRecurrence.interval = model.interval <= 1 ? 0 : model.interval;
        switch (model.end) {
            case 1: {
                if (model.endDate != null) {
                    model.endDate.switchTimezone("UTC");
                    model.endDate.normalize(false);
                    eventRecurrence.until = model.endDate.format2445();
                    eventRecurrence.count = 0;
                    break;
                }
                throw new IllegalStateException("end = END_BY_DATE but endDate is null");
            }
            case 2: {
                eventRecurrence.count = model.endCount;
                eventRecurrence.until = null;
                if (eventRecurrence.count > 0) break;
                throw new IllegalStateException("count is " + eventRecurrence.count);
            }
            default: {
                eventRecurrence.count = 0;
                eventRecurrence.until = null;
            }
        }
        eventRecurrence.bydayCount = 0;
        eventRecurrence.bymonthdayCount = 0;
        switch (model.freq) {
            case 3: {
                if (model.monthlyRepeat == 0) {
                    if (model.monthlyByMonthDay <= 0) break;
                    if (eventRecurrence.bymonthday == null || eventRecurrence.bymonthdayCount < 1) {
                        eventRecurrence.bymonthday = new int[1];
                    }
                    eventRecurrence.bymonthday[0] = model.monthlyByMonthDay;
                    eventRecurrence.bymonthdayCount = 1;
                    break;
                }
                if (model.monthlyRepeat != 1) break;
                if (!RecurrencePickerDialogFragment.isSupportedMonthlyByNthDayOfWeek(model.monthlyByNthDayOfWeek)) {
                    throw new IllegalStateException("month repeat by nth week but n is " + model.monthlyByNthDayOfWeek);
                }
                int count = 1;
                if (eventRecurrence.bydayCount < count || eventRecurrence.byday == null || eventRecurrence.bydayNum == null) {
                    eventRecurrence.byday = new int[count];
                    eventRecurrence.bydayNum = new int[count];
                }
                eventRecurrence.bydayCount = count;
                eventRecurrence.byday[0] = EventRecurrence.timeDay2Day(model.monthlyByDayOfWeek);
                eventRecurrence.bydayNum[0] = model.monthlyByNthDayOfWeek;
                break;
            }
            case 2: {
                int i;
                int count = 0;
                for (i = 0; i < 7; ++i) {
                    if (!model.weeklyByDayOfWeek[i]) continue;
                    ++count;
                }
                if (eventRecurrence.bydayCount < count || eventRecurrence.byday == null || eventRecurrence.bydayNum == null) {
                    eventRecurrence.byday = new int[count];
                    eventRecurrence.bydayNum = new int[count];
                }
                eventRecurrence.bydayCount = count;
                for (i = 6; i >= 0; --i) {
                    if (!model.weeklyByDayOfWeek[i]) continue;
                    eventRecurrence.bydayNum[--count] = 0;
                    eventRecurrence.byday[count] = EventRecurrence.timeDay2Day(i);
                }
                break;
            }
        }
        if (!RecurrencePickerDialogFragment.canHandleRecurrenceRule(eventRecurrence)) {
            throw new IllegalStateException("UI generated recurrence that it can't handle. ER:" + eventRecurrence.toString() + " Model: " + model.toString());
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int i;
        int numOfButtonsInRow2;
        int numOfButtonsInRow1;
        this.mRecurrence.wkst = EventRecurrence.timeDay2Day(Utils.getFirstDayOfWeek((Context)this.getActivity()));
        this.getDialog().getWindow().requestFeature(1);
        boolean endCountHasFocus = false;
        if (savedInstanceState != null) {
            RecurrenceModel m = (RecurrenceModel)savedInstanceState.get(BUNDLE_MODEL);
            if (m != null) {
                this.mModel = m;
            }
            endCountHasFocus = savedInstanceState.getBoolean(BUNDLE_END_COUNT_HAS_FOCUS);
        } else {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mTime.set(bundle.getLong(BUNDLE_START_TIME_MILLIS));
                String tz = bundle.getString(BUNDLE_TIME_ZONE);
                if (!TextUtils.isEmpty((CharSequence)tz)) {
                    this.mTime.timezone = tz;
                }
                this.mTime.normalize(false);
                this.mModel.weeklyByDayOfWeek[this.mTime.weekDay] = true;
                String rrule = bundle.getString(BUNDLE_RRULE);
                if (!TextUtils.isEmpty((CharSequence)rrule)) {
                    this.mModel.recurrenceState = 1;
                    this.mRecurrence.parse(rrule);
                    RecurrencePickerDialogFragment.copyEventRecurrenceToModel(this.mRecurrence, this.mModel);
                    if (this.mRecurrence.bydayCount == 0) {
                        this.mModel.weeklyByDayOfWeek[this.mTime.weekDay] = true;
                    }
                }
                this.mModel.forceHideSwitchButton = bundle.getBoolean(BUNDLE_HIDE_SWITCH_BUTTON, false);
            } else {
                this.mTime.setToNow();
            }
        }
        this.mResources = this.getResources();
        this.mView = inflater.inflate(R.layout.recurrencepicker, container, true);
        FragmentActivity activity = this.getActivity();
        Configuration config = activity.getResources().getConfiguration();
        this.mRepeatSwitch = (SwitchCompat)this.mView.findViewById(R.id.repeat_switch);
        if (this.mModel.forceHideSwitchButton) {
            this.mRepeatSwitch.setChecked(true);
            this.mRepeatSwitch.setVisibility(8);
            this.mModel.recurrenceState = 1;
        } else {
            this.mRepeatSwitch.setChecked(this.mModel.recurrenceState == 1);
            this.mRepeatSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    ((RecurrencePickerDialogFragment)RecurrencePickerDialogFragment.this).mModel.recurrenceState = isChecked ? 1 : 0;
                    RecurrencePickerDialogFragment.this.togglePickerOptions();
                }
            });
        }
        this.mFreqSpinner = (Spinner)this.mView.findViewById(R.id.freqSpinner);
        this.mFreqSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        ArrayAdapter freqAdapter = ArrayAdapter.createFromResource((Context)this.getActivity(), (int)R.array.recurrence_freq, (int)R.layout.recurrencepicker_freq_item);
        freqAdapter.setDropDownViewResource(R.layout.recurrencepicker_freq_item);
        this.mFreqSpinner.setAdapter((SpinnerAdapter)freqAdapter);
        this.mInterval = (EditText)this.mView.findViewById(R.id.interval);
        this.mInterval.addTextChangedListener((TextWatcher)new minMaxTextWatcher(1, 1, 99){

            @Override
            void onChange(int v) {
                if (RecurrencePickerDialogFragment.this.mIntervalResId != -1 && RecurrencePickerDialogFragment.this.mInterval.getText().toString().length() > 0) {
                    ((RecurrencePickerDialogFragment)RecurrencePickerDialogFragment.this).mModel.interval = v;
                    RecurrencePickerDialogFragment.this.updateIntervalText();
                    RecurrencePickerDialogFragment.this.mInterval.requestLayout();
                }
            }
        });
        this.mIntervalPreText = (TextView)this.mView.findViewById(R.id.intervalPreText);
        this.mIntervalPostText = (TextView)this.mView.findViewById(R.id.intervalPostText);
        this.mEndNeverStr = this.mResources.getString(R.string.recurrence_end_continously);
        this.mEndDateLabel = this.mResources.getString(R.string.recurrence_end_date_label);
        this.mEndCountLabel = this.mResources.getString(R.string.recurrence_end_count_label);
        this.mEndSpinnerArray.add(this.mEndNeverStr);
        this.mEndSpinnerArray.add(this.mEndDateLabel);
        this.mEndSpinnerArray.add(this.mEndCountLabel);
        this.mEndSpinner = (Spinner)this.mView.findViewById(R.id.endSpinner);
        this.mEndSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.mEndSpinnerAdapter = new EndSpinnerAdapter((Context)this.getActivity(), this.mEndSpinnerArray, R.layout.recurrencepicker_freq_item, R.layout.recurrencepicker_end_text);
        this.mEndSpinnerAdapter.setDropDownViewResource(R.layout.recurrencepicker_freq_item);
        this.mEndSpinner.setAdapter((SpinnerAdapter)this.mEndSpinnerAdapter);
        this.mEndCount = (EditText)this.mView.findViewById(R.id.endCount);
        this.mEndCount.addTextChangedListener((TextWatcher)new minMaxTextWatcher(1, 5, 730){

            @Override
            void onChange(int v) {
                if (((RecurrencePickerDialogFragment)RecurrencePickerDialogFragment.this).mModel.endCount != v) {
                    ((RecurrencePickerDialogFragment)RecurrencePickerDialogFragment.this).mModel.endCount = v;
                    RecurrencePickerDialogFragment.this.updateEndCountText();
                    RecurrencePickerDialogFragment.this.mEndCount.requestLayout();
                }
            }
        });
        this.mPostEndCount = (TextView)this.mView.findViewById(R.id.postEndCount);
        this.mEndDateTextView = (TextView)this.mView.findViewById(R.id.endDate);
        this.mEndDateTextView.setOnClickListener((View.OnClickListener)this);
        if (this.mModel.endDate == null) {
            this.mModel.endDate = new Time(this.mTime);
            switch (this.mModel.freq) {
                case 0: 
                case 1: 
                case 2: {
                    ++this.mModel.endDate.month;
                    break;
                }
                case 3: {
                    this.mModel.endDate.month += 3;
                    break;
                }
                case 4: {
                    this.mModel.endDate.year += 3;
                }
            }
            this.mModel.endDate.normalize(false);
        }
        this.mWeekGroup = (LinearLayout)this.mView.findViewById(R.id.weekGroup);
        this.mWeekGroup2 = (LinearLayout)this.mView.findViewById(R.id.weekGroup2);
        String[] dayOfWeekString = new DateFormatSymbols().getWeekdays();
        this.mMonthRepeatByDayOfWeekStrs = new String[7][];
        this.mMonthRepeatByDayOfWeekStrs[0] = this.mResources.getStringArray(R.array.repeat_by_nth_sun);
        this.mMonthRepeatByDayOfWeekStrs[1] = this.mResources.getStringArray(R.array.repeat_by_nth_mon);
        this.mMonthRepeatByDayOfWeekStrs[2] = this.mResources.getStringArray(R.array.repeat_by_nth_tues);
        this.mMonthRepeatByDayOfWeekStrs[3] = this.mResources.getStringArray(R.array.repeat_by_nth_wed);
        this.mMonthRepeatByDayOfWeekStrs[4] = this.mResources.getStringArray(R.array.repeat_by_nth_thurs);
        this.mMonthRepeatByDayOfWeekStrs[5] = this.mResources.getStringArray(R.array.repeat_by_nth_fri);
        this.mMonthRepeatByDayOfWeekStrs[6] = this.mResources.getStringArray(R.array.repeat_by_nth_sat);
        int idx = Utils.getFirstDayOfWeek((Context)this.getActivity());
        dayOfWeekString = new DateFormatSymbols().getShortWeekdays();
        if (Build.VERSION.SDK_INT < 13) {
            Display display = this.getActivity().getWindowManager().getDefaultDisplay();
            DisplayMetrics outMetrics = new DisplayMetrics();
            display.getMetrics(outMetrics);
            float density = this.getResources().getDisplayMetrics().density;
            float dpWidth = (float)outMetrics.widthPixels / density;
            if (dpWidth > 450.0f) {
                numOfButtonsInRow1 = 7;
                numOfButtonsInRow2 = 0;
                this.mWeekGroup2.setVisibility(8);
                this.mWeekGroup2.getChildAt(3).setVisibility(8);
            } else {
                numOfButtonsInRow1 = 4;
                numOfButtonsInRow2 = 3;
                this.mWeekGroup2.setVisibility(0);
                this.mWeekGroup2.getChildAt(3).setVisibility(4);
            }
        } else if (this.mResources.getConfiguration().screenWidthDp > 450) {
            numOfButtonsInRow1 = 7;
            numOfButtonsInRow2 = 0;
            this.mWeekGroup2.setVisibility(8);
            this.mWeekGroup2.getChildAt(3).setVisibility(8);
        } else {
            numOfButtonsInRow1 = 4;
            numOfButtonsInRow2 = 3;
            this.mWeekGroup2.setVisibility(0);
            this.mWeekGroup2.getChildAt(3).setVisibility(4);
        }
        for (i = 0; i < 7; ++i) {
            if (i >= numOfButtonsInRow1) {
                this.mWeekGroup.getChildAt(i).setVisibility(8);
                continue;
            }
            this.mWeekByDayButtons[idx] = (ToggleButton)this.mWeekGroup.getChildAt(i);
            this.mWeekByDayButtons[idx].setTextOff((CharSequence)dayOfWeekString[this.TIME_DAY_TO_CALENDAR_DAY[idx]]);
            this.mWeekByDayButtons[idx].setTextOn((CharSequence)dayOfWeekString[this.TIME_DAY_TO_CALENDAR_DAY[idx]]);
            this.mWeekByDayButtons[idx].setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            if (++idx < 7) continue;
            idx = 0;
        }
        for (i = 0; i < 3; ++i) {
            if (i >= numOfButtonsInRow2) {
                this.mWeekGroup2.getChildAt(i).setVisibility(8);
                continue;
            }
            this.mWeekByDayButtons[idx] = (ToggleButton)this.mWeekGroup2.getChildAt(i);
            this.mWeekByDayButtons[idx].setTextOff((CharSequence)dayOfWeekString[this.TIME_DAY_TO_CALENDAR_DAY[idx]]);
            this.mWeekByDayButtons[idx].setTextOn((CharSequence)dayOfWeekString[this.TIME_DAY_TO_CALENDAR_DAY[idx]]);
            this.mWeekByDayButtons[idx].setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            if (++idx < 7) continue;
            idx = 0;
        }
        this.mMonthGroup = (LinearLayout)this.mView.findViewById(R.id.monthGroup);
        this.mMonthRepeatByRadioGroup = (RadioGroup)this.mView.findViewById(R.id.monthGroup);
        this.mMonthRepeatByRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.mRepeatMonthlyByNthDayOfWeek = (RadioButton)this.mView.findViewById(R.id.repeatMonthlyByNthDayOfTheWeek);
        this.mRepeatMonthlyByNthDayOfMonth = (RadioButton)this.mView.findViewById(R.id.repeatMonthlyByNthDayOfMonth);
        this.mDoneButton = (Button)this.mView.findViewById(R.id.done_button);
        this.mDoneButton.setOnClickListener((View.OnClickListener)this);
        Button cancelButton = (Button)this.mView.findViewById(R.id.cancel_button);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RecurrencePickerDialogFragment.this.dismiss();
            }
        });
        this.togglePickerOptions();
        this.updateDialog();
        if (endCountHasFocus) {
            this.mEndCount.requestFocus();
        }
        return this.mView;
    }

    private void togglePickerOptions() {
        if (this.mModel.recurrenceState == 0) {
            this.mFreqSpinner.setEnabled(false);
            this.mEndSpinner.setEnabled(false);
            this.mIntervalPreText.setEnabled(false);
            this.mInterval.setEnabled(false);
            this.mIntervalPostText.setEnabled(false);
            this.mMonthRepeatByRadioGroup.setEnabled(false);
            this.mEndCount.setEnabled(false);
            this.mPostEndCount.setEnabled(false);
            this.mEndDateTextView.setEnabled(false);
            this.mRepeatMonthlyByNthDayOfWeek.setEnabled(false);
            this.mRepeatMonthlyByNthDayOfMonth.setEnabled(false);
            for (ToggleButton button : this.mWeekByDayButtons) {
                button.setEnabled(false);
            }
        } else {
            this.mView.findViewById(R.id.options).setEnabled(true);
            this.mFreqSpinner.setEnabled(true);
            this.mEndSpinner.setEnabled(true);
            this.mIntervalPreText.setEnabled(true);
            this.mInterval.setEnabled(true);
            this.mIntervalPostText.setEnabled(true);
            this.mMonthRepeatByRadioGroup.setEnabled(true);
            this.mEndCount.setEnabled(true);
            this.mPostEndCount.setEnabled(true);
            this.mEndDateTextView.setEnabled(true);
            this.mRepeatMonthlyByNthDayOfWeek.setEnabled(true);
            this.mRepeatMonthlyByNthDayOfMonth.setEnabled(true);
            for (ToggleButton button : this.mWeekByDayButtons) {
                button.setEnabled(true);
            }
        }
        this.updateDoneButtonState();
    }

    private void updateDoneButtonState() {
        if (this.mModel.recurrenceState == 0) {
            this.mDoneButton.setEnabled(true);
            return;
        }
        if (this.mInterval.getText().toString().length() == 0) {
            this.mDoneButton.setEnabled(false);
            return;
        }
        if (this.mEndCount.getVisibility() == 0 && this.mEndCount.getText().toString().length() == 0) {
            this.mDoneButton.setEnabled(false);
            return;
        }
        if (this.mModel.freq == 2) {
            for (ToggleButton b : this.mWeekByDayButtons) {
                if (!b.isChecked()) continue;
                this.mDoneButton.setEnabled(true);
                return;
            }
            this.mDoneButton.setEnabled(false);
            return;
        }
        this.mDoneButton.setEnabled(true);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(BUNDLE_MODEL, (Parcelable)this.mModel);
        if (this.mEndCount.hasFocus()) {
            outState.putBoolean(BUNDLE_END_COUNT_HAS_FOCUS, true);
        }
    }

    public void updateDialog() {
        String countStr;
        String intervalStr = Integer.toString(this.mModel.interval);
        if (!intervalStr.equals(this.mInterval.getText().toString())) {
            this.mInterval.setText((CharSequence)intervalStr);
        }
        this.mFreqSpinner.setSelection(this.mModel.freq);
        this.mWeekGroup.setVisibility(this.mModel.freq == 2 ? 0 : 8);
        this.mWeekGroup2.setVisibility(this.mModel.freq == 2 ? 0 : 8);
        this.mMonthGroup.setVisibility(this.mModel.freq == 3 ? 0 : 8);
        switch (this.mModel.freq) {
            case 0: {
                this.mIntervalResId = R.plurals.recurrence_interval_hourly;
                break;
            }
            case 1: {
                this.mIntervalResId = R.plurals.recurrence_interval_daily;
                break;
            }
            case 2: {
                this.mIntervalResId = R.plurals.recurrence_interval_weekly;
                for (int i = 0; i < 7; ++i) {
                    this.mWeekByDayButtons[i].setChecked(this.mModel.weeklyByDayOfWeek[i]);
                }
                break;
            }
            case 3: {
                this.mIntervalResId = R.plurals.recurrence_interval_monthly;
                if (this.mModel.monthlyRepeat == 0) {
                    this.mMonthRepeatByRadioGroup.check(R.id.repeatMonthlyByNthDayOfMonth);
                } else if (this.mModel.monthlyRepeat == 1) {
                    this.mMonthRepeatByRadioGroup.check(R.id.repeatMonthlyByNthDayOfTheWeek);
                }
                if (this.mMonthRepeatByDayOfWeekStr != null) break;
                if (this.mModel.monthlyByNthDayOfWeek == 0) {
                    this.mModel.monthlyByNthDayOfWeek = (this.mTime.monthDay + 6) / 7;
                    if (this.mModel.monthlyByNthDayOfWeek >= 5) {
                        this.mModel.monthlyByNthDayOfWeek = -1;
                    }
                    this.mModel.monthlyByDayOfWeek = this.mTime.weekDay;
                }
                String[] monthlyByNthDayOfWeekStrs = this.mMonthRepeatByDayOfWeekStrs[this.mModel.monthlyByDayOfWeek];
                int msgIndex = this.mModel.monthlyByNthDayOfWeek < 0 ? 5 : this.mModel.monthlyByNthDayOfWeek;
                this.mMonthRepeatByDayOfWeekStr = monthlyByNthDayOfWeekStrs[msgIndex - 1];
                this.mRepeatMonthlyByNthDayOfWeek.setText((CharSequence)this.mMonthRepeatByDayOfWeekStr);
                break;
            }
            case 4: {
                this.mIntervalResId = R.plurals.recurrence_interval_yearly;
            }
        }
        this.updateIntervalText();
        this.updateDoneButtonState();
        this.mEndSpinner.setSelection(this.mModel.end);
        if (this.mModel.end == 1) {
            String dateStr = DateUtils.formatDateTime((Context)this.getActivity(), (long)this.mModel.endDate.toMillis(false), (int)131072);
            this.mEndDateTextView.setText((CharSequence)dateStr);
        } else if (this.mModel.end == 2 && !(countStr = Integer.toString(this.mModel.endCount)).equals(this.mEndCount.getText().toString())) {
            this.mEndCount.setText((CharSequence)countStr);
        }
    }

    private void setEndSpinnerEndDateStr(String endDateString) {
        this.mEndSpinnerArray.set(1, endDateString);
        this.mEndSpinnerAdapter.notifyDataSetChanged();
    }

    private void doToast() {
        String rrule;
        Log.e((String)TAG, (String)("Model = " + this.mModel.toString()));
        if (this.mModel.recurrenceState == 0) {
            rrule = "Not repeating";
        } else {
            RecurrencePickerDialogFragment.copyModelToEventRecurrence(this.mModel, this.mRecurrence);
            rrule = this.mRecurrence.toString();
        }
        if (this.mToast != null) {
            this.mToast.cancel();
        }
        this.mToast = Toast.makeText((Context)this.getActivity(), (CharSequence)rrule, (int)1);
        this.mToast.show();
    }

    private void updateIntervalText() {
        if (this.mIntervalResId == -1) {
            return;
        }
        String INTERVAL_COUNT_MARKER = "%d";
        String intervalString = this.mResources.getQuantityString(this.mIntervalResId, this.mModel.interval);
        int markerStart = intervalString.indexOf("%d");
        if (markerStart != -1) {
            int postTextStart = markerStart + "%d".length();
            this.mIntervalPostText.setText((CharSequence)intervalString.substring(postTextStart, intervalString.length()).trim());
            this.mIntervalPreText.setText((CharSequence)intervalString.substring(0, markerStart).trim());
        }
    }

    private void updateEndCountText() {
        String END_COUNT_MARKER = "%d";
        String endString = this.mResources.getQuantityString(R.plurals.recurrence_end_count, this.mModel.endCount);
        int markerStart = endString.indexOf("%d");
        if (markerStart != -1) {
            if (markerStart == 0) {
                Log.e((String)TAG, (String)"No text to put in to recurrence's end spinner.");
            } else {
                int postTextStart = markerStart + "%d".length();
                this.mPostEndCount.setText((CharSequence)endString.substring(postTextStart, endString.length()).trim());
            }
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        if (parent == this.mFreqSpinner) {
            this.mModel.freq = position;
        } else if (parent == this.mEndSpinner) {
            switch (position) {
                case 0: {
                    this.mModel.end = 0;
                    break;
                }
                case 1: {
                    this.mModel.end = 1;
                    break;
                }
                case 2: {
                    this.mModel.end = 2;
                    if (this.mModel.endCount <= 1) {
                        this.mModel.endCount = 1;
                    } else if (this.mModel.endCount > 730) {
                        this.mModel.endCount = 730;
                    }
                    this.updateEndCountText();
                }
            }
            this.mEndCount.setVisibility(this.mModel.end == 2 ? 0 : 8);
            this.mEndDateTextView.setVisibility(this.mModel.end == 1 ? 0 : 8);
            this.mPostEndCount.setVisibility(this.mModel.end == 2 && !this.mHidePostEndCount ? 0 : 8);
        }
        this.updateDialog();
    }

    public void onNothingSelected(AdapterView<?> arg0) {
    }

    @Override
    public void onDateSet(CalendarDatePickerDialogFragment view, int year, int monthOfYear, int dayOfMonth) {
        if (this.mModel.endDate == null) {
            this.mModel.endDate = new Time(this.mTime.timezone);
            this.mModel.endDate.second = 0;
            this.mModel.endDate.minute = 0;
            this.mModel.endDate.hour = 0;
        }
        this.mModel.endDate.year = year;
        this.mModel.endDate.month = monthOfYear;
        this.mModel.endDate.monthDay = dayOfMonth;
        this.mModel.endDate.normalize(false);
        this.updateDialog();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int itemIdx = -1;
        for (int i = 0; i < 7; ++i) {
            if (itemIdx != -1 || buttonView != this.mWeekByDayButtons[i]) continue;
            itemIdx = i;
            this.mModel.weeklyByDayOfWeek[i] = isChecked;
        }
        this.updateDialog();
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (checkedId == R.id.repeatMonthlyByNthDayOfMonth) {
            this.mModel.monthlyRepeat = 0;
        } else if (checkedId == R.id.repeatMonthlyByNthDayOfTheWeek) {
            this.mModel.monthlyRepeat = 1;
        }
        this.updateDialog();
    }

    public void onClick(View v) {
        if (this.mEndDateTextView == v) {
            if (this.mDatePickerDialog != null) {
                this.mDatePickerDialog.dismiss();
            }
            this.mDatePickerDialog = new CalendarDatePickerDialogFragment();
            this.mDatePickerDialog.setOnDateSetListener(this);
            this.mDatePickerDialog.setPreselectedDate(this.mModel.endDate.year, this.mModel.endDate.month, this.mModel.endDate.monthDay);
            this.mDatePickerDialog.setFirstDayOfWeek(Utils.getFirstDayOfWeekAsCalendar((Context)this.getActivity()));
            this.mDatePickerDialog.show(this.getFragmentManager(), FRAG_TAG_DATE_PICKER);
        } else if (this.mDoneButton == v) {
            String rrule;
            if (this.mModel.recurrenceState == 0) {
                rrule = null;
            } else {
                RecurrencePickerDialogFragment.copyModelToEventRecurrence(this.mModel, this.mRecurrence);
                rrule = this.mRecurrence.toString();
            }
            this.mRecurrenceSetListener.onRecurrenceSet(rrule);
            this.dismiss();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mDatePickerDialog = (CalendarDatePickerDialogFragment)this.getFragmentManager().findFragmentByTag(FRAG_TAG_DATE_PICKER);
        if (this.mDatePickerDialog != null) {
            this.mDatePickerDialog.setOnDateSetListener(this);
        }
    }

    public void setOnRecurrenceSetListener(OnRecurrenceSetListener l) {
        this.mRecurrenceSetListener = l;
    }

    private class EndSpinnerAdapter
    extends ArrayAdapter<CharSequence> {
        final String END_DATE_MARKER = "%s";
        final String END_COUNT_MARKER = "%d";
        private LayoutInflater mInflater;
        private int mItemResourceId;
        private int mTextResourceId;
        private ArrayList<CharSequence> mStrings;
        private String mEndDateString;
        private boolean mUseFormStrings;

        public EndSpinnerAdapter(Context context, ArrayList<CharSequence> strings, int itemResourceId, int textResourceId) {
            super(context, itemResourceId, strings);
            this.END_DATE_MARKER = "%s";
            this.END_COUNT_MARKER = "%d";
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mItemResourceId = itemResourceId;
            this.mTextResourceId = textResourceId;
            this.mStrings = strings;
            this.mEndDateString = RecurrencePickerDialogFragment.this.getResources().getString(R.string.recurrence_end_date);
            int markerStart = this.mEndDateString.indexOf("%s");
            if (markerStart <= 0) {
                this.mUseFormStrings = true;
            } else {
                String countEndStr = RecurrencePickerDialogFragment.this.getResources().getQuantityString(R.plurals.recurrence_end_count, 1);
                markerStart = countEndStr.indexOf("%d");
                if (markerStart <= 0) {
                    this.mUseFormStrings = true;
                }
            }
            if (this.mUseFormStrings) {
                RecurrencePickerDialogFragment.this.mEndSpinner.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(0, -2, 1.0f));
            }
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView == null ? this.mInflater.inflate(this.mTextResourceId, parent, false) : convertView;
            TextView item = (TextView)v.findViewById(R.id.spinner_item);
            switch (position) {
                case 0: {
                    item.setText(this.mStrings.get(0));
                    break;
                }
                case 1: {
                    int markerStart = this.mEndDateString.indexOf("%s");
                    if (markerStart == -1) break;
                    if (this.mUseFormStrings || markerStart == 0) {
                        item.setText((CharSequence)RecurrencePickerDialogFragment.this.mEndDateLabel);
                        break;
                    }
                    item.setText((CharSequence)this.mEndDateString.substring(0, markerStart).trim());
                    break;
                }
                case 2: {
                    String endString = RecurrencePickerDialogFragment.this.mResources.getQuantityString(R.plurals.recurrence_end_count, ((RecurrencePickerDialogFragment)RecurrencePickerDialogFragment.this).mModel.endCount);
                    int markerStart = endString.indexOf("%d");
                    if (markerStart == -1) break;
                    if (this.mUseFormStrings || markerStart == 0) {
                        item.setText((CharSequence)RecurrencePickerDialogFragment.this.mEndCountLabel);
                        RecurrencePickerDialogFragment.this.mPostEndCount.setVisibility(8);
                        RecurrencePickerDialogFragment.this.mHidePostEndCount = true;
                        break;
                    }
                    int postTextStart = markerStart + "%d".length();
                    RecurrencePickerDialogFragment.this.mPostEndCount.setText((CharSequence)endString.substring(postTextStart, endString.length()).trim());
                    if (((RecurrencePickerDialogFragment)RecurrencePickerDialogFragment.this).mModel.end == 2) {
                        RecurrencePickerDialogFragment.this.mPostEndCount.setVisibility(0);
                    }
                    if (endString.charAt(markerStart - 1) == ' ') {
                        --markerStart;
                    }
                    item.setText((CharSequence)endString.substring(0, markerStart).trim());
                    break;
                }
                default: {
                    v = null;
                }
            }
            return v;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            View v = convertView == null ? this.mInflater.inflate(this.mItemResourceId, parent, false) : convertView;
            TextView item = (TextView)v.findViewById(R.id.spinner_item);
            item.setText(this.mStrings.get(position));
            return v;
        }
    }

    public static interface OnRecurrenceSetListener {
        public void onRecurrenceSet(String var1);
    }

    class minMaxTextWatcher
    implements TextWatcher {
        private int mMin;
        private int mMax;
        private int mDefault;

        public minMaxTextWatcher(int min, int defaultInt, int max) {
            this.mMin = min;
            this.mMax = max;
            this.mDefault = defaultInt;
        }

        public void afterTextChanged(Editable s) {
            int value;
            boolean updated = false;
            try {
                value = Integer.parseInt(s.toString());
            }
            catch (NumberFormatException e) {
                value = this.mDefault;
            }
            if (value < this.mMin) {
                value = this.mMin;
                updated = true;
            } else if (value > this.mMax) {
                updated = true;
                value = this.mMax;
            }
            if (updated) {
                s.clear();
                s.append((CharSequence)Integer.toString(value));
            }
            RecurrencePickerDialogFragment.this.updateDoneButtonState();
            this.onChange(value);
        }

        void onChange(int value) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    }

    private static class RecurrenceModel
    implements Parcelable {
        static final int FREQ_HOURLY = 0;
        static final int FREQ_DAILY = 1;
        static final int FREQ_WEEKLY = 2;
        static final int FREQ_MONTHLY = 3;
        static final int FREQ_YEARLY = 4;
        static final int END_NEVER = 0;
        static final int END_BY_DATE = 1;
        static final int END_BY_COUNT = 2;
        static final int MONTHLY_BY_DATE = 0;
        static final int MONTHLY_BY_NTH_DAY_OF_WEEK = 1;
        static final int STATE_NO_RECURRENCE = 0;
        static final int STATE_RECURRENCE = 1;
        int recurrenceState;
        int freq = 2;
        int interval = 1;
        int end;
        Time endDate;
        int endCount = 5;
        boolean[] weeklyByDayOfWeek = new boolean[7];
        int monthlyRepeat;
        int monthlyByMonthDay;
        int monthlyByDayOfWeek;
        int monthlyByNthDayOfWeek;
        boolean forceHideSwitchButton;
        public static final Parcelable.Creator<RecurrenceModel> CREATOR = new Parcelable.Creator<RecurrenceModel>(){

            public RecurrenceModel createFromParcel(Parcel source) {
                return new RecurrenceModel(source);
            }

            public RecurrenceModel[] newArray(int size) {
                return new RecurrenceModel[size];
            }
        };

        public String toString() {
            return "Model [freq=" + this.freq + ", interval=" + this.interval + ", end=" + this.end + ", endDate=" + this.endDate + ", endCount=" + this.endCount + ", weeklyByDayOfWeek=" + Arrays.toString(this.weeklyByDayOfWeek) + ", monthlyRepeat=" + this.monthlyRepeat + ", monthlyByMonthDay=" + this.monthlyByMonthDay + ", monthlyByDayOfWeek=" + this.monthlyByDayOfWeek + ", monthlyByNthDayOfWeek=" + this.monthlyByNthDayOfWeek + "]";
        }

        public RecurrenceModel() {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.recurrenceState);
            dest.writeInt(this.freq);
            dest.writeInt(this.interval);
            dest.writeInt(this.end);
            dest.writeInt(this.endDate.year);
            dest.writeInt(this.endDate.month);
            dest.writeInt(this.endDate.monthDay);
            dest.writeInt(this.endCount);
            dest.writeBooleanArray(this.weeklyByDayOfWeek);
            dest.writeInt(this.monthlyRepeat);
            dest.writeInt(this.monthlyByMonthDay);
            dest.writeInt(this.monthlyByDayOfWeek);
            dest.writeInt(this.monthlyByNthDayOfWeek);
            dest.writeByte((byte)(this.forceHideSwitchButton ? 1 : 0));
        }

        private RecurrenceModel(Parcel in) {
            this.recurrenceState = in.readInt();
            this.freq = in.readInt();
            this.interval = in.readInt();
            this.end = in.readInt();
            this.endDate = new Time();
            this.endDate.year = in.readInt();
            this.endDate.month = in.readInt();
            this.endDate.monthDay = in.readInt();
            this.endCount = in.readInt();
            this.weeklyByDayOfWeek = in.createBooleanArray();
            this.monthlyRepeat = in.readInt();
            this.monthlyByMonthDay = in.readInt();
            this.monthlyByDayOfWeek = in.readInt();
            this.monthlyByNthDayOfWeek = in.readInt();
            this.forceHideSwitchButton = in.readByte() != 0;
        }
    }
}

