/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timepicker.TimerView;
import java.text.DateFormatSymbols;

public class TimePicker
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    protected int mInputSize = 4;
    protected final Button[] mNumbers = new Button[10];
    protected int[] mInput = new int[this.mInputSize];
    protected int mInputPointer = -1;
    protected Button mLeft;
    protected Button mRight;
    protected ImageButton mDelete;
    protected TimerView mEnteredTime;
    protected final Context mContext;
    private TextView mAmPmLabel;
    private String[] mAmpm;
    private final String mNoAmPmLabel;
    private int mAmPmState;
    private Button mSetButton;
    private boolean mIs24HoursMode = false;
    private static final int AMPM_NOT_SELECTED = 0;
    private static final int PM_SELECTED = 1;
    private static final int AM_SELECTED = 2;
    private static final int HOURS24_MODE = 3;
    private static final String TIME_PICKER_SAVED_BUFFER_POINTER = "timer_picker_saved_buffer_pointer";
    private static final String TIME_PICKER_SAVED_INPUT = "timer_picker_saved_input";
    private static final String TIME_PICKER_SAVED_AMPM = "timer_picker_saved_ampm";
    protected View mDivider;
    private ColorStateList mTextColor;
    private int mKeyBackgroundResId;
    private int mButtonBackgroundResId;
    private int mDividerColor;
    private int mDeleteDrawableSrcResId;
    private int mTheme = -1;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mIs24HoursMode = TimePicker.get24HourMode(this.mContext);
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        layoutInflater.inflate(this.getLayoutId(), (ViewGroup)this);
        this.mNoAmPmLabel = context.getResources().getString(R.string.time_picker_ampm_label);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mKeyBackgroundResId = R.drawable.key_background_dark;
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mDeleteDrawableSrcResId = R.drawable.ic_backspace_dark;
    }

    protected int getLayoutId() {
        return R.layout.time_picker_view;
    }

    public void setTheme(int themeResId) {
        this.mTheme = themeResId;
        if (this.mTheme != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mKeyBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpKeyBackground, this.mKeyBackgroundResId);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpDividerColor, this.mDividerColor);
            this.mDeleteDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDeleteIcon, this.mDeleteDrawableSrcResId);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        for (Button number : this.mNumbers) {
            if (number == null) continue;
            number.setTextColor(this.mTextColor);
            number.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(this.mDividerColor);
        }
        if (this.mLeft != null) {
            this.mLeft.setTextColor(this.mTextColor);
            this.mLeft.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mAmPmLabel != null) {
            this.mAmPmLabel.setTextColor(this.mTextColor);
            this.mAmPmLabel.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mRight != null) {
            this.mRight.setTextColor(this.mTextColor);
            this.mRight.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDelete != null) {
            this.mDelete.setBackgroundResource(this.mButtonBackgroundResId);
            this.mDelete.setImageDrawable(this.getResources().getDrawable(this.mDeleteDrawableSrcResId));
        }
        if (this.mEnteredTime != null) {
            this.mEnteredTime.setTheme(this.mTheme);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View v1 = this.findViewById(R.id.first);
        View v2 = this.findViewById(R.id.second);
        View v3 = this.findViewById(R.id.third);
        View v4 = this.findViewById(R.id.fourth);
        this.mEnteredTime = (TimerView)this.findViewById(R.id.timer_time_text);
        this.mDelete = (ImageButton)this.findViewById(R.id.delete);
        this.mDelete.setOnClickListener((View.OnClickListener)this);
        this.mDelete.setOnLongClickListener((View.OnLongClickListener)this);
        this.mNumbers[1] = (Button)v1.findViewById(R.id.key_left);
        this.mNumbers[2] = (Button)v1.findViewById(R.id.key_middle);
        this.mNumbers[3] = (Button)v1.findViewById(R.id.key_right);
        this.mNumbers[4] = (Button)v2.findViewById(R.id.key_left);
        this.mNumbers[5] = (Button)v2.findViewById(R.id.key_middle);
        this.mNumbers[6] = (Button)v2.findViewById(R.id.key_right);
        this.mNumbers[7] = (Button)v3.findViewById(R.id.key_left);
        this.mNumbers[8] = (Button)v3.findViewById(R.id.key_middle);
        this.mNumbers[9] = (Button)v3.findViewById(R.id.key_right);
        this.mLeft = (Button)v4.findViewById(R.id.key_left);
        this.mNumbers[0] = (Button)v4.findViewById(R.id.key_middle);
        this.mRight = (Button)v4.findViewById(R.id.key_right);
        this.setLeftRightEnabled(false);
        for (int i = 0; i < 10; ++i) {
            this.mNumbers[i].setOnClickListener((View.OnClickListener)this);
            this.mNumbers[i].setText((CharSequence)String.format("%d", i));
            this.mNumbers[i].setTag(R.id.numbers_key, (Object)new Integer(i));
        }
        this.updateTime();
        Resources res = this.mContext.getResources();
        this.mAmpm = new DateFormatSymbols().getAmPmStrings();
        if (this.mIs24HoursMode) {
            this.mLeft.setText((CharSequence)res.getString(R.string.time_picker_00_label));
            this.mRight.setText((CharSequence)res.getString(R.string.time_picker_30_label));
        } else {
            this.mLeft.setText((CharSequence)this.mAmpm[0]);
            this.mRight.setText((CharSequence)this.mAmpm[1]);
        }
        this.mLeft.setOnClickListener((View.OnClickListener)this);
        this.mRight.setOnClickListener((View.OnClickListener)this);
        this.mAmPmLabel = (TextView)this.findViewById(R.id.ampm_label);
        this.mAmPmState = 0;
        this.mDivider = this.findViewById(R.id.divider);
        this.restyleViews();
        this.updateKeypad();
    }

    public void updateDeleteButton() {
        boolean enabled;
        boolean bl = enabled = this.mInputPointer != -1;
        if (this.mDelete != null) {
            this.mDelete.setEnabled(enabled);
        }
    }

    public void onClick(View v) {
        v.performHapticFeedback(1);
        this.doOnClick(v);
        this.updateDeleteButton();
    }

    protected void doOnClick(View v) {
        Integer val = (Integer)v.getTag(R.id.numbers_key);
        if (val != null) {
            this.addClickedNumber(val);
        } else if (v == this.mDelete) {
            if (!this.mIs24HoursMode && this.mAmPmState != 0) {
                this.mAmPmState = 0;
            } else if (this.mInputPointer >= 0) {
                for (int i = 0; i < this.mInputPointer; ++i) {
                    this.mInput[i] = this.mInput[i + 1];
                }
                this.mInput[this.mInputPointer] = 0;
                --this.mInputPointer;
            }
        } else if (v == this.mLeft) {
            this.onLeftClicked();
        } else if (v == this.mRight) {
            this.onRightClicked();
        }
        this.updateKeypad();
    }

    public boolean onLongClick(View v) {
        v.performHapticFeedback(0);
        if (v == this.mDelete) {
            this.mDelete.setPressed(false);
            this.mAmPmState = 0;
            this.reset();
            this.updateKeypad();
            return true;
        }
        return false;
    }

    public void reset() {
        for (int i = 0; i < this.mInputSize; ++i) {
            this.mInput[i] = 0;
        }
        this.mInputPointer = -1;
        this.updateTime();
    }

    private void updateKeypad() {
        this.showAmPm();
        this.updateLeftRightButtons();
        this.updateTime();
        this.updateNumericKeys();
        this.enableSetButton();
        this.updateDeleteButton();
    }

    protected void updateTime() {
        int hours1 = -1;
        int time = this.getEnteredTime();
        if (this.mInputPointer > -1) {
            if (this.mInputPointer >= 0) {
                int digit = this.mInput[this.mInputPointer];
                if (this.mIs24HoursMode && digit >= 3 && digit <= 9 || !this.mIs24HoursMode && digit >= 2 && digit <= 9) {
                    hours1 = -2;
                }
            }
            if (this.mInputPointer > 0 && this.mInputPointer < 3 && hours1 != -2) {
                int digits = this.mInput[this.mInputPointer] * 10 + this.mInput[this.mInputPointer - 1];
                if (this.mIs24HoursMode && digits >= 24 && digits <= 25 || !this.mIs24HoursMode && digits >= 13 && digits <= 15) {
                    hours1 = -2;
                }
            }
            if (this.mInputPointer == 3) {
                hours1 = this.mInput[3];
            }
        } else {
            hours1 = -1;
        }
        int hours2 = this.mInputPointer < 2 ? -1 : this.mInput[2];
        int minutes1 = this.mInputPointer < 1 ? -1 : this.mInput[1];
        int minutes2 = this.mInputPointer < 0 ? -1 : this.mInput[0];
        this.mEnteredTime.setTime(hours1, hours2, minutes1, minutes2);
    }

    private void showAmPm() {
        if (!this.mIs24HoursMode) {
            switch (this.mAmPmState) {
                case 0: {
                    this.mAmPmLabel.setText((CharSequence)this.mNoAmPmLabel);
                    break;
                }
                case 2: {
                    this.mAmPmLabel.setText((CharSequence)this.mAmpm[0]);
                    break;
                }
                case 1: {
                    this.mAmPmLabel.setText((CharSequence)this.mAmpm[1]);
                    break;
                }
            }
        } else {
            this.mAmPmLabel.setVisibility(4);
            this.mAmPmState = 3;
        }
    }

    private void addClickedNumber(int val) {
        if (this.mInputPointer < this.mInputSize - 1) {
            for (int i = this.mInputPointer; i >= 0; --i) {
                this.mInput[i + 1] = this.mInput[i];
            }
            ++this.mInputPointer;
            this.mInput[0] = val;
        }
    }

    private void onLeftClicked() {
        int time = this.getEnteredTime();
        if (!this.mIs24HoursMode) {
            if (this.canAddDigits()) {
                this.addClickedNumber(0);
                this.addClickedNumber(0);
            }
            this.mAmPmState = 2;
        } else if (this.canAddDigits()) {
            this.addClickedNumber(0);
            this.addClickedNumber(0);
        }
    }

    private void onRightClicked() {
        int time = this.getEnteredTime();
        if (!this.mIs24HoursMode) {
            if (this.canAddDigits()) {
                this.addClickedNumber(0);
                this.addClickedNumber(0);
            }
            this.mAmPmState = 1;
        } else if (this.canAddDigits()) {
            this.addClickedNumber(3);
            this.addClickedNumber(0);
        }
    }

    private boolean canAddDigits() {
        int time = this.getEnteredTime();
        if (!this.mIs24HoursMode) {
            return time >= 1 && time <= 12;
        }
        return time >= 0 && time <= 23 && this.mInputPointer > -1 && this.mInputPointer < 2;
    }

    private void updateNumericKeys() {
        int time = this.getEnteredTime();
        if (this.mIs24HoursMode) {
            if (this.mInputPointer >= 3) {
                this.setKeyRange(-1);
            } else if (time == 0) {
                if (this.mInputPointer == -1 || this.mInputPointer == 0 || this.mInputPointer == 2) {
                    this.setKeyRange(9);
                } else if (this.mInputPointer == 1) {
                    this.setKeyRange(5);
                } else {
                    this.setKeyRange(-1);
                }
            } else if (time == 1) {
                if (this.mInputPointer == 0 || this.mInputPointer == 2) {
                    this.setKeyRange(9);
                } else if (this.mInputPointer == 1) {
                    this.setKeyRange(5);
                } else {
                    this.setKeyRange(-1);
                }
            } else if (time == 2) {
                if (this.mInputPointer == 2 || this.mInputPointer == 1) {
                    this.setKeyRange(9);
                } else if (this.mInputPointer == 0) {
                    this.setKeyRange(3);
                } else {
                    this.setKeyRange(-1);
                }
            } else if (time <= 5) {
                this.setKeyRange(9);
            } else if (time <= 9) {
                this.setKeyRange(5);
            } else if (time >= 10 && time <= 15) {
                this.setKeyRange(9);
            } else if (time >= 16 && time <= 19) {
                this.setKeyRange(5);
            } else if (time >= 20 && time <= 25) {
                this.setKeyRange(9);
            } else if (time >= 26 && time <= 29) {
                this.setKeyRange(-1);
            } else if (time >= 30 && time <= 35) {
                this.setKeyRange(9);
            } else if (time >= 36 && time <= 39) {
                this.setKeyRange(-1);
            } else if (time >= 40 && time <= 45) {
                this.setKeyRange(9);
            } else if (time >= 46 && time <= 49) {
                this.setKeyRange(-1);
            } else if (time >= 50 && time <= 55) {
                this.setKeyRange(9);
            } else if (time >= 56 && time <= 59) {
                this.setKeyRange(-1);
            } else if (time >= 60 && time <= 65) {
                this.setKeyRange(9);
            } else if (time >= 70 && time <= 75) {
                this.setKeyRange(9);
            } else if (time >= 80 && time <= 85) {
                this.setKeyRange(9);
            } else if (time >= 90 && time <= 95) {
                this.setKeyRange(9);
            } else if (time >= 100 && time <= 105) {
                this.setKeyRange(9);
            } else if (time >= 106 && time <= 109) {
                this.setKeyRange(-1);
            } else if (time >= 110 && time <= 115) {
                this.setKeyRange(9);
            } else if (time >= 116 && time <= 119) {
                this.setKeyRange(-1);
            } else if (time >= 120 && time <= 125) {
                this.setKeyRange(9);
            } else if (time >= 126 && time <= 129) {
                this.setKeyRange(-1);
            } else if (time >= 130 && time <= 135) {
                this.setKeyRange(9);
            } else if (time >= 136 && time <= 139) {
                this.setKeyRange(-1);
            } else if (time >= 140 && time <= 145) {
                this.setKeyRange(9);
            } else if (time >= 146 && time <= 149) {
                this.setKeyRange(-1);
            } else if (time >= 150 && time <= 155) {
                this.setKeyRange(9);
            } else if (time >= 156 && time <= 159) {
                this.setKeyRange(-1);
            } else if (time >= 160 && time <= 165) {
                this.setKeyRange(9);
            } else if (time >= 166 && time <= 169) {
                this.setKeyRange(-1);
            } else if (time >= 170 && time <= 175) {
                this.setKeyRange(9);
            } else if (time >= 176 && time <= 179) {
                this.setKeyRange(-1);
            } else if (time >= 180 && time <= 185) {
                this.setKeyRange(9);
            } else if (time >= 186 && time <= 189) {
                this.setKeyRange(-1);
            } else if (time >= 190 && time <= 195) {
                this.setKeyRange(9);
            } else if (time >= 196 && time <= 199) {
                this.setKeyRange(-1);
            } else if (time >= 200 && time <= 205) {
                this.setKeyRange(9);
            } else if (time >= 206 && time <= 209) {
                this.setKeyRange(-1);
            } else if (time >= 210 && time <= 215) {
                this.setKeyRange(9);
            } else if (time >= 216 && time <= 219) {
                this.setKeyRange(-1);
            } else if (time >= 220 && time <= 225) {
                this.setKeyRange(9);
            } else if (time >= 226 && time <= 229) {
                this.setKeyRange(-1);
            } else if (time >= 230 && time <= 235) {
                this.setKeyRange(9);
            } else if (time >= 236) {
                this.setKeyRange(-1);
            }
        } else if (this.mAmPmState != 0) {
            this.setKeyRange(-1);
        } else if (time == 0) {
            this.setKeyRange(9);
            this.mNumbers[0].setEnabled(false);
        } else if (time <= 9) {
            this.setKeyRange(5);
        } else if (time <= 95) {
            this.setKeyRange(9);
        } else if (time >= 100 && time <= 105) {
            this.setKeyRange(9);
        } else if (time >= 106 && time <= 109) {
            this.setKeyRange(-1);
        } else if (time >= 110 && time <= 115) {
            this.setKeyRange(9);
        } else if (time >= 116 && time <= 119) {
            this.setKeyRange(-1);
        } else if (time >= 120 && time <= 125) {
            this.setKeyRange(9);
        } else if (time >= 126) {
            this.setKeyRange(-1);
        }
    }

    private int getEnteredTime() {
        return this.mInput[3] * 1000 + this.mInput[2] * 100 + this.mInput[1] * 10 + this.mInput[0];
    }

    private void setKeyRange(int maxKey) {
        for (int i = 0; i < this.mNumbers.length; ++i) {
            this.mNumbers[i].setEnabled(i <= maxKey);
        }
    }

    private void updateLeftRightButtons() {
        int time = this.getEnteredTime();
        if (this.mIs24HoursMode) {
            boolean enable = this.canAddDigits();
            this.mLeft.setEnabled(enable);
            this.mRight.setEnabled(enable);
        } else if (time > 12 && time < 100 || time == 0 || this.mAmPmState != 0) {
            this.mLeft.setEnabled(false);
            this.mRight.setEnabled(false);
        } else {
            this.mLeft.setEnabled(true);
            this.mRight.setEnabled(true);
        }
    }

    private void enableSetButton() {
        if (this.mSetButton == null) {
            return;
        }
        if (this.mInputPointer == -1) {
            this.mSetButton.setEnabled(false);
            return;
        }
        if (this.mIs24HoursMode) {
            int time = this.getEnteredTime();
            this.mSetButton.setEnabled(this.mInputPointer >= 2 && (time < 60 || time > 95));
        } else {
            this.mSetButton.setEnabled(this.mAmPmState != 0);
        }
    }

    public void setSetButton(Button b) {
        this.mSetButton = b;
        this.enableSetButton();
    }

    public int getHours() {
        int hours = this.mInput[3] * 10 + this.mInput[2];
        if (hours == 12) {
            switch (this.mAmPmState) {
                case 1: {
                    return 12;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return hours;
                }
            }
        }
        return hours + (this.mAmPmState == 1 ? 12 : 0);
    }

    public int getMinutes() {
        return this.mInput[1] * 10 + this.mInput[0];
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcel = super.onSaveInstanceState();
        SavedState state = new SavedState(parcel);
        state.mInput = this.mInput;
        state.mAmPmState = this.mAmPmState;
        state.mInputPointer = this.mInputPointer;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mInputPointer = savedState.mInputPointer;
        this.mInput = savedState.mInput;
        if (this.mInput == null) {
            this.mInput = new int[this.mInputSize];
            this.mInputPointer = -1;
        }
        this.mAmPmState = savedState.mAmPmState;
        this.updateKeypad();
    }

    public static boolean get24HourMode(Context context) {
        return DateFormat.is24HourFormat((Context)context);
    }

    public int getTime() {
        return this.mInput[4] * 3600 + this.mInput[3] * 600 + this.mInput[2] * 60 + this.mInput[1] * 10 + this.mInput[0];
    }

    public void saveEntryState(Bundle outState, String key) {
        outState.putIntArray(key, this.mInput);
    }

    public void restoreEntryState(Bundle inState, String key) {
        int[] input = inState.getIntArray(key);
        if (input != null && this.mInputSize == input.length) {
            for (int i = 0; i < this.mInputSize; ++i) {
                this.mInput[i] = input[i];
                if (this.mInput[i] == 0) continue;
                this.mInputPointer = i;
            }
            this.updateTime();
        }
    }

    protected void setLeftRightEnabled(boolean enabled) {
        this.mLeft.setEnabled(enabled);
        this.mRight.setEnabled(enabled);
        if (!enabled) {
            this.mLeft.setContentDescription(null);
            this.mRight.setContentDescription(null);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        int mInputPointer;
        int[] mInput;
        int mAmPmState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mInputPointer = in.readInt();
            in.readIntArray(this.mInput);
            this.mAmPmState = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mInputPointer);
            dest.writeIntArray(this.mInput);
            dest.writeInt(this.mAmPmState);
        }
    }
}

