/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timepicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.widget.ZeroTopPaddingTextView;

public class TimerView
extends LinearLayout {
    private ZeroTopPaddingTextView mHoursOnes;
    private ZeroTopPaddingTextView mMinutesOnes;
    private ZeroTopPaddingTextView mHoursTens;
    private ZeroTopPaddingTextView mMinutesTens;
    private final Typeface mAndroidClockMonoThin;
    private Typeface mOriginalHoursTypeface;
    private ZeroTopPaddingTextView mHoursSeperator;
    private ColorStateList mTextColor;

    public TimerView(Context context) {
        this(context, null);
    }

    public TimerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAndroidClockMonoThin = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/AndroidClockMono-Thin.ttf");
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
    }

    public void setTheme(int themeResId) {
        if (themeResId != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        if (this.mHoursOnes != null) {
            this.mHoursOnes.setTextColor(this.mTextColor);
        }
        if (this.mMinutesOnes != null) {
            this.mMinutesOnes.setTextColor(this.mTextColor);
        }
        if (this.mHoursTens != null) {
            this.mHoursTens.setTextColor(this.mTextColor);
        }
        if (this.mMinutesTens != null) {
            this.mMinutesTens.setTextColor(this.mTextColor);
        }
        if (this.mHoursSeperator != null) {
            this.mHoursSeperator.setTextColor(this.mTextColor);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mHoursTens = (ZeroTopPaddingTextView)this.findViewById(R.id.hours_tens);
        this.mMinutesTens = (ZeroTopPaddingTextView)this.findViewById(R.id.minutes_tens);
        this.mHoursOnes = (ZeroTopPaddingTextView)this.findViewById(R.id.hours_ones);
        this.mMinutesOnes = (ZeroTopPaddingTextView)this.findViewById(R.id.minutes_ones);
        this.mHoursSeperator = (ZeroTopPaddingTextView)this.findViewById(R.id.hours_seperator);
        if (this.mHoursOnes != null) {
            this.mOriginalHoursTypeface = this.mHoursOnes.getTypeface();
        }
        if (this.mMinutesTens != null) {
            this.mMinutesTens.setTypeface(this.mAndroidClockMonoThin);
            this.mMinutesTens.updatePadding();
        }
        if (this.mMinutesOnes != null) {
            this.mMinutesOnes.setTypeface(this.mAndroidClockMonoThin);
            this.mMinutesOnes.updatePadding();
        }
    }

    public void setTime(int hoursTensDigit, int hoursOnesDigit, int minutesTensDigit, int minutesOnesDigit) {
        if (this.mHoursTens != null) {
            if (hoursTensDigit == -2) {
                this.mHoursTens.setVisibility(4);
            } else if (hoursTensDigit == -1) {
                this.mHoursTens.setText("-");
                this.mHoursTens.setTypeface(this.mAndroidClockMonoThin);
                this.mHoursTens.setEnabled(false);
                this.mHoursTens.updatePadding();
                this.mHoursTens.setVisibility(0);
            } else {
                this.mHoursTens.setText(String.format("%d", hoursTensDigit));
                this.mHoursTens.setTypeface(this.mOriginalHoursTypeface);
                this.mHoursTens.setEnabled(true);
                this.mHoursTens.updatePaddingForBoldDate();
                this.mHoursTens.setVisibility(0);
            }
        }
        if (this.mHoursOnes != null) {
            if (hoursOnesDigit == -1) {
                this.mHoursOnes.setText("-");
                this.mHoursOnes.setTypeface(this.mAndroidClockMonoThin);
                this.mHoursOnes.setEnabled(false);
                this.mHoursOnes.updatePadding();
            } else {
                this.mHoursOnes.setText(String.format("%d", hoursOnesDigit));
                this.mHoursOnes.setTypeface(this.mOriginalHoursTypeface);
                this.mHoursOnes.setEnabled(true);
                this.mHoursOnes.updatePaddingForBoldDate();
            }
        }
        if (this.mMinutesTens != null) {
            if (minutesTensDigit == -1) {
                this.mMinutesTens.setText("-");
                this.mMinutesTens.setEnabled(false);
            } else {
                this.mMinutesTens.setEnabled(true);
                this.mMinutesTens.setText(String.format("%d", minutesTensDigit));
            }
        }
        if (this.mMinutesOnes != null) {
            if (minutesOnesDigit == -1) {
                this.mMinutesOnes.setText("-");
                this.mMinutesOnes.setEnabled(false);
            } else {
                this.mMinutesOnes.setText(String.format("%d", minutesOnesDigit));
                this.mMinutesOnes.setEnabled(true);
            }
        }
    }
}

