/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.text.format.DateFormat;
import android.util.Log;
import android.util.SparseArray;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.TimeZone;

public class TimeZoneData {
    private static final String TAG = "TimeZoneData";
    private static final boolean DEBUG = false;
    private static final int OFFSET_ARRAY_OFFSET = 20;
    private static final String PALESTINE_COUNTRY_CODE = "PS";
    ArrayList<TimeZoneInfo> mTimeZones;
    LinkedHashMap<String, ArrayList<Integer>> mTimeZonesByCountry;
    HashSet<String> mTimeZoneNames = new HashSet();
    private long mTimeMillis;
    private HashMap<String, String> mCountryCodeToNameMap = new HashMap();
    public String mDefaultTimeZoneId;
    public static boolean is24HourFormat;
    private TimeZoneInfo mDefaultTimeZoneInfo;
    private String mAlternateDefaultTimeZoneId;
    private String mDefaultTimeZoneCountry;
    private HashMap<String, TimeZoneInfo> mTimeZonesById;
    private boolean[] mHasTimeZonesInHrOffset = new boolean[40];
    SparseArray<ArrayList<Integer>> mTimeZonesByOffsets;
    private Context mContext;
    private String mPalestineDisplayName;
    private static Locale mBackupCountryLocale;
    private static String[] mBackupCountryCodes;
    private static String[] mBackupCountryNames;

    public TimeZoneData(Context context, String defaultTimeZoneId, long timeMillis) {
        this.mContext = context;
        is24HourFormat = TimeZoneInfo.is24HourFormat = DateFormat.is24HourFormat((Context)context);
        this.mDefaultTimeZoneId = this.mAlternateDefaultTimeZoneId = defaultTimeZoneId;
        long now = System.currentTimeMillis();
        this.mTimeMillis = timeMillis == 0L ? now : timeMillis;
        this.mPalestineDisplayName = context.getResources().getString(R.string.palestine_display_name);
        this.loadTzs(context);
        Log.i((String)TAG, (String)("Time to load time zones (ms): " + (System.currentTimeMillis() - now)));
    }

    public void setTime(long timeMillis) {
        this.mTimeMillis = timeMillis;
    }

    public TimeZoneInfo get(int position) {
        return this.mTimeZones.get(position);
    }

    public int size() {
        return this.mTimeZones.size();
    }

    public int getDefaultTimeZoneIndex() {
        return this.mTimeZones.indexOf(this.mDefaultTimeZoneInfo);
    }

    public int findIndexByTimeZoneIdSlow(String timeZoneId) {
        int idx = 0;
        for (TimeZoneInfo tzi : this.mTimeZones) {
            if (timeZoneId.equals(tzi.mTzId)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    void loadTzs(Context context) {
        this.mTimeZones = new ArrayList();
        HashSet<String> processedTimeZones = this.loadTzsInZoneTab(context);
        String[] tzIds = TimeZone.getAvailableIDs();
        for (String tzId : tzIds) {
            if (processedTimeZones.contains(tzId) || !tzId.startsWith("Etc/GMT")) continue;
            TimeZone timeZone = TimeZone.getTimeZone(tzId);
            if (timeZone == null) {
                Log.e((String)TAG, (String)("Timezone not found: " + tzId));
                continue;
            }
            TimeZoneInfo tzInfo = new TimeZoneInfo(timeZone, null);
            if (this.getIdenticalTimeZoneInTheCountry(tzInfo) != -1) continue;
            this.mTimeZones.add(tzInfo);
        }
        Collections.sort(this.mTimeZones);
        this.mTimeZonesByCountry = new LinkedHashMap();
        this.mTimeZonesByOffsets = new SparseArray(this.mHasTimeZonesInHrOffset.length);
        this.mTimeZonesById = new HashMap(this.mTimeZones.size());
        for (TimeZoneInfo tz : this.mTimeZones) {
            this.mTimeZonesById.put(tz.mTzId, tz);
        }
        this.populateDisplayNameOverrides(this.mContext.getResources());
        Date date = new Date(this.mTimeMillis);
        Locale defaultLocal = Locale.getDefault();
        int idx = 0;
        for (TimeZoneInfo timeZoneInfo : this.mTimeZones) {
            ArrayList<Integer> group;
            if (timeZoneInfo.mDisplayName == null) {
                timeZoneInfo.mDisplayName = timeZoneInfo.mTz.getDisplayName(timeZoneInfo.mTz.inDaylightTime(date), 1, defaultLocal);
            }
            if ((group = this.mTimeZonesByCountry.get(timeZoneInfo.mCountry)) == null) {
                group = new ArrayList();
                this.mTimeZonesByCountry.put(timeZoneInfo.mCountry, group);
            }
            group.add(idx);
            this.indexByOffsets(idx, timeZoneInfo);
            if (!timeZoneInfo.mDisplayName.endsWith(":00")) {
                this.mTimeZoneNames.add(timeZoneInfo.mDisplayName);
            }
            ++idx;
        }
    }

    private void printTimeZones() {
        TimeZoneInfo last = null;
        boolean first = true;
        for (TimeZoneInfo tz : this.mTimeZones) {
            String name = tz.mTz.getDisplayName();
            if (name.startsWith("GMT") && !tz.mTzId.startsWith("Etc/GMT")) {
                Log.e((String)"GMT", (String)tz.toString());
            }
            if (last != null) {
                if (last.compareTo(tz) == 0) {
                    if (first) {
                        Log.e((String)"SAME", (String)last.toString());
                        first = false;
                    }
                    Log.e((String)"SAME", (String)tz.toString());
                } else {
                    first = true;
                }
            }
            last = tz;
        }
        Log.e((String)TAG, (String)("Total number of tz's = " + this.mTimeZones.size()));
    }

    private void populateDisplayNameOverrides(Resources resources) {
        String[] ids = resources.getStringArray(R.array.timezone_rename_ids);
        String[] labels = resources.getStringArray(R.array.timezone_rename_labels);
        int length = ids.length;
        if (ids.length != labels.length) {
            Log.e((String)TAG, (String)("timezone_rename_ids len=" + ids.length + " timezone_rename_labels len=" + labels.length));
            length = Math.min(ids.length, labels.length);
        }
        for (int i = 0; i < length; ++i) {
            TimeZoneInfo tzi = this.mTimeZonesById.get(ids[i]);
            if (tzi != null) {
                tzi.mDisplayName = labels[i];
                continue;
            }
            Log.e((String)TAG, (String)("Could not find timezone with label: " + labels[i]));
        }
    }

    public boolean hasTimeZonesInHrOffset(int offsetHr) {
        int index = 20 + offsetHr;
        if (index >= this.mHasTimeZonesInHrOffset.length || index < 0) {
            return false;
        }
        return this.mHasTimeZonesInHrOffset[index];
    }

    private void indexByOffsets(int idx, TimeZoneInfo tzi) {
        int offsetMillis = tzi.getNowOffsetMillis();
        int index = 20 + (int)((long)offsetMillis / 3600000L);
        this.mHasTimeZonesInHrOffset[index] = true;
        ArrayList<Integer> group = (ArrayList<Integer>)this.mTimeZonesByOffsets.get(index);
        if (group == null) {
            group = new ArrayList<Integer>();
            this.mTimeZonesByOffsets.put(index, group);
        }
        group.add(idx);
    }

    public ArrayList<Integer> getTimeZonesByOffset(int offsetHr) {
        int index = 20 + offsetHr;
        if (index >= this.mHasTimeZonesInHrOffset.length || index < 0) {
            return null;
        }
        return (ArrayList)this.mTimeZonesByOffsets.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> loadTzsInZoneTab(Context context) {
        HashSet<String> processedTimeZones = new HashSet<String>();
        AssetManager am = context.getAssets();
        InputStream is = null;
        try {
            String line;
            is = am.open("backward");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 0) continue;
                String[] fields = line.split("\t+");
                String newTzId = fields[1];
                String oldTzId = fields[fields.length - 1];
                TimeZone tz = TimeZone.getTimeZone(newTzId);
                if (tz == null) {
                    Log.e((String)TAG, (String)("Timezone not found: " + newTzId));
                    continue;
                }
                processedTimeZones.add(oldTzId);
                if (this.mDefaultTimeZoneId == null || !this.mDefaultTimeZoneId.equals(oldTzId)) continue;
                this.mAlternateDefaultTimeZoneId = newTzId;
            }
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"Failed to read 'backward' file.");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {}
        }
        try {
            String line;
            String lang = Locale.getDefault().getLanguage();
            is = am.open("zone.tab");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                TimeZoneInfo timeZoneInfo;
                int identicalTzIdx;
                if (line.startsWith("#")) continue;
                String[] fields = line.split("\t");
                String timeZoneId = fields[2];
                String countryCode = fields[0];
                TimeZone tz = TimeZone.getTimeZone(timeZoneId);
                if (tz == null) {
                    Log.e((String)TAG, (String)("Timezone not found: " + timeZoneId));
                    continue;
                }
                if (countryCode == null && !timeZoneId.startsWith("Etc/GMT")) {
                    processedTimeZones.add(timeZoneId);
                    continue;
                }
                String country = this.mCountryCodeToNameMap.get(countryCode);
                if (country == null) {
                    country = this.getCountryNames(lang, countryCode);
                    this.mCountryCodeToNameMap.put(countryCode, country);
                }
                if (this.mDefaultTimeZoneId != null && this.mDefaultTimeZoneCountry == null && timeZoneId.equals(this.mAlternateDefaultTimeZoneId)) {
                    this.mDefaultTimeZoneCountry = country;
                    TimeZone defaultTz = TimeZone.getTimeZone(this.mDefaultTimeZoneId);
                    if (defaultTz != null) {
                        this.mDefaultTimeZoneInfo = new TimeZoneInfo(defaultTz, country);
                        int tzToOverride = this.getIdenticalTimeZoneInTheCountry(this.mDefaultTimeZoneInfo);
                        if (tzToOverride == -1) {
                            this.mTimeZones.add(this.mDefaultTimeZoneInfo);
                        } else {
                            this.mTimeZones.add(tzToOverride, this.mDefaultTimeZoneInfo);
                        }
                    }
                }
                if ((identicalTzIdx = this.getIdenticalTimeZoneInTheCountry(timeZoneInfo = new TimeZoneInfo(tz, country))) == -1) {
                    this.mTimeZones.add(timeZoneInfo);
                }
                processedTimeZones.add(timeZoneId);
            }
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"Failed to read 'zone.tab'.");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return processedTimeZones;
    }

    private String getCountryNames(String lang, String countryCode) {
        Locale defaultLocale = Locale.getDefault();
        String countryDisplayName = PALESTINE_COUNTRY_CODE.equalsIgnoreCase(countryCode) ? this.mPalestineDisplayName : new Locale(lang, countryCode).getDisplayCountry(defaultLocale);
        if (!countryCode.equals(countryDisplayName)) {
            return countryDisplayName;
        }
        if (mBackupCountryCodes == null || !defaultLocale.equals(mBackupCountryLocale)) {
            mBackupCountryLocale = defaultLocale;
            mBackupCountryCodes = this.mContext.getResources().getStringArray(R.array.backup_country_codes);
            mBackupCountryNames = this.mContext.getResources().getStringArray(R.array.backup_country_names);
        }
        int length = Math.min(mBackupCountryCodes.length, mBackupCountryNames.length);
        for (int i = 0; i < length; ++i) {
            if (!mBackupCountryCodes[i].equals(countryCode)) continue;
            return mBackupCountryNames[i];
        }
        return countryCode;
    }

    private int getIdenticalTimeZoneInTheCountry(TimeZoneInfo timeZoneInfo) {
        int idx = 0;
        for (TimeZoneInfo tzi : this.mTimeZones) {
            if (tzi.hasSameRules(timeZoneInfo) && (tzi.mCountry == null ? timeZoneInfo.mCountry == null : tzi.mCountry.equals(timeZoneInfo.mCountry))) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

