/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.widget.PageIndicator;
import com.codetroopers.betterpickers.widget.PickerLinearLayout;

public class UnderlinePageIndicatorPicker
extends View
implements PageIndicator {
    private int mColorUnderline;
    private static final int INVALID_POINTER = -1;
    private final Paint mPaint = new Paint(1);
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mScrollState;
    private int mCurrentPage;
    private float mPositionOffset;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private int mActivePointerId = -1;
    private boolean mIsDragging;
    private PickerLinearLayout mTitleView = null;
    private Paint rectPaint;

    public UnderlinePageIndicatorPicker(Context context) {
        this(context, null);
    }

    public UnderlinePageIndicatorPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UnderlinePageIndicatorPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mColorUnderline = this.getResources().getColor(R.color.dialog_text_color_holo_dark);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BetterPickersDialogFragment, defStyle, 0);
        this.mColorUnderline = a.getColor(R.styleable.BetterPickersDialogFragment_bpKeyboardIndicatorColor, this.mColorUnderline);
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
    }

    public int getSelectedColor() {
        return this.mPaint.getColor();
    }

    public void setSelectedColor(int selectedColor) {
        this.mPaint.setColor(selectedColor);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int count = this.mViewPager.getAdapter().getCount();
        if (this.isInEditMode() || count == 0) {
            return;
        }
        if (this.mTitleView != null) {
            View currentTab = this.mTitleView.getViewAt(this.mCurrentPage);
            float lineLeft = currentTab.getLeft();
            float lineRight = currentTab.getRight();
            if (this.mPositionOffset > 0.0f && this.mCurrentPage < count - 1) {
                View nextTab = this.mTitleView.getViewAt(this.mCurrentPage + 1);
                float nextTabLeft = nextTab.getLeft();
                float nextTabRight = nextTab.getRight();
                lineLeft = this.mPositionOffset * nextTabLeft + (1.0f - this.mPositionOffset) * lineLeft;
                lineRight = this.mPositionOffset * nextTabRight + (1.0f - this.mPositionOffset) * lineRight;
            }
            canvas.drawRect(lineLeft, (float)this.getPaddingBottom(), lineRight, (float)(this.getHeight() - this.getPaddingBottom()), this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (super.onTouchEvent(ev)) {
            return true;
        }
        if (this.mViewPager == null || this.mViewPager.getAdapter().getCount() == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mLastMotionX = ev.getX();
                break;
            }
            case 2: {
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = x - this.mLastMotionX;
                if (!this.mIsDragging && Math.abs(deltaX) > (float)this.mTouchSlop) {
                    this.mIsDragging = true;
                }
                if (!this.mIsDragging) break;
                this.mLastMotionX = x;
                if (!this.mViewPager.isFakeDragging() && !this.mViewPager.beginFakeDrag()) break;
                this.mViewPager.fakeDragBy(deltaX);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsDragging) {
                    int count = this.mViewPager.getAdapter().getCount();
                    int width = this.getWidth();
                    float halfWidth = (float)width / 2.0f;
                    float sixthWidth = (float)width / 6.0f;
                    if (this.mCurrentPage > 0 && ev.getX() < halfWidth - sixthWidth) {
                        if (action != 3) {
                            this.mViewPager.setCurrentItem(this.mCurrentPage - 1);
                        }
                        return true;
                    }
                    if (this.mCurrentPage < count - 1 && ev.getX() > halfWidth + sixthWidth) {
                        if (action != 3) {
                            this.mViewPager.setCurrentItem(this.mCurrentPage + 1);
                        }
                        return true;
                    }
                }
                this.mIsDragging = false;
                this.mActivePointerId = -1;
                if (!this.mViewPager.isFakeDragging()) break;
                this.mViewPager.endFakeDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
                }
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        return true;
    }

    @Override
    public void setViewPager(ViewPager viewPager) {
        if (this.mViewPager == viewPager) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = viewPager;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mCurrentPage = position;
        this.mPositionOffset = positionOffset;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollState == 0) {
            this.mCurrentPage = position;
            this.mPositionOffset = 0.0f;
            this.invalidate();
        }
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPage = savedState.currentPage;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.mCurrentPage;
        return savedState;
    }

    public void setTitleView(PickerLinearLayout titleView) {
        this.mTitleView = titleView;
        this.invalidate();
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

