/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobServiceEngine;
import android.app.job.JobWorkItem;
import android.content.Intent;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import androidx.core.app.JobIntentService;

@RequiresApi(value=26)
public class SafeJobServiceEngineImpl
extends JobServiceEngine
implements JobIntentService.CompatJobEngine {
    static final String TAG = "JobServiceEngineImpl";
    static final boolean DEBUG = false;
    final JobIntentService mService;
    final Object mLock = new Object();
    JobParameters mParams;

    SafeJobServiceEngineImpl(JobIntentService service) {
        super((Service)service);
        this.mService = service;
    }

    public IBinder compatGetBinder() {
        return this.getBinder();
    }

    public boolean onStartJob(JobParameters params) {
        this.mParams = params;
        this.mService.ensureProcessorRunningLocked(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStopJob(JobParameters params) {
        boolean result = this.mService.doStopCurrentWork();
        Object object = this.mLock;
        synchronized (object) {
            this.mParams = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobIntentService.GenericWorkItem dequeueWork() {
        JobWorkItem work = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mParams == null) {
                return null;
            }
            try {
                work = this.mParams.dequeueWork();
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
        }
        if (work != null) {
            work.getIntent().setExtrasClassLoader(this.mService.getClassLoader());
            return new WrapperWorkItem(work);
        }
        return null;
    }

    final class WrapperWorkItem
    implements JobIntentService.GenericWorkItem {
        final JobWorkItem mJobWork;

        WrapperWorkItem(JobWorkItem jobWork) {
            this.mJobWork = jobWork;
        }

        public Intent getIntent() {
            return this.mJobWork.getIntent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete() {
            Object object = SafeJobServiceEngineImpl.this.mLock;
            synchronized (object) {
                if (SafeJobServiceEngineImpl.this.mParams != null) {
                    try {
                        SafeJobServiceEngineImpl.this.mParams.completeWork(this.mJobWork);
                    }
                    catch (SecurityException se) {
                        se.printStackTrace();
                    }
                }
            }
        }
    }
}

