/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import androidx.annotation.RestrictTo;
import com.evernote.android.job.JobApi;
import com.evernote.android.job.gcm.JobProxyGcm;
import com.evernote.android.job.util.JobCat;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class GcmAvailableHelper {
    private static final JobCat CAT;
    private static final String ACTION_TASK_READY = "com.google.android.gms.gcm.ACTION_TASK_READY";
    private static final String GCM_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    private static final boolean GCM_IN_CLASSPATH;
    private static int gcmServiceAvailable;
    private static boolean checkedServiceEnabled;

    public static boolean isGcmApiSupported(Context context) {
        try {
            if (!checkedServiceEnabled) {
                checkedServiceEnabled = true;
                GcmAvailableHelper.setServiceEnabled(context, GCM_IN_CLASSPATH);
            }
            return GCM_IN_CLASSPATH && GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0 && GcmAvailableHelper.isGcmServiceRegistered(context) == 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int isGcmServiceRegistered(Context context) {
        if (gcmServiceAvailable >= 0) return gcmServiceAvailable;
        Class<JobApi> clazz = JobApi.class;
        synchronized (JobApi.class) {
            if (gcmServiceAvailable >= 0) return gcmServiceAvailable;
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(context, GcmAvailableHelper.getPlatformGcmServiceClassName()));
            List resolveInfos = context.getPackageManager().queryIntentServices(intent, 0);
            if (!GcmAvailableHelper.hasPermission(resolveInfos)) {
                gcmServiceAvailable = 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return gcmServiceAvailable;
            }
            intent = new Intent(ACTION_TASK_READY);
            intent.setPackage(context.getPackageName());
            resolveInfos = context.getPackageManager().queryIntentServices(intent, 0);
            if (!GcmAvailableHelper.hasPermission(resolveInfos)) {
                gcmServiceAvailable = 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return gcmServiceAvailable;
            }
            gcmServiceAvailable = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return gcmServiceAvailable;
        }
    }

    private static boolean hasPermission(List<ResolveInfo> resolveInfos) {
        if (resolveInfos == null || resolveInfos.isEmpty()) {
            return false;
        }
        for (ResolveInfo info : resolveInfos) {
            if (info.serviceInfo == null || !GCM_PERMISSION.equals(info.serviceInfo.permission) || !info.serviceInfo.exported) continue;
            return true;
        }
        return false;
    }

    private static void setServiceEnabled(Context context, boolean enabled) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ComponentName component = new ComponentName(context, GcmAvailableHelper.getPlatformGcmServiceClassName());
            int componentEnabled = packageManager.getComponentEnabledSetting(component);
            switch (componentEnabled) {
                case 1: {
                    if (enabled) break;
                    packageManager.setComponentEnabledSetting(component, 2, 1);
                    CAT.i("GCM service disabled");
                    break;
                }
                case 0: 
                case 2: {
                    if (!enabled) break;
                    packageManager.setComponentEnabledSetting(component, 1, 1);
                    CAT.i("GCM service enabled");
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getPlatformGcmServiceClassName() {
        return JobProxyGcm.class.getPackage().getName() + ".PlatformGcmService";
    }

    private GcmAvailableHelper() {
    }

    static {
        boolean gcmInClasspath;
        CAT = new JobCat("GcmAvailableHelper");
        gcmServiceAvailable = -1;
        try {
            Class.forName("com.google.android.gms.gcm.GcmNetworkManager");
            gcmInClasspath = true;
        }
        catch (Throwable t) {
            gcmInClasspath = false;
        }
        GCM_IN_CLASSPATH = gcmInClasspath;
    }
}

