/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.evernote.android.job.JobApi;
import com.evernote.android.job.util.Clock;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobLogger;
import com.evernote.android.job.util.JobPreconditions;
import java.util.EnumMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class JobConfig {
    private static final long DEFAULT_JOB_RESCHEDULE_PAUSE = 3000L;
    private static final EnumMap<JobApi, Boolean> ENABLED_APIS;
    private static final JobCat CAT;
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE;
    private static volatile boolean allowSmallerIntervals;
    private static volatile boolean forceAllowApi14;
    private static volatile long jobReschedulePause;
    private static volatile boolean skipJobReschedule;
    private static volatile int jobIdOffset;
    private static volatile boolean forceRtc;
    private static volatile Clock clock;
    private static volatile ExecutorService executorService;
    private static volatile boolean closeDatabase;

    private JobConfig() {
        throw new UnsupportedOperationException();
    }

    public static boolean isApiEnabled(@NonNull JobApi api) {
        return ENABLED_APIS.get((Object)api);
    }

    public static void setApiEnabled(@NonNull JobApi api, boolean enabled) {
        ENABLED_APIS.put(api, enabled);
        CAT.w("setApiEnabled - %s, %b", new Object[]{api, enabled});
    }

    public static void forceApi(@NonNull JobApi api) {
        for (JobApi jobApi : JobApi.values()) {
            ENABLED_APIS.put(jobApi, jobApi == api);
        }
        CAT.w("forceApi - %s", new Object[]{api});
    }

    public static boolean isAllowSmallerIntervalsForMarshmallow() {
        return allowSmallerIntervals && Build.VERSION.SDK_INT < 24;
    }

    public static void setAllowSmallerIntervalsForMarshmallow(boolean allowSmallerIntervals) {
        if (allowSmallerIntervals && Build.VERSION.SDK_INT >= 24) {
            throw new IllegalStateException("This method is only allowed to call on Android M or earlier");
        }
        JobConfig.allowSmallerIntervals = allowSmallerIntervals;
    }

    public static void setForceAllowApi14(boolean forceAllowApi14) {
        JobConfig.forceAllowApi14 = forceAllowApi14;
    }

    public static boolean isForceAllowApi14() {
        return forceAllowApi14;
    }

    public static synchronized boolean addLogger(@NonNull JobLogger logger) {
        return JobCat.addLogger(logger);
    }

    public static synchronized void removeLogger(@NonNull JobLogger logger) {
        JobCat.removeLogger(logger);
    }

    public static void setLogcatEnabled(boolean enabled) {
        JobCat.setLogcatEnabled(enabled);
    }

    public static boolean isLogcatEnabled() {
        return JobCat.isLogcatEnabled();
    }

    public static long getJobReschedulePause() {
        return jobReschedulePause;
    }

    public static void setJobReschedulePause(long pause, @NonNull TimeUnit timeUnit) {
        jobReschedulePause = timeUnit.toMillis(pause);
    }

    static boolean isSkipJobReschedule() {
        return skipJobReschedule;
    }

    static void setSkipJobReschedule(boolean skipJobReschedule) {
        JobConfig.skipJobReschedule = skipJobReschedule;
    }

    public static int getJobIdOffset() {
        return jobIdOffset;
    }

    public static void setJobIdOffset(int jobIdOffset) {
        JobPreconditions.checkArgumentNonnegative(jobIdOffset, "offset can't be negative");
        if (jobIdOffset > 2147479500) {
            throw new IllegalArgumentException("offset is too close to Integer.MAX_VALUE");
        }
        JobConfig.jobIdOffset = jobIdOffset;
    }

    public static boolean isForceRtc() {
        return forceRtc;
    }

    public static void setForceRtc(boolean forceRtc) {
        JobConfig.forceRtc = forceRtc;
    }

    public static Clock getClock() {
        return clock;
    }

    @VisibleForTesting
    static void setClock(Clock clock) {
        JobConfig.clock = clock;
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static void setExecutorService(@NonNull ExecutorService executorService) {
        JobConfig.executorService = JobPreconditions.checkNotNull(executorService);
    }

    public static boolean isCloseDatabase() {
        return closeDatabase;
    }

    public static void setCloseDatabase(boolean closeDatabase) {
        JobConfig.closeDatabase = closeDatabase;
    }

    public static void reset() {
        for (JobApi api : JobApi.values()) {
            ENABLED_APIS.put(api, Boolean.TRUE);
        }
        allowSmallerIntervals = false;
        forceAllowApi14 = false;
        jobReschedulePause = 3000L;
        skipJobReschedule = false;
        jobIdOffset = 0;
        forceRtc = false;
        clock = Clock.DEFAULT;
        executorService = DEFAULT_EXECUTOR_SERVICE;
        closeDatabase = false;
        JobCat.setLogcatEnabled(true);
        JobCat.clearLogger();
    }

    static {
        CAT = new JobCat("JobConfig");
        DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger mThreadNumber = new AtomicInteger();

            @Override
            public Thread newThread(@NonNull Runnable r) {
                Thread thread = new Thread(r, "AndroidJob-" + this.mThreadNumber.incrementAndGet());
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        });
        forceAllowApi14 = false;
        jobReschedulePause = 3000L;
        skipJobReschedule = false;
        jobIdOffset = 0;
        forceRtc = false;
        clock = Clock.DEFAULT;
        executorService = DEFAULT_EXECUTOR_SERVICE;
        closeDatabase = false;
        ENABLED_APIS = new EnumMap(JobApi.class);
        for (JobApi api : JobApi.values()) {
            ENABLED_APIS.put(api, Boolean.TRUE);
        }
    }
}

