/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.evernote.android.job.util.JobCat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class JobUtil {
    private static final ThreadLocal<SimpleDateFormat> FORMAT = new ThreadLocal();
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final JobCat CAT = new JobCat("JobUtil");

    private JobUtil() {
    }

    public static String timeToString(long timeMs) {
        SimpleDateFormat simpleDateFormat = FORMAT.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            FORMAT.set(simpleDateFormat);
        }
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String result = simpleDateFormat.format(new Date(timeMs));
        long days = timeMs / ONE_DAY;
        if (days == 1L) {
            result = result + " (+1 day)";
        } else if (days > 1L) {
            result = result + " (+" + days + " days)";
        }
        return result;
    }

    public static boolean hasBootPermission(Context context) {
        return JobUtil.hasPermission(context, "android.permission.RECEIVE_BOOT_COMPLETED", 0);
    }

    public static boolean hasWakeLockPermission(Context context) {
        return JobUtil.hasPermission(context, "android.permission.WAKE_LOCK", 0);
    }

    private static boolean hasPermission(Context context, String permission2, int repeatCount) {
        try {
            return 0 == context.getPackageManager().checkPermission(permission2, context.getPackageName());
        }
        catch (Exception e) {
            CAT.e(e);
            return repeatCount < 1 && JobUtil.hasPermission(context.getApplicationContext(), permission2, repeatCount + 1);
        }
    }
}

