/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util.support;

import androidx.annotation.NonNull;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.support.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class PersistableBundleCompat {
    private static final JobCat CAT = new JobCat("PersistableBundleCompat");
    private static final String UTF_8 = "UTF-8";
    private final Map<String, Object> mValues;

    public PersistableBundleCompat() {
        this(new HashMap<String, Object>());
    }

    public PersistableBundleCompat(PersistableBundleCompat bundle) {
        this(new HashMap<String, Object>(bundle.mValues));
    }

    private PersistableBundleCompat(Map<String, Object> values) {
        this.mValues = values;
    }

    public void putBoolean(String key, boolean value) {
        this.mValues.put(key, value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public void putInt(String key, int value) {
        this.mValues.put(key, value);
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public void putIntArray(String key, int[] value) {
        this.mValues.put(key, value);
    }

    public int[] getIntArray(String key) {
        Object value = this.mValues.get(key);
        if (value instanceof int[]) {
            return (int[])value;
        }
        return null;
    }

    public void putLong(String key, long value) {
        this.mValues.put(key, value);
    }

    public long getLong(String key, long defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        return defaultValue;
    }

    public void putLongArray(String key, long[] value) {
        this.mValues.put(key, value);
    }

    public long[] getLongArray(String key) {
        Object value = this.mValues.get(key);
        if (value instanceof long[]) {
            return (long[])value;
        }
        return null;
    }

    public void putDouble(String key, double value) {
        this.mValues.put(key, value);
    }

    public double getDouble(String key, double defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        return defaultValue;
    }

    public void putDoubleArray(String key, double[] value) {
        this.mValues.put(key, value);
    }

    public double[] getDoubleArray(String key) {
        Object value = this.mValues.get(key);
        if (value instanceof double[]) {
            return (double[])value;
        }
        return null;
    }

    public void putString(String key, String value) {
        this.mValues.put(key, value);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public void putStringArray(String key, String[] value) {
        this.mValues.put(key, value);
    }

    public String[] getStringArray(String key) {
        Object value = this.mValues.get(key);
        if (value instanceof String[]) {
            return (String[])value;
        }
        return null;
    }

    public void putPersistableBundleCompat(String key, PersistableBundleCompat value) {
        this.mValues.put(key, value == null ? null : value.mValues);
    }

    public PersistableBundleCompat getPersistableBundleCompat(String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Map) {
            return new PersistableBundleCompat((Map)value);
        }
        return null;
    }

    public void clear() {
        this.mValues.clear();
    }

    public boolean containsKey(String key) {
        return this.mValues.containsKey(key);
    }

    public Object get(String key) {
        return this.mValues.get(key);
    }

    public boolean isEmpty() {
        return this.mValues.isEmpty();
    }

    public Set<String> keySet() {
        return this.mValues.keySet();
    }

    public void putAll(PersistableBundleCompat bundle) {
        this.mValues.putAll(bundle.mValues);
    }

    public void remove(String key) {
        this.mValues.remove(key);
    }

    public int size() {
        return this.mValues.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public String saveToXml() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            XmlUtils.writeMapXml(this.mValues, outputStream);
            String string = outputStream.toString(UTF_8);
            return string;
        }
        catch (IOException | XmlPullParserException e) {
            CAT.e(e);
            String string = "";
            return string;
        }
        catch (Error e) {
            CAT.e(e);
            String string = "";
            return string;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static PersistableBundleCompat fromXml(@NonNull String xml) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(xml.getBytes(UTF_8));
            HashMap<String, Object> map = XmlUtils.readMapXml(inputStream);
            PersistableBundleCompat persistableBundleCompat = new PersistableBundleCompat(map);
            return persistableBundleCompat;
        }
        catch (IOException | XmlPullParserException e) {
            CAT.e(e);
            PersistableBundleCompat persistableBundleCompat = new PersistableBundleCompat();
            return persistableBundleCompat;
        }
        catch (VerifyError e) {
            CAT.e(e);
            PersistableBundleCompat persistableBundleCompat = new PersistableBundleCompat();
            return persistableBundleCompat;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

