/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.work;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.work.JobProxyWorkManager;
import com.evernote.android.job.work.TransientBundleHolder;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class PlatformWorker
extends Worker {
    private static final JobCat CAT = new JobCat("PlatformWorker");

    public PlatformWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenableWorker.Result doWork() {
        int jobId = this.getJobId();
        if (jobId < 0) {
            return ListenableWorker.Result.failure();
        }
        try {
            JobProxy.Common common = new JobProxy.Common(this.getApplicationContext(), CAT, jobId);
            JobRequest request = common.getPendingRequest(true, true);
            if (request == null) {
                ListenableWorker.Result result = ListenableWorker.Result.failure();
                return result;
            }
            Bundle transientBundle = null;
            if (request.isTransient() && (transientBundle = TransientBundleHolder.getBundle(jobId)) == null) {
                CAT.d("Transient bundle is gone for request %s", request);
                ListenableWorker.Result result = ListenableWorker.Result.failure();
                return result;
            }
            Job.Result result = common.executeJobRequest(request, transientBundle);
            if (Job.Result.SUCCESS == result) {
                ListenableWorker.Result result2 = ListenableWorker.Result.success();
                return result2;
            }
            ListenableWorker.Result result3 = ListenableWorker.Result.failure();
            return result3;
        }
        finally {
            TransientBundleHolder.cleanUpBundle(jobId);
        }
    }

    public void onStopped() {
        int jobId = this.getJobId();
        Job job = JobManager.create(this.getApplicationContext()).getJob(jobId);
        if (job != null) {
            job.cancel();
            CAT.d("Called onStopped for %s", job);
        } else {
            CAT.d("Called onStopped, job %d not found", jobId);
        }
    }

    private int getJobId() {
        return JobProxyWorkManager.getJobIdFromTags(this.getTags());
    }
}

