/*
 * Decompiled with CFR 0.152.
 */
package com.f2prateek.rx.preferences2;

import android.content.SharedPreferences;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.f2prateek.rx.preferences2.BooleanAdapter;
import com.f2prateek.rx.preferences2.ConverterAdapter;
import com.f2prateek.rx.preferences2.EnumAdapter;
import com.f2prateek.rx.preferences2.FloatAdapter;
import com.f2prateek.rx.preferences2.IntegerAdapter;
import com.f2prateek.rx.preferences2.LongAdapter;
import com.f2prateek.rx.preferences2.Preconditions;
import com.f2prateek.rx.preferences2.Preference;
import com.f2prateek.rx.preferences2.RealPreference;
import com.f2prateek.rx.preferences2.StringAdapter;
import com.f2prateek.rx.preferences2.StringSetAdapter;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.Collections;
import java.util.Set;

public final class RxSharedPreferences {
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Integer DEFAULT_INTEGER = 0;
    private static final Boolean DEFAULT_BOOLEAN = false;
    private static final Long DEFAULT_LONG = 0L;
    private static final String DEFAULT_STRING = "";
    private final SharedPreferences preferences;
    private final Observable<String> keyChanges;

    @CheckResult
    @NonNull
    public static RxSharedPreferences create(@NonNull SharedPreferences preferences) {
        Preconditions.checkNotNull(preferences, "preferences == null");
        return new RxSharedPreferences(preferences);
    }

    private RxSharedPreferences(final SharedPreferences preferences) {
        this.preferences = preferences;
        this.keyChanges = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> emitter) throws Exception {
                final SharedPreferences.OnSharedPreferenceChangeListener listener = new SharedPreferences.OnSharedPreferenceChangeListener(){

                    public void onSharedPreferenceChanged(SharedPreferences preferences, String key) {
                        emitter.onNext((Object)key);
                    }
                };
                emitter.setCancellable(new Cancellable(){

                    public void cancel() throws Exception {
                        preferences.unregisterOnSharedPreferenceChangeListener(listener);
                    }
                });
                preferences.registerOnSharedPreferenceChangeListener(listener);
            }
        }).share();
    }

    @CheckResult
    @NonNull
    public Preference<Boolean> getBoolean(@NonNull String key) {
        return this.getBoolean(key, DEFAULT_BOOLEAN);
    }

    @CheckResult
    @NonNull
    public Preference<Boolean> getBoolean(@NonNull String key, @NonNull Boolean defaultValue) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        return new RealPreference<Boolean>(this.preferences, key, defaultValue, BooleanAdapter.INSTANCE, this.keyChanges);
    }

    @CheckResult
    @NonNull
    public <T extends Enum<T>> Preference<T> getEnum(@NonNull String key, @NonNull T defaultValue, @NonNull Class<T> enumClass) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        Preconditions.checkNotNull(enumClass, "enumClass == null");
        return new RealPreference<T>(this.preferences, key, defaultValue, new EnumAdapter<T>(enumClass), this.keyChanges);
    }

    @CheckResult
    @NonNull
    public Preference<Float> getFloat(@NonNull String key) {
        return this.getFloat(key, DEFAULT_FLOAT);
    }

    @CheckResult
    @NonNull
    public Preference<Float> getFloat(@NonNull String key, @NonNull Float defaultValue) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        return new RealPreference<Float>(this.preferences, key, defaultValue, FloatAdapter.INSTANCE, this.keyChanges);
    }

    @CheckResult
    @NonNull
    public Preference<Integer> getInteger(@NonNull String key) {
        return this.getInteger(key, DEFAULT_INTEGER);
    }

    @CheckResult
    @NonNull
    public Preference<Integer> getInteger(@NonNull String key, @NonNull Integer defaultValue) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        return new RealPreference<Integer>(this.preferences, key, defaultValue, IntegerAdapter.INSTANCE, this.keyChanges);
    }

    @CheckResult
    @NonNull
    public Preference<Long> getLong(@NonNull String key) {
        return this.getLong(key, DEFAULT_LONG);
    }

    @CheckResult
    @NonNull
    public Preference<Long> getLong(@NonNull String key, @NonNull Long defaultValue) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        return new RealPreference<Long>(this.preferences, key, defaultValue, LongAdapter.INSTANCE, this.keyChanges);
    }

    @CheckResult
    @NonNull
    public <T> Preference<T> getObject(@NonNull String key, @NonNull T defaultValue, @NonNull Preference.Converter<T> converter) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        Preconditions.checkNotNull(converter, "converter == null");
        return new RealPreference<T>(this.preferences, key, defaultValue, new ConverterAdapter<T>(converter), this.keyChanges);
    }

    @CheckResult
    @NonNull
    public Preference<String> getString(@NonNull String key) {
        return this.getString(key, DEFAULT_STRING);
    }

    @CheckResult
    @NonNull
    public Preference<String> getString(@NonNull String key, @NonNull String defaultValue) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        return new RealPreference<String>(this.preferences, key, defaultValue, StringAdapter.INSTANCE, this.keyChanges);
    }

    @RequiresApi(value=11)
    @CheckResult
    @NonNull
    public Preference<Set<String>> getStringSet(@NonNull String key) {
        return this.getStringSet(key, Collections.emptySet());
    }

    @RequiresApi(value=11)
    @CheckResult
    @NonNull
    public Preference<Set<String>> getStringSet(@NonNull String key, @NonNull Set<String> defaultValue) {
        Preconditions.checkNotNull(key, "key == null");
        Preconditions.checkNotNull(defaultValue, "defaultValue == null");
        return new RealPreference<Set<String>>(this.preferences, key, defaultValue, StringSetAdapter.INSTANCE, this.keyChanges);
    }

    public void clear() {
        this.preferences.edit().clear().apply();
    }
}

