/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.content.res.Configuration;
import android.widget.RelativeLayout;
import androidx.annotation.Keep;
import com.facebook.ads.Ad;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.internal.api.AdViewApi;
import com.facebook.ads.internal.api.AdViewParentApi;
import com.facebook.ads.internal.bench.Benchmark;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public class AdView
extends RelativeLayout
implements Ad {
    private final AdViewApi mAdViewApi;
    private final AdViewParentApi mAdViewParentApi = new AdViewParentApi(){

        @Override
        @Benchmark
        public void onConfigurationChanged(Configuration newConfig) {
            AdView.super.onConfigurationChanged(newConfig);
        }
    };

    @Benchmark
    public AdView(Context context, String placementId, AdSize adSize) {
        super(context);
        this.mAdViewApi = DynamicLoaderFactory.makeLoader(context).createAdViewApi(context, placementId, adSize, this.mAdViewParentApi, this);
    }

    @Benchmark
    public AdView(Context context, String placementId, String bidPayload) throws Exception {
        super(context);
        this.mAdViewApi = DynamicLoaderFactory.makeLoader(context).createAdViewApi(context, placementId, bidPayload, this.mAdViewParentApi, this);
    }

    @Override
    @Benchmark
    public void loadAd() {
        this.mAdViewApi.loadAd();
    }

    @Benchmark
    public void loadAd(AdViewLoadConfig loadAdConfig) {
        this.mAdViewApi.loadAd(loadAdConfig);
    }

    @Override
    public boolean isAdInvalidated() {
        return this.mAdViewApi.isAdInvalidated();
    }

    @Override
    @Deprecated
    public void setExtraHints(ExtraHints extraHints) {
        this.mAdViewApi.setExtraHints(extraHints);
    }

    @Override
    public void destroy() {
        this.mAdViewApi.destroy();
    }

    @Override
    public String getPlacementId() {
        return this.mAdViewApi.getPlacementId();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.mAdViewApi.onConfigurationChanged(newConfig);
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public AdViewLoadConfigBuilder buildLoadAdConfig() {
        return this.mAdViewApi.buildLoadAdConfig();
    }

    @Keep
    public static interface AdViewLoadConfig
    extends Ad.LoadAdConfig {
    }

    @Keep
    public static interface AdViewLoadConfigBuilder
    extends Ad.LoadConfigBuilder {
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public AdViewLoadConfigBuilder withAdListener(AdListener var1);

        @Override
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public AdViewLoadConfigBuilder withBid(String var1);

        @Override
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public AdViewLoadConfig build();
    }
}

