/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.common;

import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.util.Base64;
import androidx.annotation.Nullable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FbValidationUtils {
    public static final String FB_PACKAGE = "com.facebook.katana";
    public static final String FB4A_SHA256_HASH = "4/nh4M+Z0OVqBVumXiQbM5n3zqUkMmsM3W7BMn7Q/cE=";

    public static String getSigningCertificate(@Nullable PackageInfo packageInfo) {
        try {
            if (packageInfo == null) {
                return "";
            }
            Signature[] signatures = packageInfo.signatures;
            if (signatures.length == 0) {
                return "";
            }
            byte[] signatureBytes = signatures[0].toByteArray();
            return FbValidationUtils.calculateSHA256Fingerprint(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    private static String calculateSHA256Fingerprint(byte[] signatureBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA256");
        byte[] publicKey = md.digest(signatureBytes);
        return Base64.encodeToString((byte[])publicKey, (int)2);
    }

    public static boolean isFbSigningCertificateValid(String signingCertificate) {
        return FB4A_SHA256_HASH.equals(signingCertificate);
    }
}

