/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GraphUtil {
    private static final String[] dateFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};

    public static JSONObject createOpenGraphActionForPost(String type) {
        JSONObject action = new JSONObject();
        if (type != null) {
            try {
                action.put("type", (Object)type);
            }
            catch (JSONException e) {
                throw new FacebookException("An error occurred while setting up the open graph action", e);
            }
        }
        return action;
    }

    public static JSONObject createOpenGraphObjectForPost(String type) {
        return GraphUtil.createOpenGraphObjectForPost(type, null, null, null, null, null, null);
    }

    public static JSONObject createOpenGraphObjectForPost(String type, String title, String imageUrl, String url, String description, JSONObject objectProperties, String id2) {
        JSONObject openGraphObject = new JSONObject();
        try {
            if (type != null) {
                openGraphObject.put("type", (Object)type);
            }
            openGraphObject.put("title", (Object)title);
            if (imageUrl != null) {
                JSONObject imageUrlObject = new JSONObject();
                imageUrlObject.put("url", (Object)imageUrl);
                JSONArray imageUrls = new JSONArray();
                imageUrls.put((Object)imageUrlObject);
                openGraphObject.put("image", (Object)imageUrls);
            }
            openGraphObject.put("url", (Object)url);
            openGraphObject.put("description", (Object)description);
            openGraphObject.put("fbsdk:create_object", true);
            if (objectProperties != null) {
                openGraphObject.put("data", (Object)objectProperties);
            }
            if (id2 != null) {
                openGraphObject.put("id", (Object)id2);
            }
        }
        catch (JSONException e) {
            throw new FacebookException("An error occurred while setting up the graph object", e);
        }
        return openGraphObject;
    }

    public static boolean isOpenGraphObjectForPost(JSONObject object) {
        return object != null ? object.optBoolean("fbsdk:create_object") : false;
    }
}

