/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenCache;
import com.facebook.AccessTokenSource;
import com.facebook.CurrentAccessTokenExpirationBroadcastReceiver;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0005!\"#$%B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001c\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\f\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/AccessTokenManager;", "", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "accessTokenCache", "Lcom/facebook/AccessTokenCache;", "(Landroidx/localbroadcastmanager/content/LocalBroadcastManager;Lcom/facebook/AccessTokenCache;)V", "value", "Lcom/facebook/AccessToken;", "currentAccessToken", "getCurrentAccessToken", "()Lcom/facebook/AccessToken;", "setCurrentAccessToken", "(Lcom/facebook/AccessToken;)V", "currentAccessTokenField", "lastAttemptedTokenExtendDate", "Ljava/util/Date;", "tokenRefreshInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentAccessTokenChanged", "", "extendAccessTokenIfNeeded", "loadCurrentAccessToken", "", "refreshCurrentAccessToken", "callback", "Lcom/facebook/AccessToken$AccessTokenRefreshCallback;", "refreshCurrentAccessTokenImpl", "sendCurrentAccessTokenChangedBroadcastIntent", "oldAccessToken", "saveToCache", "setTokenExpirationBroadcastAlarm", "shouldExtendAccessToken", "Companion", "FacebookRefreshTokenInfo", "InstagramRefreshTokenInfo", "RefreshResult", "RefreshTokenInfo", "facebook-core_release"})
public final class AccessTokenManager {
    private AccessToken currentAccessTokenField;
    private final AtomicBoolean tokenRefreshInProgress;
    private Date lastAttemptedTokenExtendDate;
    private final LocalBroadcastManager localBroadcastManager;
    private final AccessTokenCache accessTokenCache;
    @NotNull
    public static final String TAG = "AccessTokenManager";
    @NotNull
    public static final String ACTION_CURRENT_ACCESS_TOKEN_CHANGED = "com.facebook.sdk.ACTION_CURRENT_ACCESS_TOKEN_CHANGED";
    @NotNull
    public static final String EXTRA_OLD_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_OLD_ACCESS_TOKEN";
    @NotNull
    public static final String EXTRA_NEW_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_NEW_ACCESS_TOKEN";
    @NotNull
    public static final String SHARED_PREFERENCES_NAME = "com.facebook.AccessTokenManager.SharedPreferences";
    private static final int TOKEN_EXTEND_THRESHOLD_SECONDS = 86400;
    private static final int TOKEN_EXTEND_RETRY_SECONDS = 3600;
    private static final String ME_PERMISSIONS_GRAPH_PATH = "me/permissions";
    private static AccessTokenManager instanceField;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final AccessToken getCurrentAccessToken() {
        return this.currentAccessTokenField;
    }

    public final void setCurrentAccessToken(@Nullable AccessToken value) {
        this.setCurrentAccessToken(value, true);
    }

    public final boolean loadCurrentAccessToken() {
        AccessToken accessToken = this.accessTokenCache.load();
        if (accessToken != null) {
            this.setCurrentAccessToken(accessToken, false);
            return true;
        }
        return false;
    }

    public final void currentAccessTokenChanged() {
        this.sendCurrentAccessTokenChangedBroadcastIntent(this.getCurrentAccessToken(), this.getCurrentAccessToken());
    }

    private final void setCurrentAccessToken(AccessToken currentAccessToken, boolean saveToCache) {
        AccessToken oldAccessToken = this.currentAccessTokenField;
        this.currentAccessTokenField = currentAccessToken;
        this.tokenRefreshInProgress.set(false);
        this.lastAttemptedTokenExtendDate = new Date(0L);
        if (saveToCache) {
            if (currentAccessToken != null) {
                this.accessTokenCache.save(currentAccessToken);
            } else {
                this.accessTokenCache.clear();
                Utility.clearFacebookCookies(FacebookSdk.getApplicationContext());
            }
        }
        if (!Utility.areObjectsEqual(oldAccessToken, currentAccessToken)) {
            this.sendCurrentAccessTokenChangedBroadcastIntent(oldAccessToken, currentAccessToken);
            this.setTokenExpirationBroadcastAlarm();
        }
    }

    private final void sendCurrentAccessTokenChangedBroadcastIntent(AccessToken oldAccessToken, AccessToken currentAccessToken) {
        Intent intent = new Intent(FacebookSdk.getApplicationContext(), CurrentAccessTokenExpirationBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        intent.putExtra(EXTRA_OLD_ACCESS_TOKEN, (Parcelable)oldAccessToken);
        intent.putExtra(EXTRA_NEW_ACCESS_TOKEN, (Parcelable)currentAccessToken);
        this.localBroadcastManager.sendBroadcast(intent);
    }

    private final void setTokenExpirationBroadcastAlarm() {
        AlarmManager alarmManager;
        AccessToken accessToken;
        Context context;
        block5: {
            block4: {
                context = FacebookSdk.getApplicationContext();
                accessToken = AccessToken.Companion.getCurrentAccessToken();
                alarmManager = (AlarmManager)context.getSystemService("alarm");
                if (!AccessToken.Companion.isCurrentAccessTokenActive()) break block4;
                AccessToken accessToken2 = accessToken;
                if ((accessToken2 != null ? accessToken2.getExpires() : null) != null && alarmManager != null) break block5;
            }
            return;
        }
        Intent intent = new Intent(context, CurrentAccessTokenExpirationBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        PendingIntent alarmIntent = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        try {
            alarmManager.set(1, accessToken.getExpires().getTime(), alarmIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void extendAccessTokenIfNeeded() {
        if (!this.shouldExtendAccessToken()) {
            return;
        }
        this.refreshCurrentAccessToken(null);
    }

    private final boolean shouldExtendAccessToken() {
        AccessToken accessToken = this.getCurrentAccessToken();
        if (accessToken == null) {
            return false;
        }
        AccessToken currentAccessToken = accessToken;
        long now = new Date().getTime();
        return currentAccessToken.getSource().canExtendToken() && now - this.lastAttemptedTokenExtendDate.getTime() > (long)3600000 && now - currentAccessToken.getLastRefresh().getTime() > (long)86400000;
    }

    public final void refreshCurrentAccessToken(@Nullable AccessToken.AccessTokenRefreshCallback callback2) {
        if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
            this.refreshCurrentAccessTokenImpl(callback2);
        } else {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(new Runnable(this, callback2){
                final /* synthetic */ AccessTokenManager this$0;
                final /* synthetic */ AccessToken.AccessTokenRefreshCallback $callback;

                public final void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        AccessTokenManager.access$refreshCurrentAccessTokenImpl(this.this$0, this.$callback);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
                {
                    this.this$0 = accessTokenManager;
                    this.$callback = accessTokenRefreshCallback;
                }
            });
        }
    }

    private final void refreshCurrentAccessTokenImpl(AccessToken.AccessTokenRefreshCallback callback2) {
        AccessToken accessToken = this.getCurrentAccessToken();
        if (accessToken == null) {
            AccessToken.AccessTokenRefreshCallback accessTokenRefreshCallback = callback2;
            if (accessTokenRefreshCallback != null) {
                accessTokenRefreshCallback.OnTokenRefreshFailed(new FacebookException("No current access token to refresh"));
            }
            return;
        }
        if (!this.tokenRefreshInProgress.compareAndSet(false, true)) {
            AccessToken.AccessTokenRefreshCallback accessTokenRefreshCallback = callback2;
            if (accessTokenRefreshCallback != null) {
                accessTokenRefreshCallback.OnTokenRefreshFailed(new FacebookException("Refresh already in progress"));
            }
            return;
        }
        this.lastAttemptedTokenExtendDate = new Date();
        Set permissions = new HashSet();
        Set declinedPermissions = new HashSet();
        Set expiredPermissions = new HashSet();
        AtomicBoolean permissionsCallSucceeded = new AtomicBoolean(false);
        RefreshResult refreshResult = new RefreshResult();
        GraphRequestBatch batch2 = new GraphRequestBatch(AccessTokenManager.Companion.createGrantedPermissionsRequest(accessToken, new GraphRequest.Callback(permissionsCallSucceeded, permissions, declinedPermissions, expiredPermissions){
            final /* synthetic */ AtomicBoolean $permissionsCallSucceeded;
            final /* synthetic */ Set $permissions;
            final /* synthetic */ Set $declinedPermissions;
            final /* synthetic */ Set $expiredPermissions;

            /*
             * Unable to fully structure code
             */
            public final void onCompleted(@NotNull GraphResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                v0 = response.getJsonObject();
                if (v0 == null) {
                    return;
                }
                result = v0;
                v1 = result.optJSONArray("data");
                if (v1 == null) {
                    return;
                }
                permissionsArray = v1;
                this.$permissionsCallSucceeded.set(true);
                var4_4 = 0;
                var5_5 = permissionsArray.length();
                while (var4_4 < var5_5) {
                    block10: {
                        block11: {
                            block12: {
                                block9: {
                                    if (permissionsArray.optJSONObject((int)i) != null) break block9;
                                    break block10;
                                }
                                permission = permissionEntry.optString("permission");
                                status = permissionEntry.optString("status");
                                if (Utility.isNullOrEmpty(permission) || Utility.isNullOrEmpty(status)) break block10;
                                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                                Intrinsics.checkNotNullExpressionValue((Object)Locale.US, (String)"Locale.US");
                                var11_11 = false;
                                var12_12 = var9_9;
                                var13_13 = false;
                                v2 = var12_12;
                                if (v2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                v3 = v2.toLowerCase(var10_10);
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"(this as java.lang.String).toLowerCase(locale)");
                                v4 = status = v3;
                                if (v4 == null) break block11;
                                var9_9 = v4;
                                switch (var9_9.hashCode()) {
                                    case 568196142: {
                                        if (!var9_9.equals("declined")) ** break;
                                        break;
                                    }
                                    case -1309235419: {
                                        if (!var9_9.equals("expired")) ** break;
                                        break block12;
                                    }
                                    case 280295099: {
                                        if (!var9_9.equals("granted")) ** break;
                                        this.$permissions.add(permission);
                                        break block10;
                                    }
                                }
                                this.$declinedPermissions.add(permission);
                                break block10;
                            }
                            this.$expiredPermissions.add(permission);
                            break block10;
                        }
                        Log.w((String)"AccessTokenManager", (String)("Unexpected status: " + status));
                    }
                    ++i;
                }
            }
            {
                this.$permissionsCallSucceeded = atomicBoolean;
                this.$permissions = set;
                this.$declinedPermissions = set2;
                this.$expiredPermissions = set3;
            }
        }), AccessTokenManager.Companion.createExtendAccessTokenRequest(accessToken, new GraphRequest.Callback(refreshResult){
            final /* synthetic */ RefreshResult $refreshResult;

            public final void onCompleted(@NotNull GraphResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                JSONObject jSONObject = response.getJsonObject();
                if (jSONObject == null) {
                    return;
                }
                JSONObject data = jSONObject;
                this.$refreshResult.setAccessToken(data.optString("access_token"));
                this.$refreshResult.setExpiresAt(data.optInt("expires_at"));
                this.$refreshResult.setExpiresIn(data.optInt("expires_in"));
                this.$refreshResult.setDataAccessExpirationTime(data.optLong("data_access_expiration_time"));
                this.$refreshResult.setGraphDomain(data.optString("graph_domain", null));
            }
            {
                this.$refreshResult = refreshResult;
            }
        }));
        batch2.addCallback(new GraphRequestBatch.Callback(this, refreshResult, accessToken, callback2, permissionsCallSucceeded, permissions, declinedPermissions, expiredPermissions){
            final /* synthetic */ AccessTokenManager this$0;
            final /* synthetic */ RefreshResult $refreshResult;
            final /* synthetic */ AccessToken $accessToken;
            final /* synthetic */ AccessToken.AccessTokenRefreshCallback $callback;
            final /* synthetic */ AtomicBoolean $permissionsCallSucceeded;
            final /* synthetic */ Set $permissions;
            final /* synthetic */ Set $declinedPermissions;
            final /* synthetic */ Set $expiredPermissions;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onBatchCompleted(@NotNull GraphRequestBatch it) {
                String string;
                String returnGraphDomain;
                Long returnDataAccessExpirationTime;
                String returnAccessToken;
                AccessToken newAccessToken;
                block17: {
                    int returnExpiresAt;
                    block16: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        newAccessToken = null;
                        returnAccessToken = this.$refreshResult.getAccessToken();
                        returnExpiresAt = this.$refreshResult.getExpiresAt();
                        returnDataAccessExpirationTime = this.$refreshResult.getDataAccessExpirationTime();
                        returnGraphDomain = this.$refreshResult.getGraphDomain();
                        try {
                            if (AccessTokenManager.Companion.getInstance().getCurrentAccessToken() != null) {
                                AccessToken accessToken = AccessTokenManager.Companion.getInstance().getCurrentAccessToken();
                                if ((accessToken != null ? accessToken.getUserId() : null) == this.$accessToken.getUserId()) break block16;
                            }
                            AccessToken.AccessTokenRefreshCallback accessTokenRefreshCallback = this.$callback;
                            if (accessTokenRefreshCallback != null) {
                                accessTokenRefreshCallback.OnTokenRefreshFailed(new FacebookException("No current access token to refresh"));
                            }
                            AccessTokenManager.access$getTokenRefreshInProgress$p(this.this$0).set(false);
                            if (this.$callback != null) {
                                // empty if block
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            AccessTokenManager.access$getTokenRefreshInProgress$p(this.this$0).set(false);
                            if (this.$callback != null && newAccessToken != null) {
                                this.$callback.OnTokenRefreshed(newAccessToken);
                            }
                            throw throwable;
                        }
                    }
                    if (this.$permissionsCallSucceeded.get() || returnAccessToken != null || returnExpiresAt != 0) break block17;
                    AccessToken.AccessTokenRefreshCallback accessTokenRefreshCallback = this.$callback;
                    if (accessTokenRefreshCallback != null) {
                        accessTokenRefreshCallback.OnTokenRefreshFailed(new FacebookException("Failed to refresh access token"));
                    }
                    AccessTokenManager.access$getTokenRefreshInProgress$p(this.this$0).set(false);
                    if (this.$callback != null) {
                        // empty if block
                    }
                    return;
                }
                Date expirationTime = this.$accessToken.getExpires();
                if (this.$refreshResult.getExpiresAt() != 0) {
                    expirationTime = new Date((long)this.$refreshResult.getExpiresAt() * 1000L);
                } else if (this.$refreshResult.getExpiresIn() != 0) {
                    long now = new Date().getTime();
                    expirationTime = new Date((long)this.$refreshResult.getExpiresIn() * 1000L + now);
                }
                if ((string = returnAccessToken) == null) {
                    string = this.$accessToken.getToken();
                }
                String string2 = this.$accessToken.getApplicationId();
                String string3 = this.$accessToken.getUserId();
                Collection collection = this.$permissionsCallSucceeded.get() ? this.$permissions : this.$accessToken.getPermissions();
                Collection collection2 = this.$permissionsCallSucceeded.get() ? this.$declinedPermissions : this.$accessToken.getDeclinedPermissions();
                Collection collection3 = this.$permissionsCallSucceeded.get() ? this.$expiredPermissions : this.$accessToken.getExpiredPermissions();
                AccessTokenSource accessTokenSource = this.$accessToken.getSource();
                Date date = new Date();
                Date date2 = returnDataAccessExpirationTime != null ? new Date(returnDataAccessExpirationTime * 1000L) : this.$accessToken.getDataAccessExpirationTime();
                String string4 = returnGraphDomain;
                if (string4 == null) {
                    string4 = this.$accessToken.getGraphDomain();
                }
                newAccessToken = new AccessToken(string, string2, string3, collection, collection2, collection3, accessTokenSource, expirationTime, date, date2, string4);
                AccessTokenManager.Companion.getInstance().setCurrentAccessToken(newAccessToken);
                AccessTokenManager.access$getTokenRefreshInProgress$p(this.this$0).set(false);
                if (this.$callback != null) {
                    this.$callback.OnTokenRefreshed(newAccessToken);
                }
            }
            {
                this.this$0 = accessTokenManager;
                this.$refreshResult = refreshResult;
                this.$accessToken = accessToken;
                this.$callback = accessTokenRefreshCallback;
                this.$permissionsCallSucceeded = atomicBoolean;
                this.$permissions = set;
                this.$declinedPermissions = set2;
                this.$expiredPermissions = set3;
            }
        });
        batch2.executeAsync();
    }

    public AccessTokenManager(@NotNull LocalBroadcastManager localBroadcastManager, @NotNull AccessTokenCache accessTokenCache) {
        Intrinsics.checkNotNullParameter((Object)localBroadcastManager, (String)"localBroadcastManager");
        Intrinsics.checkNotNullParameter((Object)accessTokenCache, (String)"accessTokenCache");
        this.localBroadcastManager = localBroadcastManager;
        this.accessTokenCache = accessTokenCache;
        this.tokenRefreshInProgress = new AtomicBoolean(false);
        this.lastAttemptedTokenExtendDate = new Date(0L);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$refreshCurrentAccessTokenImpl(AccessTokenManager $this, AccessToken.AccessTokenRefreshCallback callback2) {
        $this.refreshCurrentAccessTokenImpl(callback2);
    }

    public static final /* synthetic */ AtomicBoolean access$getTokenRefreshInProgress$p(AccessTokenManager $this) {
        return $this.tokenRefreshInProgress;
    }

    @JvmStatic
    @NotNull
    public static final AccessTokenManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "", "grantType", "", "getGrantType", "()Ljava/lang/String;", "graphPath", "getGraphPath", "facebook-core_release"})
    public static interface RefreshTokenInfo {
        @NotNull
        public String getGraphPath();

        @NotNull
        public String getGrantType();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/facebook/AccessTokenManager$FacebookRefreshTokenInfo;", "Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "()V", "grantType", "", "getGrantType", "()Ljava/lang/String;", "graphPath", "getGraphPath", "facebook-core_release"})
    public static final class FacebookRefreshTokenInfo
    implements RefreshTokenInfo {
        @NotNull
        private final String graphPath;
        @NotNull
        private final String grantType;

        @Override
        @NotNull
        public String getGraphPath() {
            return this.graphPath;
        }

        @Override
        @NotNull
        public String getGrantType() {
            return this.grantType;
        }

        public FacebookRefreshTokenInfo() {
            this.graphPath = "oauth/access_token";
            this.grantType = "fb_extend_sso_token";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/facebook/AccessTokenManager$InstagramRefreshTokenInfo;", "Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "()V", "grantType", "", "getGrantType", "()Ljava/lang/String;", "graphPath", "getGraphPath", "facebook-core_release"})
    public static final class InstagramRefreshTokenInfo
    implements RefreshTokenInfo {
        @NotNull
        private final String graphPath;
        @NotNull
        private final String grantType;

        @Override
        @NotNull
        public String getGraphPath() {
            return this.graphPath;
        }

        @Override
        @NotNull
        public String getGrantType() {
            return this.grantType;
        }

        public InstagramRefreshTokenInfo() {
            this.graphPath = "refresh_access_token";
            this.grantType = "ig_refresh_token";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/facebook/AccessTokenManager$RefreshResult;", "", "()V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "dataAccessExpirationTime", "", "getDataAccessExpirationTime", "()Ljava/lang/Long;", "setDataAccessExpirationTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "expiresAt", "", "getExpiresAt", "()I", "setExpiresAt", "(I)V", "expiresIn", "getExpiresIn", "setExpiresIn", "graphDomain", "getGraphDomain", "setGraphDomain", "facebook-core_release"})
    private static final class RefreshResult {
        @Nullable
        private String accessToken;
        private int expiresAt;
        private int expiresIn;
        @Nullable
        private Long dataAccessExpirationTime;
        @Nullable
        private String graphDomain;

        @Nullable
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            this.accessToken = string;
        }

        public final int getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(int n) {
            this.expiresAt = n;
        }

        public final int getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(int n) {
            this.expiresIn = n;
        }

        @Nullable
        public final Long getDataAccessExpirationTime() {
            return this.dataAccessExpirationTime;
        }

        public final void setDataAccessExpirationTime(@Nullable Long l) {
            this.dataAccessExpirationTime = l;
        }

        @Nullable
        public final String getGraphDomain() {
            return this.graphDomain;
        }

        public final void setGraphDomain(@Nullable String string) {
            this.graphDomain = string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/AccessTokenManager$Companion;", "", "()V", "ACTION_CURRENT_ACCESS_TOKEN_CHANGED", "", "EXTRA_NEW_ACCESS_TOKEN", "EXTRA_OLD_ACCESS_TOKEN", "ME_PERMISSIONS_GRAPH_PATH", "SHARED_PREFERENCES_NAME", "TAG", "TOKEN_EXTEND_RETRY_SECONDS", "", "TOKEN_EXTEND_THRESHOLD_SECONDS", "instanceField", "Lcom/facebook/AccessTokenManager;", "createExtendAccessTokenRequest", "Lcom/facebook/GraphRequest;", "accessToken", "Lcom/facebook/AccessToken;", "callback", "Lcom/facebook/GraphRequest$Callback;", "createGrantedPermissionsRequest", "getInstance", "getRefreshTokenInfoForToken", "Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "facebook-core_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final AccessTokenManager getInstance() {
            AccessTokenManager instance = instanceField;
            if (instance == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    AccessTokenManager accessTokenManager;
                    boolean bl3 = false;
                    AccessTokenManager instance2 = instanceField;
                    if (instance2 == null) {
                        Context applicationContext = FacebookSdk.getApplicationContext();
                        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
                        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"LocalBroadcastManager.ge\u2026tance(applicationContext)");
                        LocalBroadcastManager localBroadcastManager2 = localBroadcastManager;
                        AccessTokenCache accessTokenCache = new AccessTokenCache();
                        AccessTokenManager newInstance = new AccessTokenManager(localBroadcastManager2, accessTokenCache);
                        instanceField = newInstance;
                        accessTokenManager = newInstance;
                    } else {
                        accessTokenManager = instance2;
                    }
                    AccessTokenManager accessTokenManager2 = accessTokenManager;
                    return accessTokenManager2;
                }
            }
            return instance;
        }

        private final GraphRequest createGrantedPermissionsRequest(AccessToken accessToken, GraphRequest.Callback callback2) {
            Bundle parameters = new Bundle();
            return new GraphRequest(accessToken, AccessTokenManager.ME_PERMISSIONS_GRAPH_PATH, parameters, HttpMethod.GET, callback2, null, 32, null);
        }

        private final RefreshTokenInfo getRefreshTokenInfoForToken(AccessToken accessToken) {
            RefreshTokenInfo refreshTokenInfo;
            String tokenGraphDomain;
            String string = accessToken.getGraphDomain();
            if (string == null) {
                string = "facebook";
            }
            String string2 = tokenGraphDomain = string;
            switch (string2.hashCode()) {
                case 28903346: {
                    if (string2.equals("instagram")) {
                        refreshTokenInfo = new InstagramRefreshTokenInfo();
                        break;
                    }
                }
                default: {
                    refreshTokenInfo = new FacebookRefreshTokenInfo();
                }
            }
            return refreshTokenInfo;
        }

        private final GraphRequest createExtendAccessTokenRequest(AccessToken accessToken, GraphRequest.Callback callback2) {
            RefreshTokenInfo refreshInfo = this.getRefreshTokenInfoForToken(accessToken);
            Bundle parameters = new Bundle();
            parameters.putString("grant_type", refreshInfo.getGrantType());
            parameters.putString("client_id", accessToken.getApplicationId());
            return new GraphRequest(accessToken, refreshInfo.getGraphPath(), parameters, HttpMethod.GET, callback2, null, 32, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

