/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001#B\u001b\b\u0016\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB%\b\u0016\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\u000fB\u001f\b\u0016\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\u0010B\u0017\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J)\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u0002H\u0017\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\b\u0010 \u001a\u00020\u001eH\u0017J\b\u0010!\u001a\u00020\"H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0015\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u00142\u000e\u0010\u0012\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/facebook/GraphRequestAsyncTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "Lcom/facebook/GraphResponse;", "requests", "", "Lcom/facebook/GraphRequest;", "([Lcom/facebook/GraphRequest;)V", "", "(Ljava/util/Collection;)V", "Lcom/facebook/GraphRequestBatch;", "(Lcom/facebook/GraphRequestBatch;)V", "connection", "Ljava/net/HttpURLConnection;", "(Ljava/net/HttpURLConnection;[Lcom/facebook/GraphRequest;)V", "(Ljava/net/HttpURLConnection;Ljava/util/Collection;)V", "(Ljava/net/HttpURLConnection;Lcom/facebook/GraphRequestBatch;)V", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "getRequests", "()Lcom/facebook/GraphRequestBatch;", "doInBackground", "params", "([Ljava/lang/Void;)Ljava/util/List;", "onPostExecute", "", "result", "onPreExecute", "toString", "", "Companion", "facebook-core_release"})
public class GraphRequestAsyncTask
extends AsyncTask<Void, Void, List<? extends GraphResponse>> {
    @Nullable
    private Exception exception;
    private final HttpURLConnection connection;
    @NotNull
    private final GraphRequestBatch requests;
    private static final String TAG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    protected final Exception getException() {
        return this.exception;
    }

    @NotNull
    public String toString() {
        String string = "{RequestAsyncTask: " + " connection: " + this.connection + ", requests: " + this.requests + "}";
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder()\n        \u2026(\"}\")\n        .toString()");
        return string;
    }

    @VisibleForTesting(otherwise=4)
    public void onPreExecute() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            super.onPreExecute();
            if (FacebookSdk.isDebugEnabled()) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "execute async task: %s";
                Object[] objectArray = new Object[]{this};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                Utility.logd(TAG, string2);
            }
            if (this.requests.getCallbackHandler() == null) {
                Handler handler = Thread.currentThread() instanceof HandlerThread ? new Handler() : new Handler(Looper.getMainLooper());
                this.requests.setCallbackHandler(handler);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onPostExecute(@NotNull List<GraphResponse> list) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void result;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            super.onPostExecute((Object)result);
            Exception exception = this.exception;
            if (exception != null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "onPostExecute: exception encountered during request: %s";
                Object[] objectArray = new Object[]{exception.getMessage()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                Utility.logd(TAG, string2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=4)
    @Nullable
    public List<GraphResponse> doInBackground(Void ... voidArray) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            List<GraphResponse> list;
            void params;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            try {
                list = this.connection == null ? this.requests.executeAndWait() : GraphRequest.Companion.executeConnectionAndWait(this.connection, this.requests);
            }
            catch (Exception e) {
                this.exception = e;
                list = null;
            }
            return list;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return null;
        }
    }

    @NotNull
    public final GraphRequestBatch getRequests() {
        return this.requests;
    }

    public GraphRequestAsyncTask(@Nullable HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        this.connection = connection;
        this.requests = requests;
    }

    public GraphRequestAsyncTask(GraphRequest ... requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        this((HttpURLConnection)null, new GraphRequestBatch(Arrays.copyOf(requests, requests.length)));
    }

    public GraphRequestAsyncTask(@NotNull Collection<GraphRequest> requests) {
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        this((HttpURLConnection)null, new GraphRequestBatch(requests));
    }

    public GraphRequestAsyncTask(@NotNull GraphRequestBatch requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        this((HttpURLConnection)null, requests);
    }

    public GraphRequestAsyncTask(@Nullable HttpURLConnection connection, GraphRequest ... requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        this(connection, new GraphRequestBatch(Arrays.copyOf(requests, requests.length)));
    }

    public GraphRequestAsyncTask(@Nullable HttpURLConnection connection, @NotNull Collection<GraphRequest> requests) {
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        this(connection, new GraphRequestBatch(requests));
    }

    static {
        Companion = new Companion(null);
        TAG = GraphRequestAsyncTask.class.getCanonicalName();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/GraphRequestAsyncTask$Companion;", "", "()V", "TAG", "", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

