/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.ProfileManager;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0001*BO\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0012\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0016\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cJ\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u0004\u0018\u00010\rJ\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001cH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/facebook/Profile;", "Landroid/os/Parcelable;", "id", "", "firstName", "middleName", "lastName", "name", "linkUri", "Landroid/net/Uri;", "pictureUri", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/net/Uri;Landroid/net/Uri;)V", "jsonObject", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getFirstName", "()Ljava/lang/String;", "getId", "getLastName", "getLinkUri", "()Landroid/net/Uri;", "getMiddleName", "getName", "getPictureUri", "describeContents", "", "equals", "", "other", "", "getProfilePictureUri", "width", "height", "hashCode", "toJSONObject", "writeToParcel", "", "dest", "flags", "Companion", "facebook-core_release"})
public final class Profile
implements Parcelable {
    @Nullable
    private final String id;
    @Nullable
    private final String firstName;
    @Nullable
    private final String middleName;
    @Nullable
    private final String lastName;
    @Nullable
    private final String name;
    @Nullable
    private final Uri linkUri;
    @Nullable
    private final Uri pictureUri;
    private static final String TAG;
    private static final String ID_KEY = "id";
    private static final String FIRST_NAME_KEY = "first_name";
    private static final String MIDDLE_NAME_KEY = "middle_name";
    private static final String LAST_NAME_KEY = "last_name";
    private static final String NAME_KEY = "name";
    private static final String LINK_URI_KEY = "link_uri";
    private static final String PICTURE_URI_KEY = "picture_uri";
    @JvmField
    @NotNull
    public static final Parcelable.Creator<Profile> CREATOR;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getFirstName() {
        return this.firstName;
    }

    @Nullable
    public final String getMiddleName() {
        return this.middleName;
    }

    @Nullable
    public final String getLastName() {
        return this.lastName;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Uri getLinkUri() {
        return this.linkUri;
    }

    @Nullable
    public final Uri getPictureUri() {
        return this.pictureUri;
    }

    @NotNull
    public final Uri getProfilePictureUri(int width, int height) {
        String string;
        if (this.pictureUri != null) {
            return this.pictureUri;
        }
        if (AccessToken.Companion.isCurrentAccessTokenActive()) {
            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
            string = accessToken != null ? accessToken.getToken() : null;
        } else {
            string = "";
        }
        String accessToken = string;
        return ImageRequest.Companion.getProfilePictureUri(this.id, width, height, accessToken);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Profile)) {
            return false;
        }
        return (this.id == null && ((Profile)other).id == null || Intrinsics.areEqual((Object)this.id, (Object)((Profile)other).id)) && (this.firstName == null && ((Profile)other).firstName == null || Intrinsics.areEqual((Object)this.firstName, (Object)((Profile)other).firstName)) && (this.middleName == null && ((Profile)other).middleName == null || Intrinsics.areEqual((Object)this.middleName, (Object)((Profile)other).middleName)) && (this.lastName == null && ((Profile)other).lastName == null || Intrinsics.areEqual((Object)this.lastName, (Object)((Profile)other).lastName)) && (this.name == null && ((Profile)other).name == null || Intrinsics.areEqual((Object)this.name, (Object)((Profile)other).name)) && (this.linkUri == null && ((Profile)other).linkUri == null || Intrinsics.areEqual((Object)this.linkUri, (Object)((Profile)other).linkUri)) && (this.pictureUri == null && ((Profile)other).pictureUri == null || Intrinsics.areEqual((Object)this.pictureUri, (Object)((Profile)other).pictureUri));
    }

    public int hashCode() {
        int result = 17;
        String string = this.id;
        boolean bl = false;
        String string2 = string;
        result = result * 31 + (string2 != null ? string2.hashCode() : 0);
        if (this.firstName != null) {
            result = result * 31 + this.firstName.hashCode();
        }
        if (this.middleName != null) {
            result = result * 31 + this.middleName.hashCode();
        }
        if (this.lastName != null) {
            result = result * 31 + this.lastName.hashCode();
        }
        if (this.name != null) {
            result = result * 31 + this.name.hashCode();
        }
        if (this.linkUri != null) {
            result = result * 31 + this.linkUri.hashCode();
        }
        if (this.pictureUri != null) {
            result = result * 31 + this.pictureUri.hashCode();
        }
        return result;
    }

    @Nullable
    public final JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(ID_KEY, (Object)this.id);
            jsonObject.put(FIRST_NAME_KEY, (Object)this.firstName);
            jsonObject.put(MIDDLE_NAME_KEY, (Object)this.middleName);
            jsonObject.put(LAST_NAME_KEY, (Object)this.lastName);
            jsonObject.put(NAME_KEY, (Object)this.name);
            if (this.linkUri != null) {
                jsonObject.put(LINK_URI_KEY, (Object)this.linkUri.toString());
            }
            if (this.pictureUri != null) {
                jsonObject.put(PICTURE_URI_KEY, (Object)this.pictureUri.toString());
            }
        }
        catch (JSONException _) {
            return null;
        }
        return jsonObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.id);
        dest.writeString(this.firstName);
        dest.writeString(this.middleName);
        dest.writeString(this.lastName);
        dest.writeString(this.name);
        Uri uri = this.linkUri;
        dest.writeString(uri != null ? uri.toString() : null);
        Uri uri2 = this.pictureUri;
        dest.writeString(uri2 != null ? uri2.toString() : null);
    }

    @JvmOverloads
    public Profile(@Nullable String id, @Nullable String firstName, @Nullable String middleName, @Nullable String lastName, @Nullable String name, @Nullable Uri linkUri, @Nullable Uri pictureUri) {
        Validate.notNullOrEmpty(id, ID_KEY);
        this.id = id;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.name = name;
        this.linkUri = linkUri;
        this.pictureUri = pictureUri;
    }

    public /* synthetic */ Profile(String string, String string2, String string3, String string4, String string5, Uri uri, Uri uri2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            uri2 = null;
        }
        this(string, string2, string3, string4, string5, uri, uri2);
    }

    @JvmOverloads
    public Profile(@Nullable String id, @Nullable String firstName, @Nullable String middleName, @Nullable String lastName, @Nullable String name, @Nullable Uri linkUri) {
        this(id, firstName, middleName, lastName, name, linkUri, null, 64, null);
    }

    public Profile(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        this.id = jsonObject.optString(ID_KEY, null);
        this.firstName = jsonObject.optString(FIRST_NAME_KEY, null);
        this.middleName = jsonObject.optString(MIDDLE_NAME_KEY, null);
        this.lastName = jsonObject.optString(LAST_NAME_KEY, null);
        this.name = jsonObject.optString(NAME_KEY, null);
        String linkUriString = jsonObject.optString(LINK_URI_KEY, null);
        this.linkUri = linkUriString == null ? null : Uri.parse((String)linkUriString);
        String pictureUriString = jsonObject.optString(PICTURE_URI_KEY, null);
        this.pictureUri = pictureUriString == null ? null : Uri.parse((String)pictureUriString);
    }

    private Profile(Parcel source) {
        this.id = source.readString();
        this.firstName = source.readString();
        this.middleName = source.readString();
        this.lastName = source.readString();
        this.name = source.readString();
        String linkUriString = source.readString();
        this.linkUri = linkUriString == null ? null : Uri.parse((String)linkUriString);
        String pictureUriString = source.readString();
        this.pictureUri = pictureUriString == null ? null : Uri.parse((String)pictureUriString);
    }

    static {
        Companion = new Companion(null);
        String string = Profile.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Profile::class.java.simpleName");
        TAG = string;
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<Profile>(){

            @NotNull
            public Profile createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new Profile(source, null);
            }

            @NotNull
            public Profile[] newArray(int size) {
                return new Profile[size];
            }
        };
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public /* synthetic */ Profile(Parcel source, DefaultConstructorMarker $constructor_marker) {
        this(source);
    }

    @JvmStatic
    @Nullable
    public static final Profile getCurrentProfile() {
        return Companion.getCurrentProfile();
    }

    @JvmStatic
    public static final void setCurrentProfile(@Nullable Profile profile) {
        Companion.setCurrentProfile(profile);
    }

    @JvmStatic
    public static final void fetchProfileForCurrentAccessToken() {
        Companion.fetchProfileForCurrentAccessToken();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/Profile$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/Profile;", "FIRST_NAME_KEY", "", "ID_KEY", "LAST_NAME_KEY", "LINK_URI_KEY", "MIDDLE_NAME_KEY", "NAME_KEY", "PICTURE_URI_KEY", "TAG", "fetchProfileForCurrentAccessToken", "", "getCurrentProfile", "setCurrentProfile", "profile", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Profile getCurrentProfile() {
            return ProfileManager.Companion.getInstance().getCurrentProfile();
        }

        @JvmStatic
        public final void setCurrentProfile(@Nullable Profile profile) {
            ProfileManager.Companion.getInstance().setCurrentProfile(profile);
        }

        @JvmStatic
        public final void fetchProfileForCurrentAccessToken() {
            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
            if (accessToken == null) {
                return;
            }
            AccessToken accessToken2 = accessToken;
            if (!AccessToken.Companion.isCurrentAccessTokenActive()) {
                this.setCurrentProfile(null);
                return;
            }
            Utility.getGraphMeRequestWithCacheAsync(accessToken2.getToken(), new Utility.GraphMeRequestWithCacheCallback(){

                public void onSuccess(@Nullable JSONObject userInfo) {
                    String id;
                    JSONObject jSONObject = userInfo;
                    String string = id = jSONObject != null ? jSONObject.optString("id") : null;
                    if (id == null) {
                        Log.w((String)Profile.access$getTAG$cp(), (String)"No user ID returned on Me request");
                        return;
                    }
                    String link = userInfo.optString("link");
                    String picture = userInfo.optString("profile_picture", null);
                    Profile profile = new Profile(id, userInfo.optString("first_name"), userInfo.optString("middle_name"), userInfo.optString("last_name"), userInfo.optString("name"), link != null ? Uri.parse((String)link) : null, picture != null ? Uri.parse((String)picture) : null);
                    Profile.Companion.setCurrentProfile(profile);
                }

                public void onFailure(@Nullable FacebookException error) {
                    Log.e((String)Profile.access$getTAG$cp(), (String)("Got unexpected exception: " + error));
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

