/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.app.Activity;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import com.facebook.FacebookSdk;
import com.facebook.appevents.aam.MetadataIndexer;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.appevents.aam.MetadataViewObserver;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/appevents/aam/MetadataIndexer;", "", "()V", "TAG", "", "enabled", "", "enable", "", "onActivityResumed", "activity", "Landroid/app/Activity;", "updateRules", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MetadataIndexer {
    private static final String TAG;
    private static boolean enabled;
    @NotNull
    public static final MetadataIndexer INSTANCE;

    @JvmStatic
    @UiThread
    public static final void onActivityResumed(@NotNull Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            Activity activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            try {
                if (!enabled || MetadataRule.Companion.getRules().isEmpty()) {
                    return;
                }
                MetadataViewObserver.Companion.startTrackingActivity(activity2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    private final void updateRules() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (fetchedAppSettings == null) {
                return;
            }
            FetchedAppSettings settings = fetchedAppSettings;
            String string = settings.getRawAamRules();
            if (string == null) {
                return;
            }
            String rawRule = string;
            MetadataRule.Companion.updateRules(rawRule);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            try {
                FacebookSdk.getExecutor().execute(enable.1.INSTANCE);
            }
            catch (Exception e) {
                Utility.logd(TAG, e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    private MetadataIndexer() {
    }

    static {
        MetadataIndexer metadataIndexer;
        INSTANCE = metadataIndexer = new MetadataIndexer();
        TAG = MetadataIndexer.class.getCanonicalName();
    }

    public static final /* synthetic */ void access$updateRules(MetadataIndexer metadataIndexer) {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            MetadataIndexer $this;
            $this.updateRules();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    public static final /* synthetic */ boolean access$getEnabled$p(MetadataIndexer metadataIndexer) {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return false;
        }
        try {
            MetadataIndexer $this;
            MetadataIndexer metadataIndexer2 = $this;
            return enabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setEnabled$p(MetadataIndexer metadataIndexer, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            void <set-?>;
            MetadataIndexer $this;
            MetadataIndexer metadataIndexer2 = $this;
            enabled = <set-?>;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }
}

