/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.appevents.iap.InAppPurchaseEventManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001aj\b\u0012\u0004\u0012\u00020\u0004`\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0007J\b\u0010\u001e\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseActivityLifecycleTracker;", "", "()V", "BILLING_ACTIVITY_NAME", "", "SERVICE_INTERFACE_NAME", "TAG", "callbacks", "Landroid/app/Application$ActivityLifecycleCallbacks;", "hasBillingActivity", "", "Ljava/lang/Boolean;", "hasBillingService", "inAppBillingObj", "intent", "Landroid/content/Intent;", "isTracking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serviceConnection", "Landroid/content/ServiceConnection;", "initializeIfNotInitialized", "", "logPurchase", "context", "Landroid/content/Context;", "purchases", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isSubscription", "startIapLogging", "startTracking", "facebook-core_release"})
public final class InAppPurchaseActivityLifecycleTracker {
    private static final String TAG;
    private static final String SERVICE_INTERFACE_NAME = "com.android.vending.billing.IInAppBillingService$Stub";
    private static final String BILLING_ACTIVITY_NAME = "com.android.billingclient.api.ProxyBillingActivity";
    private static final AtomicBoolean isTracking;
    private static Boolean hasBillingService;
    private static Boolean hasBillingActivity;
    private static ServiceConnection serviceConnection;
    private static Application.ActivityLifecycleCallbacks callbacks;
    private static Intent intent;
    private static Object inAppBillingObj;
    @NotNull
    public static final InAppPurchaseActivityLifecycleTracker INSTANCE;

    @JvmStatic
    public static final void startIapLogging() {
        INSTANCE.initializeIfNotInitialized();
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            INSTANCE.startTracking();
        }
    }

    private final void initializeIfNotInitialized() {
        if (hasBillingService != null) {
            return;
        }
        hasBillingService = InAppPurchaseUtils.getClass(SERVICE_INTERFACE_NAME) != null;
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        hasBillingActivity = InAppPurchaseUtils.getClass(BILLING_ACTIVITY_NAME) != null;
        InAppPurchaseEventManager.clearSkuDetailsCache();
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(\"com.android.vend\u2026ge(\"com.android.vending\")");
        InAppPurchaseActivityLifecycleTracker.intent = intent;
        serviceConnection = new ServiceConnection(){

            public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                InAppPurchaseActivityLifecycleTracker.access$setInAppBillingObj$p(InAppPurchaseActivityLifecycleTracker.INSTANCE, InAppPurchaseEventManager.asInterface(FacebookSdk.getApplicationContext(), service));
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }
        };
        callbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    FacebookSdk.getExecutor().execute(initializeIfNotInitialized.onActivityResumed.1.INSTANCE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    if (Intrinsics.areEqual((Object)InAppPurchaseActivityLifecycleTracker.access$getHasBillingActivity$p(InAppPurchaseActivityLifecycleTracker.INSTANCE), (Object)true) && Intrinsics.areEqual((Object)activity.getLocalClassName(), (Object)"com.android.billingclient.api.ProxyBillingActivity")) {
                        FacebookSdk.getExecutor().execute(initializeIfNotInitialized.onActivityStopped.1.INSTANCE);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }
        };
    }

    private final void startTracking() {
        if (!isTracking.compareAndSet(false, true)) {
            return;
        }
        Context context = FacebookSdk.getApplicationContext();
        if (context instanceof Application) {
            Application application = (Application)context;
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = callbacks;
            if (activityLifecycleCallbacks == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"callbacks");
            }
            application.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
            Intent intent = InAppPurchaseActivityLifecycleTracker.intent;
            if (intent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"intent");
            }
            ServiceConnection serviceConnection = InAppPurchaseActivityLifecycleTracker.serviceConnection;
            if (serviceConnection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceConnection");
            }
            context.bindService(intent, serviceConnection, 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logPurchase(Context context, ArrayList<String> purchases, boolean isSubscription) {
        Object sku;
        if (purchases.isEmpty()) {
            return;
        }
        boolean bl = false;
        HashMap purchaseMap = new HashMap();
        boolean bl2 = false;
        ArrayList<String> skuList = new ArrayList<String>();
        Object object = purchases.iterator();
        while (object.hasNext()) {
            String purchase = object.next();
            try {
                JSONObject purchaseJson = new JSONObject(purchase);
                sku = purchaseJson.getString("productId");
                Map map = purchaseMap;
                Object object2 = sku;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sku");
                String string = purchase;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"purchase");
                map.put(object2, string);
                skuList.add((String)sku);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
            }
        }
        Map<String, String> skuDetailsMap = InAppPurchaseEventManager.getSkuDetails(context, skuList, inAppBillingObj, isSubscription);
        sku = skuDetailsMap;
        boolean bl3 = false;
        Iterator<Map.Entry<String, String>> iterator = sku.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Object object3 = object = iterator.next();
            boolean bl4 = false;
            sku = (String)object3.getKey();
            object3 = object;
            bl4 = false;
            String value = (String)object3.getValue();
            String string = (String)purchaseMap.get(key);
            if (string == null) continue;
            object3 = string;
            bl4 = false;
            boolean bl5 = false;
            Object it = object3;
            boolean bl6 = false;
            Object object4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
            AutomaticAnalyticsLogger.logPurchase((String)object4, value, isSubscription);
        }
    }

    private InAppPurchaseActivityLifecycleTracker() {
    }

    static {
        InAppPurchaseActivityLifecycleTracker inAppPurchaseActivityLifecycleTracker;
        INSTANCE = inAppPurchaseActivityLifecycleTracker = new InAppPurchaseActivityLifecycleTracker();
        TAG = InAppPurchaseActivityLifecycleTracker.class.getCanonicalName();
        isTracking = new AtomicBoolean(false);
    }

    public static final /* synthetic */ Object access$getInAppBillingObj$p(InAppPurchaseActivityLifecycleTracker $this) {
        InAppPurchaseActivityLifecycleTracker inAppPurchaseActivityLifecycleTracker = $this;
        return inAppBillingObj;
    }

    public static final /* synthetic */ void access$setInAppBillingObj$p(InAppPurchaseActivityLifecycleTracker $this, Object object) {
        InAppPurchaseActivityLifecycleTracker inAppPurchaseActivityLifecycleTracker = $this;
        inAppBillingObj = object;
    }

    public static final /* synthetic */ void access$logPurchase(InAppPurchaseActivityLifecycleTracker $this, Context context, ArrayList purchases, boolean isSubscription) {
        $this.logPurchase(context, purchases, isSubscription);
    }

    public static final /* synthetic */ Boolean access$getHasBillingActivity$p(InAppPurchaseActivityLifecycleTracker $this) {
        InAppPurchaseActivityLifecycleTracker inAppPurchaseActivityLifecycleTracker = $this;
        return hasBillingActivity;
    }

    public static final /* synthetic */ void access$setHasBillingActivity$p(InAppPurchaseActivityLifecycleTracker $this, Boolean bl) {
        InAppPurchaseActivityLifecycleTracker inAppPurchaseActivityLifecycleTracker = $this;
        hasBillingActivity = bl;
    }
}

