/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\rH\u0001\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aJC\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0001\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J2\u0010 \u001a\u00020\u00192\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\r2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0007J\u001c\u0010!\u001a\u00020\u00192\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseLoggerManager;", "", "()V", "CACHE_CLEAR_TIME_LIMIT_SEC", "", "LAST_CLEARED_TIME", "", "LAST_QUERY_PURCHASE_HISTORY_TIME", "PRODUCT_DETAILS_STORE", "PURCHASE_DETAILS_SET", "PURCHASE_IN_CACHE_INTERVAL", "PURCHASE_TIME", "cachedPurchaseMap", "", "", "cachedPurchaseSet", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "cacheDeDupPurchase", "", "Lorg/json/JSONObject;", "purchaseDetailsMap", "cacheDeDupPurchase$facebook_core_release", "clearOutdatedProductInfoInCache", "", "clearOutdatedProductInfoInCache$facebook_core_release", "constructLoggingReadyMap", "skuDetailsMap", "constructLoggingReadyMap$facebook_core_release", "eligibleQueryPurchaseHistory", "", "filterPurchaseLogging", "logPurchases", "readPurchaseCache", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseLoggerManager {
    private static SharedPreferences sharedPreferences;
    private static final Set<String> cachedPurchaseSet;
    private static final Map<String, Long> cachedPurchaseMap;
    private static final String PURCHASE_TIME = "purchaseTime";
    private static final String PRODUCT_DETAILS_STORE = "com.facebook.internal.iap.PRODUCT_DETAILS";
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    private static final String PURCHASE_DETAILS_SET = "PURCHASE_DETAILS_SET";
    private static final String LAST_QUERY_PURCHASE_HISTORY_TIME = "LAST_QUERY_PURCHASE_HISTORY_TIME";
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int PURCHASE_IN_CACHE_INTERVAL = 86400;
    @NotNull
    public static final InAppPurchaseLoggerManager INSTANCE;

    private final void readPurchaseCache() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Collection collection;
            SharedPreferences cachedSkuSharedPref = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.SKU_DETAILS", 0);
            SharedPreferences cachedPurchaseSharedPref = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.PURCHASE", 0);
            if (cachedSkuSharedPref.contains(LAST_CLEARED_TIME)) {
                cachedSkuSharedPref.edit().clear().apply();
                cachedPurchaseSharedPref.edit().clear().apply();
            }
            SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(PRODUCT_DETAILS_STORE, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getApplicationContext().\u2026RE, Context.MODE_PRIVATE)");
            SharedPreferences sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences = sharedPreferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            }
            boolean bl = false;
            Set set = sharedPreferences2.getStringSet(PURCHASE_DETAILS_SET, (Set)new HashSet());
            if (set != null) {
                collection = set;
            } else {
                bl = false;
                collection = new HashSet();
            }
            cachedPurchaseSet.addAll(collection);
            for (String purchaseHistory : cachedPurchaseSet) {
                List splitPurchase = StringsKt.split$default((CharSequence)purchaseHistory, (String[])new String[]{";"}, (boolean)false, (int)2, (int)2, null);
                String string = (String)splitPurchase.get(1);
                boolean bl2 = false;
                cachedPurchaseMap.put((String)splitPurchase.get(0), Long.parseLong(string));
            }
            this.clearOutdatedProductInfoInCache$facebook_core_release();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void filterPurchaseLogging(@NotNull Map<String, JSONObject> map, @NotNull Map<String, ? extends JSONObject> map2) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            void skuDetailsMap;
            Map<String, JSONObject> purchaseDetailsMap;
            Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
            Intrinsics.checkNotNullParameter((Object)skuDetailsMap, (String)"skuDetailsMap");
            INSTANCE.readPurchaseCache();
            Map<String, String> loggingReadyMap = INSTANCE.constructLoggingReadyMap$facebook_core_release(INSTANCE.cacheDeDupPurchase$facebook_core_release(purchaseDetailsMap), (Map<String, ? extends JSONObject>)skuDetailsMap);
            INSTANCE.logPurchases(loggingReadyMap);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logPurchases(Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void purchaseDetailsMap;
            String string = purchaseDetailsMap;
            boolean bl = false;
            Iterator iterator = string.entrySet().iterator();
            while (iterator.hasNext()) {
                void purchaseDetails;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                string = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                String skuDetails = (String)entry2.getValue();
                if (purchaseDetails == null || skuDetails == null) continue;
                AutomaticAnalyticsLogger.logPurchase((String)purchaseDetails, skuDetails, false);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, JSONObject> cacheDeDupPurchase$facebook_core_release(@NotNull Map<String, JSONObject> map) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void purchaseDetailsMap;
            Intrinsics.checkNotNullParameter((Object)purchaseDetailsMap, (String)"purchaseDetailsMap");
            long nowSec = System.currentTimeMillis() / 1000L;
            Map tempPurchaseDetailsMap = MapsKt.toMap((Map)purchaseDetailsMap);
            Object object = tempPurchaseDetailsMap;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                JSONObject purchaseJson = (JSONObject)entry2.getValue();
                try {
                    if (!purchaseJson.has("purchaseToken")) continue;
                    String purchaseToken = purchaseJson.getString("purchaseToken");
                    if (cachedPurchaseMap.containsKey(purchaseToken)) {
                        void key;
                        purchaseDetailsMap.remove(key);
                        continue;
                    }
                    cachedPurchaseSet.add(purchaseToken + ';' + nowSec);
                }
                catch (Exception exception) {}
            }
            SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            }
            sharedPreferences.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).apply();
            return new HashMap(purchaseDetailsMap);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    public final void clearOutdatedProductInfoInCache$facebook_core_release() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            long lastClearedTimeSec;
            long nowSec = System.currentTimeMillis() / 1000L;
            SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            }
            if ((lastClearedTimeSec = sharedPreferences.getLong(LAST_CLEARED_TIME, 0L)) == 0L) {
                SharedPreferences sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences;
                if (sharedPreferences2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                }
                sharedPreferences2.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
            } else if (nowSec - lastClearedTimeSec > (long)604800) {
                Map tempPurchaseMap = MapsKt.toMap(cachedPurchaseMap);
                Object object = tempPurchaseMap;
                boolean bl = false;
                Iterator iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void purchaseToken;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    object = (String)entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    long historyPurchaseTime = ((Number)entry2.getValue()).longValue();
                    if (nowSec - historyPurchaseTime <= (long)86400) continue;
                    cachedPurchaseSet.remove((String)purchaseToken + ';' + historyPurchaseTime);
                    cachedPurchaseMap.remove(purchaseToken);
                }
                SharedPreferences sharedPreferences3 = InAppPurchaseLoggerManager.sharedPreferences;
                if (sharedPreferences3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                }
                sharedPreferences3.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).putLong(LAST_CLEARED_TIME, nowSec).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final boolean eligibleQueryPurchaseHistory() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return false;
        }
        try {
            long lastQueryPurchaseHistoryTime;
            INSTANCE.readPurchaseCache();
            long nowSec = System.currentTimeMillis() / 1000L;
            SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            }
            if ((lastQueryPurchaseHistoryTime = sharedPreferences.getLong(LAST_QUERY_PURCHASE_HISTORY_TIME, 0L)) != 0L && nowSec - lastQueryPurchaseHistoryTime < (long)86400) {
                return false;
            }
            SharedPreferences sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            }
            sharedPreferences2.edit().putLong(LAST_QUERY_PURCHASE_HISTORY_TIME, nowSec).apply();
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, String> constructLoggingReadyMap$facebook_core_release(@NotNull Map<String, ? extends JSONObject> map, @NotNull Map<String, ? extends JSONObject> map2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void skuDetailsMap;
            void purchaseDetailsMap;
            Intrinsics.checkNotNullParameter((Object)purchaseDetailsMap, (String)"purchaseDetailsMap");
            Intrinsics.checkNotNullParameter((Object)skuDetailsMap, (String)"skuDetailsMap");
            long nowSec = System.currentTimeMillis() / 1000L;
            boolean bl = false;
            Map purchaseResultMap = new LinkedHashMap();
            String string = purchaseDetailsMap;
            boolean bl2 = false;
            Iterator iterator = string.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl3 = false;
                string = (String)entry2.getKey();
                entry2 = entry;
                bl3 = false;
                JSONObject purchaseDetail = (JSONObject)entry2.getValue();
                JSONObject skuDetail = (JSONObject)skuDetailsMap.get(key);
                if (purchaseDetail == null || !purchaseDetail.has(PURCHASE_TIME)) continue;
                try {
                    long purchaseTime = purchaseDetail.getLong(PURCHASE_TIME);
                    if (nowSec - purchaseTime / 1000L > (long)86400 || skuDetail == null) continue;
                    String string2 = purchaseDetail.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchaseDetail.toString()");
                    String string3 = skuDetail.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"skuDetail.toString()");
                    purchaseResultMap.put(string2, string3);
                }
                catch (Exception exception) {}
            }
            return purchaseResultMap;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private InAppPurchaseLoggerManager() {
    }

    static {
        InAppPurchaseLoggerManager inAppPurchaseLoggerManager;
        INSTANCE = inAppPurchaseLoggerManager = new InAppPurchaseLoggerManager();
        cachedPurchaseSet = new CopyOnWriteArraySet();
        cachedPurchaseMap = new ConcurrentHashMap();
    }
}

