/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import androidx.annotation.RestrictTo;
import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.ml.Operator;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J+\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/appevents/ml/Model;", "", "weights", "", "", "Lcom/facebook/appevents/ml/MTensor;", "(Ljava/util/Map;)V", "convs0Bias", "convs0Weight", "convs1Bias", "convs1Weight", "convs2Bias", "convs2Weight", "embedding", "fc1Bias", "fc1Weight", "fc2Bias", "fc2Weight", "finalWeights", "", "predictOnMTML", "dense", "texts", "", "task", "(Lcom/facebook/appevents/ml/MTensor;[Ljava/lang/String;Ljava/lang/String;)Lcom/facebook/appevents/ml/MTensor;", "Companion", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Model {
    private final MTensor embedding;
    private final MTensor convs0Weight;
    private final MTensor convs1Weight;
    private final MTensor convs2Weight;
    private final MTensor convs0Bias;
    private final MTensor convs1Bias;
    private final MTensor convs2Bias;
    private final MTensor fc1Weight;
    private final MTensor fc2Weight;
    private final MTensor fc1Bias;
    private final MTensor fc2Bias;
    private final Map<String, MTensor> finalWeights;
    private static final int SEQ_LEN = 128;
    private static final Map<String, String> mapping;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MTensor predictOnMTML(@NotNull MTensor mTensor, @NotNull String[] stringArray, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void task2;
            void texts;
            void dense;
            Intrinsics.checkNotNullParameter((Object)dense, (String)"dense");
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            MTensor embed = Operator.embedding((String[])texts, 128, this.embedding);
            MTensor c0 = Operator.conv1D(embed, this.convs0Weight);
            Operator.addmv(c0, this.convs0Bias);
            Operator.relu(c0);
            MTensor c1 = Operator.conv1D(c0, this.convs1Weight);
            Operator.addmv(c1, this.convs1Bias);
            Operator.relu(c1);
            c1 = Operator.maxPool1D(c1, 2);
            MTensor c2 = Operator.conv1D(c1, this.convs2Weight);
            Operator.addmv(c2, this.convs2Bias);
            Operator.relu(c2);
            c0 = Operator.maxPool1D(c0, c0.getShape(1));
            c1 = Operator.maxPool1D(c1, c1.getShape(1));
            c2 = Operator.maxPool1D(c2, c2.getShape(1));
            Operator.flatten(c0, 1);
            Operator.flatten(c1, 1);
            Operator.flatten(c2, 1);
            MTensor concat = Operator.concatenate(new MTensor[]{c0, c1, c2, dense});
            MTensor dense1 = Operator.dense(concat, this.fc1Weight, this.fc1Bias);
            Operator.relu(dense1);
            MTensor dense2 = Operator.dense(dense1, this.fc2Weight, this.fc2Bias);
            Operator.relu(dense2);
            MTensor fc3Weight = this.finalWeights.get((String)task2 + ".weight");
            MTensor fc3Bias = this.finalWeights.get((String)task2 + ".bias");
            if (fc3Weight == null || fc3Bias == null) {
                return null;
            }
            MTensor res = Operator.dense(dense2, fc3Weight, fc3Bias);
            Operator.softmax(res);
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private Model(Map<String, MTensor> weights) {
        MTensor mTensor = weights.get("embed.weight");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (mTensor == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.embedding = mTensor;
        mTensor = weights.get("convs.0.weight");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl5 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.convs0Weight = Operator.transpose3D(mTensor);
        mTensor = weights.get("convs.1.weight");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.convs1Weight = Operator.transpose3D(mTensor);
        mTensor = weights.get("convs.2.weight");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl7 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.convs2Weight = Operator.transpose3D(mTensor);
        mTensor = weights.get("convs.0.bias");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl8 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.convs0Bias = mTensor;
        mTensor = weights.get("convs.1.bias");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl9 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.convs1Bias = mTensor;
        mTensor = weights.get("convs.2.bias");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl10 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.convs2Bias = mTensor;
        mTensor = weights.get("fc1.weight");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl11 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.fc1Weight = Operator.transpose2D(mTensor);
        mTensor = weights.get("fc2.weight");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl12 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.fc2Weight = Operator.transpose2D(mTensor);
        mTensor = weights.get("fc1.bias");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl13 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.fc1Bias = mTensor;
        mTensor = weights.get("fc2.bias");
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (mTensor == null) {
            boolean bl14 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.fc2Bias = mTensor;
        this.finalWeights = new HashMap();
        Set tasks = SetsKt.setOf((Object[])new String[]{ModelManager.Task.MTML_INTEGRITY_DETECT.toKey(), ModelManager.Task.MTML_APP_EVENT_PREDICTION.toKey()});
        for (String task2 : tasks) {
            String weightKey = task2 + ".weight";
            String biasKey = task2 + ".bias";
            MTensor weight = weights.get(weightKey);
            MTensor bias = weights.get(biasKey);
            if (weight != null) {
                weight = Operator.transpose2D(weight);
                this.finalWeights.put(weightKey, weight);
            }
            if (bias == null) continue;
            this.finalWeights.put(biasKey, bias);
        }
    }

    static {
        Companion = new Companion(null);
        mapping = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"embedding.weight", (Object)"embed.weight"), TuplesKt.to((Object)"dense1.weight", (Object)"fc1.weight"), TuplesKt.to((Object)"dense2.weight", (Object)"fc2.weight"), TuplesKt.to((Object)"dense3.weight", (Object)"fc3.weight"), TuplesKt.to((Object)"dense1.bias", (Object)"fc1.bias"), TuplesKt.to((Object)"dense2.bias", (Object)"fc2.bias"), TuplesKt.to((Object)"dense3.bias", (Object)"fc3.bias")});
    }

    public /* synthetic */ Model(Map weights, DefaultConstructorMarker $constructor_marker) {
        this(weights);
    }

    public static final /* synthetic */ Map access$getMapping$cp() {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            return mapping;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/ml/Model$Companion;", "", "()V", "SEQ_LEN", "", "mapping", "", "", "build", "Lcom/facebook/appevents/ml/Model;", "file", "Ljava/io/File;", "parse", "Lcom/facebook/appevents/ml/MTensor;", "facebook-core_release"})
    public static final class Companion {
        @Nullable
        public final Model build(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Map<String, MTensor> map = this.parse(file);
            if (map == null) {
                return null;
            }
            Map<String, MTensor> weights = map;
            try {
                return new Model(weights, null);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private final Map<String, MTensor> parse(File file) {
            Map<String, MTensor> originalWeights = Utils.parseModelWeights(file);
            if (originalWeights != null) {
                Map weights = new HashMap();
                Map mapping = Model.access$getMapping$cp();
                for (Map.Entry<String, MTensor> entry : originalWeights.entrySet()) {
                    String finalKey = entry.getKey();
                    if (mapping.containsKey(entry.getKey())) {
                        String string = (String)mapping.get(entry.getKey());
                        if (string == null) {
                            return null;
                        }
                        finalKey = string;
                    }
                    weights.put(finalKey, entry.getValue());
                }
                return weights;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

