/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 \u00192\u00020\u0001:\u0003\u0017\u0018\u0019B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/facebook/internal/ImageRequest;", "", "context", "Landroid/content/Context;", "imageUri", "Landroid/net/Uri;", "callback", "Lcom/facebook/internal/ImageRequest$Callback;", "allowCachedRedirects", "", "callerTag", "(Landroid/content/Context;Landroid/net/Uri;Lcom/facebook/internal/ImageRequest$Callback;ZLjava/lang/Object;)V", "getAllowCachedRedirects", "()Z", "getCallback", "()Lcom/facebook/internal/ImageRequest$Callback;", "getCallerTag", "()Ljava/lang/Object;", "getContext", "()Landroid/content/Context;", "getImageUri", "()Landroid/net/Uri;", "isCachedRedirectAllowed", "Builder", "Callback", "Companion", "facebook-core_release"})
public final class ImageRequest {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri imageUri;
    @Nullable
    private final Callback callback;
    private final boolean allowCachedRedirects;
    @NotNull
    private final Object callerTag;
    public static final int UNSPECIFIED_DIMENSION = 0;
    private static final String PATH = "%s/%s/picture";
    private static final String HEIGHT_PARAM = "height";
    private static final String WIDTH_PARAM = "width";
    private static final String ACCESS_TOKEN_PARAM = "access_token";
    private static final String MIGRATION_PARAM = "migration_overrides";
    private static final String MIGRATION_VALUE = "{october_2012:true}";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isCachedRedirectAllowed() {
        return this.allowCachedRedirects;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Uri getImageUri() {
        return this.imageUri;
    }

    @Nullable
    public final Callback getCallback() {
        return this.callback;
    }

    public final boolean getAllowCachedRedirects() {
        return this.allowCachedRedirects;
    }

    @NotNull
    public final Object getCallerTag() {
        return this.callerTag;
    }

    private ImageRequest(Context context, Uri imageUri, Callback callback2, boolean allowCachedRedirects, Object callerTag) {
        this.context = context;
        this.imageUri = imageUri;
        this.callback = callback2;
        this.allowCachedRedirects = allowCachedRedirects;
        this.callerTag = callerTag;
    }

    public /* synthetic */ ImageRequest(Context context, Uri imageUri, Callback callback2, boolean allowCachedRedirects, Object callerTag, DefaultConstructorMarker $constructor_marker) {
        this(context, imageUri, callback2, allowCachedRedirects, callerTag);
    }

    @JvmStatic
    @NotNull
    public static final Uri getProfilePictureUri(@Nullable String userId, int width, int height) {
        return Companion.getProfilePictureUri(userId, width, height);
    }

    @JvmStatic
    @NotNull
    public static final Uri getProfilePictureUri(@Nullable String userId, int width, int height, @Nullable String accessToken) {
        return Companion.getProfilePictureUri(userId, width, height, accessToken);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/ImageRequest$Callback;", "", "onCompleted", "", "response", "Lcom/facebook/internal/ImageResponse;", "facebook-core_release"})
    public static interface Callback {
        public void onCompleted(@Nullable ImageResponse var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/internal/ImageRequest$Builder;", "", "context", "Landroid/content/Context;", "imageUri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "allowCachedRedirects", "", "callback", "Lcom/facebook/internal/ImageRequest$Callback;", "callerTag", "build", "Lcom/facebook/internal/ImageRequest;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "setAllowCachedRedirects", "setCallback", "setCallerTag", "toString", "", "facebook-core_release"})
    public static final class Builder {
        private Callback callback;
        private boolean allowCachedRedirects;
        private Object callerTag;
        private final Context context;
        private final Uri imageUri;

        @NotNull
        public final Builder setCallback(@Nullable Callback callback2) {
            this.callback = callback2;
            return this;
        }

        @NotNull
        public final Builder setCallerTag(@Nullable Object callerTag) {
            this.callerTag = callerTag;
            return this;
        }

        @NotNull
        public final Builder setAllowCachedRedirects(boolean allowCachedRedirects) {
            this.allowCachedRedirects = allowCachedRedirects;
            return this;
        }

        @NotNull
        public final ImageRequest build() {
            Object object;
            if (this.callerTag == null) {
                object = new Object();
            } else {
                Object object2 = this.callerTag;
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (object2 == null) {
                    boolean bl4 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                object = object2;
            }
            return new ImageRequest(this.context, this.imageUri, this.callback, this.allowCachedRedirects, object, null);
        }

        public Builder(@NotNull Context context, @NotNull Uri imageUri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
            this.context = context;
            this.imageUri = imageUri;
        }

        private final Context component1() {
            return this.context;
        }

        private final Uri component2() {
            return this.imageUri;
        }

        @NotNull
        public final Builder copy(@NotNull Context context, @NotNull Uri imageUri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
            return new Builder(context, imageUri);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, Context context, Uri uri, int n, Object object) {
            if ((n & 1) != 0) {
                context = builder.context;
            }
            if ((n & 2) != 0) {
                uri = builder.imageUri;
            }
            return builder.copy(context, uri);
        }

        @NotNull
        public String toString() {
            return "Builder(context=" + this.context + ", imageUri=" + this.imageUri + ")";
        }

        public int hashCode() {
            Context context = this.context;
            Uri uri = this.imageUri;
            return (context != null ? context.hashCode() : 0) * 31 + (uri != null ? uri.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Builder)) break block3;
                    Builder builder = (Builder)object;
                    if (!Intrinsics.areEqual((Object)this.context, (Object)builder.context) || !Intrinsics.areEqual((Object)this.imageUri, (Object)builder.imageUri)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007J,\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/internal/ImageRequest$Companion;", "", "()V", "ACCESS_TOKEN_PARAM", "", "HEIGHT_PARAM", "MIGRATION_PARAM", "MIGRATION_VALUE", "PATH", "UNSPECIFIED_DIMENSION", "", "WIDTH_PARAM", "getProfilePictureUri", "Landroid/net/Uri;", "userId", "width", "height", "accessToken", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Uri getProfilePictureUri(@Nullable String userId, int width, int height) {
            return this.getProfilePictureUri(userId, width, height, "");
        }

        @JvmStatic
        @NotNull
        public final Uri getProfilePictureUri(@Nullable String userId, int width, int height, @Nullable String accessToken) {
            int width2 = width;
            int height2 = height;
            Validate.notNullOrEmpty(userId, "userId");
            width2 = Math.max(width2, 0);
            height2 = Math.max(height2, 0);
            boolean bl = width2 != 0 || height2 != 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Either width or height must be greater than 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Uri.Builder builder = Uri.parse((String)ServerProtocol.getGraphUrlBase()).buildUpon();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string = ImageRequest.PATH;
            Object[] objectArray = new Object[]{FacebookSdk.getGraphApiVersion(), userId};
            boolean bl5 = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            Uri.Builder builder2 = builder.path(string2);
            if (height2 != 0) {
                builder2.appendQueryParameter(ImageRequest.HEIGHT_PARAM, String.valueOf(height2));
            }
            if (width2 != 0) {
                builder2.appendQueryParameter(ImageRequest.WIDTH_PARAM, String.valueOf(width2));
            }
            builder2.appendQueryParameter(ImageRequest.MIGRATION_PARAM, ImageRequest.MIGRATION_VALUE);
            if (!Utility.isNullOrEmpty(accessToken)) {
                builder2.appendQueryParameter(ImageRequest.ACCESS_TOKEN_PARAM, accessToken);
            } else if (!Utility.isNullOrEmpty(FacebookSdk.getClientToken()) && !Utility.isNullOrEmpty(FacebookSdk.getApplicationId())) {
                builder2.appendQueryParameter(ImageRequest.ACCESS_TOKEN_PARAM, FacebookSdk.getApplicationId() + "|" + FacebookSdk.getClientToken());
            } else {
                Log.d((String)"ImageRequest", (String)"Needs access token to fetch profile picture. Without an access token a default silhoutte picture is returned");
            }
            Uri uri = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"builder.build()");
            return uri;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

