/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookSdk;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0013\u0010\u0003\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/LockOnGetVariable;", "T", "", "value", "(Ljava/lang/Object;)V", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "initLatch", "Ljava/util/concurrent/CountDownLatch;", "storedValue", "Ljava/lang/Object;", "getValue", "()Ljava/lang/Object;", "waitOnInit", "", "facebook-core_release"})
public final class LockOnGetVariable<T> {
    private T storedValue;
    private CountDownLatch initLatch;

    @Nullable
    public final T getValue() {
        this.waitOnInit();
        return this.storedValue;
    }

    private final void waitOnInit() {
        CountDownLatch countDownLatch = this.initLatch;
        if (countDownLatch == null) {
            return;
        }
        CountDownLatch latch = countDownLatch;
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LockOnGetVariable(T value) {
        this.storedValue = value;
    }

    public LockOnGetVariable(final @NotNull Callable<T> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        this.initLatch = new CountDownLatch(1);
        FacebookSdk.getExecutor().execute(new FutureTask(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Void call() {
                try {
                    storedValue = callable.call();
                }
                finally {
                    CountDownLatch countDownLatch = initLatch;
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
                return null;
            }
        }));
    }

    public static final /* synthetic */ Object access$getStoredValue$p(LockOnGetVariable $this) {
        return $this.storedValue;
    }

    public static final /* synthetic */ void access$setInitLatch$p(LockOnGetVariable $this, CountDownLatch countDownLatch) {
        $this.initLatch = countDownLatch;
    }
}

