/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.dumpsys;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\r\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver;", "", "()V", "initialized", "", "paramsField", "Ljava/lang/reflect/Field;", "viewsField", "windowManagerObj", "attachActiveRootListener", "", "listener", "Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$Listener;", "initialize", "listActiveRoots", "", "Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$Root;", "Companion", "ListenableArrayList", "Listener", "Root", "facebook-core_release"})
public final class AndroidRootResolver {
    private boolean initialized;
    private Object windowManagerObj;
    private Field viewsField;
    private Field paramsField;
    private static final String TAG;
    private static final String WINDOW_MANAGER_IMPL_CLAZZ = "android.view.WindowManagerImpl";
    private static final String WINDOW_MANAGER_GLOBAL_CLAZZ = "android.view.WindowManagerGlobal";
    private static final String VIEWS_FIELD = "mViews";
    private static final String WINDOW_PARAMS_FIELD = "mParams";
    private static final String GET_DEFAULT_IMPL = "getDefault";
    private static final String GET_GLOBAL_INSTANCE = "getInstance";
    @NotNull
    public static final Companion Companion;

    public final void attachActiveRootListener(@Nullable Listener listener2) {
        if (Build.VERSION.SDK_INT < 19 || listener2 == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        try {
            Field field = Field.class.getDeclaredField("accessFlags");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"Field::class.java.getDeclaredField(\"accessFlags\")");
            Field modifiers = field;
            modifiers.setAccessible(true);
            Field field2 = this.viewsField;
            modifiers.setInt(this.viewsField, field2 != null ? field2.getModifiers() : 0);
            Field field3 = this.viewsField;
            Object object = field3 != null ? field3.get(this.windowManagerObj) : null;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.ArrayList<android.view.View> /* = java.util.ArrayList<android.view.View> */");
            }
            ArrayList views = (ArrayList)object;
            ListenableArrayList listenableViews = new ListenableArrayList();
            listenableViews.setListener(listener2);
            listenableViews.addAll(views);
            Field field4 = this.viewsField;
            if (field4 != null) {
                field4.set(this.windowManagerObj, listenableViews);
            }
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"Couldn't attach root listener.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Root> listActiveRoots() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.windowManagerObj == null) {
            Log.d((String)TAG, (String)"No reflective access to windowmanager object.");
            return null;
        }
        if (this.viewsField == null) {
            Log.d((String)TAG, (String)"No reflective access to mViews");
            return null;
        }
        if (this.paramsField == null) {
            Log.d((String)TAG, (String)"No reflective access to mPArams");
            return null;
        }
        List views = null;
        List params = null;
        try {
            if (Build.VERSION.SDK_INT < 19) {
                Field field = this.viewsField;
                Object[] objectArray = (View[])(field != null ? field.get(this.windowManagerObj) : null);
                views = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                Field field2 = this.paramsField;
                Object[] objectArray2 = (WindowManager.LayoutParams[])(field2 != null ? field2.get(this.windowManagerObj) : null);
                params = objectArray2 != null ? ArraysKt.toList((Object[])objectArray2) : null;
            } else {
                Field field = this.viewsField;
                views = (List)(field != null ? field.get(this.windowManagerObj) : null);
                Field field3 = this.paramsField;
                params = (List)(field3 != null ? field3.get(this.windowManagerObj) : null);
            }
        }
        catch (RuntimeException re) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Reflective access to %s or %s on %s failed.";
            Object[] objectArray = new Object[]{this.viewsField, this.paramsField, this.windowManagerObj};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string2, (Throwable)re);
            return null;
        }
        catch (IllegalAccessException iae) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Reflective access to %s or %s on %s failed.";
            Object[] objectArray = new Object[]{this.viewsField, this.paramsField, this.windowManagerObj};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string3, (Throwable)iae);
            return null;
        }
        List roots = new ArrayList();
        List list = views;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List list2 = params;
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)list, (Iterable)(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void view;
            Pair $dstr$view$param = (Pair)element$iv;
            boolean bl = false;
            View view2 = (View)$dstr$view$param.component1();
            WindowManager.LayoutParams param = (WindowManager.LayoutParams)$dstr$view$param.component2();
            roots.add(new Root((View)view, param));
        }
        return roots;
    }

    private final void initialize() {
        this.initialized = true;
        String accessClass = Build.VERSION.SDK_INT > 16 ? WINDOW_MANAGER_GLOBAL_CLAZZ : WINDOW_MANAGER_IMPL_CLAZZ;
        String instanceMethod = Build.VERSION.SDK_INT > 16 ? GET_GLOBAL_INSTANCE : GET_DEFAULT_IMPL;
        try {
            Class<?> clazz = Class.forName(accessClass);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(accessClass)");
            Class<?> clazz2 = clazz;
            Method method = clazz2.getMethod(instanceMethod, new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"clazz.getMethod(instanceMethod)");
            Method getMethod = method;
            this.windowManagerObj = getMethod.invoke(null, new Object[0]);
            Field field = this.viewsField = clazz2.getDeclaredField(VIEWS_FIELD);
            if (field != null) {
                field.setAccessible(true);
            }
            Field field2 = this.paramsField = clazz2.getDeclaredField(WINDOW_PARAMS_FIELD);
            if (field2 != null) {
                field2.setAccessible(true);
            }
        }
        catch (InvocationTargetException ite) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "could not invoke: %s on %s";
            Object[] objectArray = new Object[]{instanceMethod, accessClass};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string2, (Throwable)ite.getCause());
        }
        catch (ClassNotFoundException cnfe) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "could not find class: %s";
            Object[] objectArray = new Object[]{accessClass};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string3, (Throwable)cnfe);
        }
        catch (NoSuchFieldException nsfe) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "could not find field: %s or %s on %s";
            Object[] objectArray = new Object[]{WINDOW_PARAMS_FIELD, VIEWS_FIELD, accessClass};
            boolean bl = false;
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string4, (Throwable)nsfe);
        }
        catch (NoSuchMethodException nsme) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "could not find method: %s on %s";
            Object[] objectArray = new Object[]{instanceMethod, accessClass};
            boolean bl = false;
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string5, (Throwable)nsme);
        }
        catch (RuntimeException re) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "reflective setup failed using obj: %s method: %s field: %s";
            Object[] objectArray = new Object[]{accessClass, instanceMethod, VIEWS_FIELD};
            boolean bl = false;
            String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string6, (Throwable)re);
        }
        catch (IllegalAccessException iae) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "reflective setup failed using obj: %s method: %s field: %s";
            Object[] objectArray = new Object[]{accessClass, instanceMethod, VIEWS_FIELD};
            boolean bl = false;
            String string7 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
            Log.d((String)TAG, (String)string7, (Throwable)iae);
        }
    }

    static {
        Companion = new Companion(null);
        String string = AndroidRootResolver.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AndroidRootResolver::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$Root;", "", "view", "Landroid/view/View;", "param", "Landroid/view/WindowManager$LayoutParams;", "(Landroid/view/View;Landroid/view/WindowManager$LayoutParams;)V", "getParam", "()Landroid/view/WindowManager$LayoutParams;", "getView", "()Landroid/view/View;", "facebook-core_release"})
    public static final class Root {
        @NotNull
        private final View view;
        @NotNull
        private final WindowManager.LayoutParams param;

        @NotNull
        public final View getView() {
            return this.view;
        }

        @NotNull
        public final WindowManager.LayoutParams getParam() {
            return this.param;
        }

        public Root(@NotNull View view, @NotNull WindowManager.LayoutParams param) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.view = view;
            this.param = param;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u001a\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$Listener;", "", "onRootAdded", "", "root", "Landroid/view/View;", "onRootRemoved", "onRootsChanged", "roots", "", "facebook-core_release"})
    public static interface Listener {
        public void onRootAdded(@Nullable View var1);

        public void onRootRemoved(@Nullable View var1);

        public void onRootsChanged(@Nullable List<? extends View> var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\n\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$ListenableArrayList;", "Ljava/util/ArrayList;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "()V", "listener", "Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$Listener;", "add", "", "value", "remove", "removeAt", "index", "", "setListener", "", "facebook-core_release"})
    public static final class ListenableArrayList
    extends ArrayList<View> {
        private Listener listener;

        public final void setListener(@Nullable Listener listener2) {
            this.listener = listener2;
        }

        @Override
        public boolean add(@Nullable View value) {
            boolean ret;
            block2: {
                ret = super.add(value);
                if (!ret || this.listener == null) break block2;
                Listener listener2 = this.listener;
                if (listener2 != null) {
                    listener2.onRootAdded(value);
                }
                Listener listener3 = this.listener;
                if (listener3 != null) {
                    listener3.onRootsChanged(this);
                }
            }
            return ret;
        }

        public boolean remove(@Nullable View value) {
            boolean ret;
            block2: {
                ret = super.remove(value);
                if (!ret || this.listener == null || !(value instanceof View)) break block2;
                Listener listener2 = this.listener;
                if (listener2 != null) {
                    listener2.onRootRemoved(value);
                }
                Listener listener3 = this.listener;
                if (listener3 != null) {
                    listener3.onRootsChanged(this);
                }
            }
            return ret;
        }

        @Nullable
        public View removeAt(int index) {
            View view;
            block2: {
                view = (View)super.remove(index);
                if (this.listener == null) break block2;
                Listener listener2 = this.listener;
                if (listener2 != null) {
                    listener2.onRootRemoved(view);
                }
                Listener listener3 = this.listener;
                if (listener3 != null) {
                    listener3.onRootsChanged(this);
                }
            }
            return view;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/logging/dumpsys/AndroidRootResolver$Companion;", "", "()V", "GET_DEFAULT_IMPL", "", "GET_GLOBAL_INSTANCE", "TAG", "VIEWS_FIELD", "WINDOW_MANAGER_GLOBAL_CLAZZ", "WINDOW_MANAGER_IMPL_CLAZZ", "WINDOW_PARAMS_FIELD", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

