/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenCache;
import com.facebook.CurrentAccessTokenExpirationBroadcastReceiver;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0005!\"#$%B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001c\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\f\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/AccessTokenManager;", "", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "accessTokenCache", "Lcom/facebook/AccessTokenCache;", "(Landroidx/localbroadcastmanager/content/LocalBroadcastManager;Lcom/facebook/AccessTokenCache;)V", "value", "Lcom/facebook/AccessToken;", "currentAccessToken", "getCurrentAccessToken", "()Lcom/facebook/AccessToken;", "setCurrentAccessToken", "(Lcom/facebook/AccessToken;)V", "currentAccessTokenField", "lastAttemptedTokenExtendDate", "Ljava/util/Date;", "tokenRefreshInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentAccessTokenChanged", "", "extendAccessTokenIfNeeded", "loadCurrentAccessToken", "", "refreshCurrentAccessToken", "callback", "Lcom/facebook/AccessToken$AccessTokenRefreshCallback;", "refreshCurrentAccessTokenImpl", "sendCurrentAccessTokenChangedBroadcastIntent", "oldAccessToken", "saveToCache", "setTokenExpirationBroadcastAlarm", "shouldExtendAccessToken", "Companion", "FacebookRefreshTokenInfo", "InstagramRefreshTokenInfo", "RefreshResult", "RefreshTokenInfo", "facebook-core_release"})
public final class AccessTokenManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalBroadcastManager localBroadcastManager;
    @NotNull
    private final AccessTokenCache accessTokenCache;
    @Nullable
    private AccessToken currentAccessTokenField;
    @NotNull
    private final AtomicBoolean tokenRefreshInProgress;
    @NotNull
    private Date lastAttemptedTokenExtendDate;
    @NotNull
    public static final String TAG = "AccessTokenManager";
    @NotNull
    public static final String ACTION_CURRENT_ACCESS_TOKEN_CHANGED = "com.facebook.sdk.ACTION_CURRENT_ACCESS_TOKEN_CHANGED";
    @NotNull
    public static final String EXTRA_OLD_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_OLD_ACCESS_TOKEN";
    @NotNull
    public static final String EXTRA_NEW_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_NEW_ACCESS_TOKEN";
    @NotNull
    public static final String SHARED_PREFERENCES_NAME = "com.facebook.AccessTokenManager.SharedPreferences";
    private static final int TOKEN_EXTEND_THRESHOLD_SECONDS = 86400;
    private static final int TOKEN_EXTEND_RETRY_SECONDS = 3600;
    @NotNull
    private static final String ME_PERMISSIONS_GRAPH_PATH = "me/permissions";
    @Nullable
    private static AccessTokenManager instanceField;

    public AccessTokenManager(@NotNull LocalBroadcastManager localBroadcastManager, @NotNull AccessTokenCache accessTokenCache) {
        Intrinsics.checkNotNullParameter((Object)localBroadcastManager, (String)"localBroadcastManager");
        Intrinsics.checkNotNullParameter((Object)accessTokenCache, (String)"accessTokenCache");
        this.localBroadcastManager = localBroadcastManager;
        this.accessTokenCache = accessTokenCache;
        this.tokenRefreshInProgress = new AtomicBoolean(false);
        this.lastAttemptedTokenExtendDate = new Date(0L);
    }

    @Nullable
    public final AccessToken getCurrentAccessToken() {
        return this.currentAccessTokenField;
    }

    public final void setCurrentAccessToken(@Nullable AccessToken value) {
        this.setCurrentAccessToken(value, true);
    }

    public final boolean loadCurrentAccessToken() {
        AccessToken accessToken = this.accessTokenCache.load();
        if (accessToken != null) {
            this.setCurrentAccessToken(accessToken, false);
            return true;
        }
        return false;
    }

    public final void currentAccessTokenChanged() {
        this.sendCurrentAccessTokenChangedBroadcastIntent(this.getCurrentAccessToken(), this.getCurrentAccessToken());
    }

    private final void setCurrentAccessToken(AccessToken currentAccessToken, boolean saveToCache) {
        AccessToken oldAccessToken = this.currentAccessTokenField;
        this.currentAccessTokenField = currentAccessToken;
        this.tokenRefreshInProgress.set(false);
        this.lastAttemptedTokenExtendDate = new Date(0L);
        if (saveToCache) {
            if (currentAccessToken != null) {
                this.accessTokenCache.save(currentAccessToken);
            } else {
                this.accessTokenCache.clear();
                Utility.clearFacebookCookies(FacebookSdk.INSTANCE.getApplicationContext());
            }
        }
        if (!Utility.areObjectsEqual(oldAccessToken, currentAccessToken)) {
            this.sendCurrentAccessTokenChangedBroadcastIntent(oldAccessToken, currentAccessToken);
            this.setTokenExpirationBroadcastAlarm();
        }
    }

    private final void sendCurrentAccessTokenChangedBroadcastIntent(AccessToken oldAccessToken, AccessToken currentAccessToken) {
        Intent intent = new Intent(FacebookSdk.INSTANCE.getApplicationContext(), CurrentAccessTokenExpirationBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        intent.putExtra(EXTRA_OLD_ACCESS_TOKEN, (Parcelable)oldAccessToken);
        intent.putExtra(EXTRA_NEW_ACCESS_TOKEN, (Parcelable)currentAccessToken);
        this.localBroadcastManager.sendBroadcast(intent);
    }

    private final void setTokenExpirationBroadcastAlarm() {
        AccessToken accessToken;
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        AccessToken accessToken2 = AccessToken.Companion.getCurrentAccessToken();
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (!AccessToken.Companion.isCurrentAccessTokenActive() || ((accessToken = accessToken2) == null ? null : accessToken.getExpires()) == null || alarmManager == null) {
            return;
        }
        Intent intent = new Intent(context, CurrentAccessTokenExpirationBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        PendingIntent alarmIntent = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        try {
            alarmManager.set(1, accessToken2.getExpires().getTime(), alarmIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void extendAccessTokenIfNeeded() {
        if (!this.shouldExtendAccessToken()) {
            return;
        }
        this.refreshCurrentAccessToken(null);
    }

    private final boolean shouldExtendAccessToken() {
        AccessToken accessToken = this.getCurrentAccessToken();
        if (accessToken == null) {
            return false;
        }
        AccessToken currentAccessToken = accessToken;
        long now = new Date().getTime();
        return currentAccessToken.getSource().canExtendToken() && now - this.lastAttemptedTokenExtendDate.getTime() > 3600000L && now - currentAccessToken.getLastRefresh().getTime() > 86400000L;
    }

    public final void refreshCurrentAccessToken(@Nullable AccessToken.AccessTokenRefreshCallback callback) {
        if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
            this.refreshCurrentAccessTokenImpl(callback);
        } else {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(() -> AccessTokenManager.refreshCurrentAccessToken$lambda-0(this, callback));
        }
    }

    private final void refreshCurrentAccessTokenImpl(AccessToken.AccessTokenRefreshCallback callback) {
        AccessToken accessToken = this.getCurrentAccessToken();
        if (accessToken == null) {
            AccessToken.AccessTokenRefreshCallback accessTokenRefreshCallback = callback;
            if (accessTokenRefreshCallback != null) {
                accessTokenRefreshCallback.OnTokenRefreshFailed(new FacebookException("No current access token to refresh"));
            }
            return;
        }
        if (!this.tokenRefreshInProgress.compareAndSet(false, true)) {
            AccessToken.AccessTokenRefreshCallback accessTokenRefreshCallback = callback;
            if (accessTokenRefreshCallback != null) {
                accessTokenRefreshCallback.OnTokenRefreshFailed(new FacebookException("Refresh already in progress"));
            }
            return;
        }
        this.lastAttemptedTokenExtendDate = new Date();
        Set permissions = new HashSet();
        Set declinedPermissions = new HashSet();
        Set expiredPermissions = new HashSet();
        AtomicBoolean permissionsCallSucceeded = new AtomicBoolean(false);
        RefreshResult refreshResult = new RefreshResult();
        GraphRequest[] graphRequestArray = new GraphRequest[]{AccessTokenManager.Companion.createGrantedPermissionsRequest(accessToken, arg_0 -> AccessTokenManager.refreshCurrentAccessTokenImpl$lambda-1(permissionsCallSucceeded, permissions, declinedPermissions, expiredPermissions, arg_0)), AccessTokenManager.Companion.createExtendAccessTokenRequest(accessToken, arg_0 -> AccessTokenManager.refreshCurrentAccessTokenImpl$lambda-2(refreshResult, arg_0))};
        GraphRequestBatch batch = new GraphRequestBatch(graphRequestArray);
        batch.addCallback(arg_0 -> AccessTokenManager.refreshCurrentAccessTokenImpl$lambda-3(refreshResult, accessToken, callback, permissionsCallSucceeded, permissions, declinedPermissions, expiredPermissions, this, arg_0));
        batch.executeAsync();
    }

    private static final void refreshCurrentAccessToken$lambda-0(AccessTokenManager this$0, AccessToken.AccessTokenRefreshCallback $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.refreshCurrentAccessTokenImpl($callback);
    }

    private static final void refreshCurrentAccessTokenImpl$lambda-1(AtomicBoolean $permissionsCallSucceeded, Set $permissions, Set $declinedPermissions, Set $expiredPermissions, GraphResponse response) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)$permissionsCallSucceeded, (String)"$permissionsCallSucceeded");
            Intrinsics.checkNotNullParameter((Object)$permissions, (String)"$permissions");
            Intrinsics.checkNotNullParameter((Object)$declinedPermissions, (String)"$declinedPermissions");
            Intrinsics.checkNotNullParameter((Object)$expiredPermissions, (String)"$expiredPermissions");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            JSONObject jSONObject = response.getJsonObject();
            if (jSONObject == null) {
                return;
            }
            JSONObject result = jSONObject;
            JSONArray jSONArray = result.optJSONArray("data");
            if (jSONArray == null) {
                return;
            }
            JSONArray permissionsArray = jSONArray;
            $permissionsCallSucceeded.set(true);
            int n = 0;
            int n2 = permissionsArray.length();
            if (n >= n2) break block16;
            do {
                int i;
                JSONObject jSONObject2;
                if ((jSONObject2 = permissionsArray.optJSONObject(i = n++)) == null) continue;
                JSONObject permissionEntry = jSONObject2;
                String permission = permissionEntry.optString("permission");
                String status = permissionEntry.optString("status");
                if (Utility.isNullOrEmpty(permission)) continue;
                if (Utility.isNullOrEmpty(status)) continue;
                Object object = status;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"status");
                Object object2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"US");
                boolean bl = false;
                String string = object;
                boolean bl2 = false;
                String string2 = string.toLowerCase((Locale)object2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
                status = string2;
                object2 = status;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"status");
                switch (object2) {
                    case "granted": {
                        $permissions.add(permission);
                        break;
                    }
                    case "declined": {
                        $declinedPermissions.add(permission);
                        break;
                    }
                    case "expired": {
                        $expiredPermissions.add(permission);
                        break;
                    }
                    default: {
                        Log.w((String)TAG, (String)Intrinsics.stringPlus((String)"Unexpected status: ", (Object)status));
                    }
                }
            } while (n < n2);
        }
    }

    private static final void refreshCurrentAccessTokenImpl$lambda-2(RefreshResult $refreshResult, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$refreshResult, (String)"$refreshResult");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        JSONObject jSONObject = response.getJsonObject();
        if (jSONObject == null) {
            return;
        }
        JSONObject data = jSONObject;
        $refreshResult.setAccessToken(data.optString("access_token"));
        $refreshResult.setExpiresAt(data.optInt("expires_at"));
        $refreshResult.setExpiresIn(data.optInt("expires_in"));
        $refreshResult.setDataAccessExpirationTime(data.optLong("data_access_expiration_time"));
        $refreshResult.setGraphDomain(data.optString("graph_domain", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshCurrentAccessTokenImpl$lambda-3(RefreshResult $refreshResult, AccessToken $accessToken, AccessToken.AccessTokenRefreshCallback $callback, AtomicBoolean $permissionsCallSucceeded, Set $permissions, Set $declinedPermissions, Set $expiredPermissions, AccessTokenManager this$0, GraphRequestBatch it) {
        String returnGraphDomain;
        Long returnDataAccessExpirationTime;
        String returnAccessToken;
        AccessToken newAccessToken;
        block14: {
            Object object;
            int returnExpiresAt;
            block13: {
                Intrinsics.checkNotNullParameter((Object)$refreshResult, (String)"$refreshResult");
                Intrinsics.checkNotNullParameter((Object)$permissionsCallSucceeded, (String)"$permissionsCallSucceeded");
                Intrinsics.checkNotNullParameter((Object)$permissions, (String)"$permissions");
                Intrinsics.checkNotNullParameter((Object)$declinedPermissions, (String)"$declinedPermissions");
                Intrinsics.checkNotNullParameter((Object)$expiredPermissions, (String)"$expiredPermissions");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                newAccessToken = null;
                returnAccessToken = $refreshResult.getAccessToken();
                returnExpiresAt = $refreshResult.getExpiresAt();
                returnDataAccessExpirationTime = $refreshResult.getDataAccessExpirationTime();
                returnGraphDomain = $refreshResult.getGraphDomain();
                try {
                    if (Companion.getInstance().getCurrentAccessToken() != null && ((object = Companion.getInstance().getCurrentAccessToken()) == null ? null : ((AccessToken)object).getUserId()) == $accessToken.getUserId()) break block13;
                    object = $callback;
                    if (object != null) {
                        object.OnTokenRefreshFailed(new FacebookException("No current access token to refresh"));
                    }
                    this$0.tokenRefreshInProgress.set(false);
                    if ($callback != null) {
                        // empty if block
                    }
                    return;
                }
                catch (Throwable throwable) {
                    this$0.tokenRefreshInProgress.set(false);
                    if ($callback != null && newAccessToken != null) {
                        $callback.OnTokenRefreshed(newAccessToken);
                    }
                    throw throwable;
                }
            }
            if ($permissionsCallSucceeded.get() || returnAccessToken != null || returnExpiresAt != 0) break block14;
            object = $callback;
            if (object != null) {
                object.OnTokenRefreshFailed(new FacebookException("Failed to refresh access token"));
            }
            this$0.tokenRefreshInProgress.set(false);
            if ($callback != null) {
                // empty if block
            }
            return;
        }
        Date expirationTime = $accessToken.getExpires();
        if ($refreshResult.getExpiresAt() != 0) {
            expirationTime = new Date((long)$refreshResult.getExpiresAt() * 1000L);
        } else if ($refreshResult.getExpiresIn() != 0) {
            long now = new Date().getTime();
            expirationTime = new Date((long)$refreshResult.getExpiresIn() * 1000L + now);
        }
        String string = returnAccessToken;
        String string2 = string == null ? $accessToken.getToken() : string;
        string = returnGraphDomain;
        newAccessToken = new AccessToken(string2, $accessToken.getApplicationId(), $accessToken.getUserId(), (Collection<String>)($permissionsCallSucceeded.get() ? $permissions : $accessToken.getPermissions()), (Collection<String>)($permissionsCallSucceeded.get() ? $declinedPermissions : $accessToken.getDeclinedPermissions()), (Collection<String>)($permissionsCallSucceeded.get() ? $expiredPermissions : $accessToken.getExpiredPermissions()), $accessToken.getSource(), expirationTime, new Date(), returnDataAccessExpirationTime != null ? new Date(returnDataAccessExpirationTime * 1000L) : $accessToken.getDataAccessExpirationTime(), string == null ? $accessToken.getGraphDomain() : string);
        Companion.getInstance().setCurrentAccessToken(newAccessToken);
        this$0.tokenRefreshInProgress.set(false);
        if ($callback != null) {
            $callback.OnTokenRefreshed(newAccessToken);
        }
    }

    @JvmStatic
    @NotNull
    public static final AccessTokenManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "", "grantType", "", "getGrantType", "()Ljava/lang/String;", "graphPath", "getGraphPath", "facebook-core_release"})
    public static interface RefreshTokenInfo {
        @NotNull
        public String getGraphPath();

        @NotNull
        public String getGrantType();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/facebook/AccessTokenManager$FacebookRefreshTokenInfo;", "Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "()V", "grantType", "", "getGrantType", "()Ljava/lang/String;", "graphPath", "getGraphPath", "facebook-core_release"})
    public static final class FacebookRefreshTokenInfo
    implements RefreshTokenInfo {
        @NotNull
        private final String graphPath;
        @NotNull
        private final String grantType;

        public FacebookRefreshTokenInfo() {
            this.graphPath = "oauth/access_token";
            this.grantType = "fb_extend_sso_token";
        }

        @Override
        @NotNull
        public String getGraphPath() {
            return this.graphPath;
        }

        @Override
        @NotNull
        public String getGrantType() {
            return this.grantType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/facebook/AccessTokenManager$InstagramRefreshTokenInfo;", "Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "()V", "grantType", "", "getGrantType", "()Ljava/lang/String;", "graphPath", "getGraphPath", "facebook-core_release"})
    public static final class InstagramRefreshTokenInfo
    implements RefreshTokenInfo {
        @NotNull
        private final String graphPath;
        @NotNull
        private final String grantType;

        public InstagramRefreshTokenInfo() {
            this.graphPath = "refresh_access_token";
            this.grantType = "ig_refresh_token";
        }

        @Override
        @NotNull
        public String getGraphPath() {
            return this.graphPath;
        }

        @Override
        @NotNull
        public String getGrantType() {
            return this.grantType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/facebook/AccessTokenManager$RefreshResult;", "", "()V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "dataAccessExpirationTime", "", "getDataAccessExpirationTime", "()Ljava/lang/Long;", "setDataAccessExpirationTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "expiresAt", "", "getExpiresAt", "()I", "setExpiresAt", "(I)V", "expiresIn", "getExpiresIn", "setExpiresIn", "graphDomain", "getGraphDomain", "setGraphDomain", "facebook-core_release"})
    private static final class RefreshResult {
        @Nullable
        private String accessToken;
        private int expiresAt;
        private int expiresIn;
        @Nullable
        private Long dataAccessExpirationTime;
        @Nullable
        private String graphDomain;

        @Nullable
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            this.accessToken = string;
        }

        public final int getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(int n) {
            this.expiresAt = n;
        }

        public final int getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(int n) {
            this.expiresIn = n;
        }

        @Nullable
        public final Long getDataAccessExpirationTime() {
            return this.dataAccessExpirationTime;
        }

        public final void setDataAccessExpirationTime(@Nullable Long l) {
            this.dataAccessExpirationTime = l;
        }

        @Nullable
        public final String getGraphDomain() {
            return this.graphDomain;
        }

        public final void setGraphDomain(@Nullable String string) {
            this.graphDomain = string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/AccessTokenManager$Companion;", "", "()V", "ACTION_CURRENT_ACCESS_TOKEN_CHANGED", "", "EXTRA_NEW_ACCESS_TOKEN", "EXTRA_OLD_ACCESS_TOKEN", "ME_PERMISSIONS_GRAPH_PATH", "SHARED_PREFERENCES_NAME", "TAG", "TOKEN_EXTEND_RETRY_SECONDS", "", "TOKEN_EXTEND_THRESHOLD_SECONDS", "instanceField", "Lcom/facebook/AccessTokenManager;", "createExtendAccessTokenRequest", "Lcom/facebook/GraphRequest;", "accessToken", "Lcom/facebook/AccessToken;", "callback", "Lcom/facebook/GraphRequest$Callback;", "createGrantedPermissionsRequest", "getInstance", "getRefreshTokenInfoForToken", "Lcom/facebook/AccessTokenManager$RefreshTokenInfo;", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final AccessTokenManager getInstance() {
            AccessTokenManager instance = instanceField;
            if (instance == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    AccessTokenManager accessTokenManager;
                    boolean bl3 = false;
                    AccessTokenManager instance2 = instanceField;
                    if (instance2 == null) {
                        Context applicationContext = FacebookSdk.INSTANCE.getApplicationContext();
                        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
                        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(applicationContext)");
                        LocalBroadcastManager localBroadcastManager2 = localBroadcastManager;
                        AccessTokenCache accessTokenCache = new AccessTokenCache();
                        AccessTokenManager newInstance = new AccessTokenManager(localBroadcastManager2, accessTokenCache);
                        instanceField = newInstance;
                        accessTokenManager = newInstance;
                    } else {
                        accessTokenManager = instance2;
                    }
                    AccessTokenManager accessTokenManager2 = accessTokenManager;
                    return accessTokenManager2;
                }
            }
            return instance;
        }

        private final GraphRequest createGrantedPermissionsRequest(AccessToken accessToken, GraphRequest.Callback callback) {
            Bundle parameters = new Bundle();
            parameters.putString("fields", "permission,status");
            GraphRequest request = GraphRequest.Companion.newGraphPathRequest(accessToken, AccessTokenManager.ME_PERMISSIONS_GRAPH_PATH, callback);
            request.setParameters(parameters);
            request.setHttpMethod(HttpMethod.GET);
            return request;
        }

        private final RefreshTokenInfo getRefreshTokenInfoForToken(AccessToken accessToken) {
            String tokenGraphDomain;
            String string = accessToken.getGraphDomain();
            string = tokenGraphDomain = string == null ? "facebook" : string;
            return Intrinsics.areEqual((Object)string, (Object)"instagram") ? (RefreshTokenInfo)new InstagramRefreshTokenInfo() : (RefreshTokenInfo)new FacebookRefreshTokenInfo();
        }

        private final GraphRequest createExtendAccessTokenRequest(AccessToken accessToken, GraphRequest.Callback callback) {
            RefreshTokenInfo refreshInfo = this.getRefreshTokenInfoForToken(accessToken);
            Bundle parameters = new Bundle();
            parameters.putString("grant_type", refreshInfo.getGrantType());
            parameters.putString("client_id", accessToken.getApplicationId());
            parameters.putString("fields", "access_token,expires_at,expires_in,data_access_expiration_time,graph_domain");
            GraphRequest request = GraphRequest.Companion.newGraphPathRequest(accessToken, refreshInfo.getGraphPath(), callback);
            request.setParameters(parameters);
            request.setHttpMethod(HttpMethod.GET);
            return request;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

