/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.aam.MetadataIndexer;
import com.facebook.appevents.codeless.CodelessManager;
import com.facebook.appevents.iap.InAppPurchaseManager;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SessionLogger;
import com.facebook.appevents.suggestedevents.SuggestedEventsManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\rH\u0007J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\b\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020$H\u0007J\u0012\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\rH\u0007J\u001a\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/facebook/appevents/internal/ActivityLifecycleTracker;", "", "()V", "INCORRECT_IMPL_WARNING", "", "INTERRUPTION_THRESHOLD_MILLISECONDS", "", "TAG", "activityReferences", "", "appId", "currActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "currentActivityAppearTime", "currentFuture", "Ljava/util/concurrent/ScheduledFuture;", "currentFutureLock", "currentSession", "Lcom/facebook/appevents/internal/SessionInfo;", "foregroundActivityCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "sessionTimeoutInSeconds", "getSessionTimeoutInSeconds", "()I", "singleThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "tracking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cancelCurrentTask", "", "getCurrentActivity", "getCurrentSessionGuid", "Ljava/util/UUID;", "isInBackground", "", "isTracking", "onActivityCreated", "activity", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "startTracking", "application", "Landroid/app/Application;", "facebook-core_release"})
public final class ActivityLifecycleTracker {
    @NotNull
    public static final ActivityLifecycleTracker INSTANCE = new ActivityLifecycleTracker();
    @NotNull
    private static final String TAG;
    @NotNull
    private static final String INCORRECT_IMPL_WARNING = "Unexpected activity pause without a matching activity resume. Logging data may be incorrect. Make sure you call activateApp from your Application's onCreate method";
    private static final long INTERRUPTION_THRESHOLD_MILLISECONDS = 1000L;
    private static final ScheduledExecutorService singleThreadExecutor;
    @Nullable
    private static volatile ScheduledFuture<?> currentFuture;
    @NotNull
    private static final Object currentFutureLock;
    @NotNull
    private static final AtomicInteger foregroundActivityCount;
    @Nullable
    private static volatile SessionInfo currentSession;
    @NotNull
    private static final AtomicBoolean tracking;
    @Nullable
    private static String appId;
    private static long currentActivityAppearTime;
    private static int activityReferences;
    @Nullable
    private static WeakReference<Activity> currActivity;

    private ActivityLifecycleTracker() {
    }

    @JvmStatic
    public static final void startTracking(@NotNull Application application, @Nullable String appId) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (!tracking.compareAndSet(false, true)) {
            return;
        }
        FeatureManager.checkFeature(FeatureManager.Feature.CodelessEvents, ActivityLifecycleTracker::startTracking$lambda-0);
        ActivityLifecycleTracker.appId = appId;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivityCreated");
                AppEventUtility.INSTANCE.assertIsMainThread();
                ActivityLifecycleTracker.onActivityCreated(activity);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                ActivityLifecycleTracker activityLifecycleTracker = ActivityLifecycleTracker.INSTANCE;
                int n = ActivityLifecycleTracker.access$getActivityReferences$p();
                ActivityLifecycleTracker.access$setActivityReferences$p(n + 1);
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivityStarted");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivityResumed");
                AppEventUtility.INSTANCE.assertIsMainThread();
                ActivityLifecycleTracker.onActivityResumed(activity);
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivityPaused");
                AppEventUtility.INSTANCE.assertIsMainThread();
                ActivityLifecycleTracker.access$onActivityPaused(ActivityLifecycleTracker.INSTANCE, activity);
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivityStopped");
                AppEventsLogger.Companion.onContextStop();
                ActivityLifecycleTracker activityLifecycleTracker = ActivityLifecycleTracker.INSTANCE;
                int n = ActivityLifecycleTracker.access$getActivityReferences$p();
                ActivityLifecycleTracker.access$setActivityReferences$p(n + -1);
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivitySaveInstanceState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, ActivityLifecycleTracker.access$getTAG$p(), "onActivityDestroyed");
                ActivityLifecycleTracker.access$onActivityDestroyed(ActivityLifecycleTracker.INSTANCE, activity);
            }
        });
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isInBackground() {
        return activityReferences == 0;
    }

    @JvmStatic
    public static final boolean isTracking() {
        return tracking.get();
    }

    @JvmStatic
    @Nullable
    public static final UUID getCurrentSessionGuid() {
        SessionInfo sessionInfo;
        return currentSession != null ? ((sessionInfo = currentSession) == null ? null : sessionInfo.getSessionId()) : null;
    }

    @JvmStatic
    public static final void onActivityCreated(@Nullable Activity activity) {
        singleThreadExecutor.execute(ActivityLifecycleTracker::onActivityCreated$lambda-1);
    }

    @JvmStatic
    public static final void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        currActivity = new WeakReference<Activity>(activity);
        foregroundActivityCount.incrementAndGet();
        INSTANCE.cancelCurrentTask();
        long currentTime = System.currentTimeMillis();
        currentActivityAppearTime = currentTime;
        String activityName = Utility.getActivityName((Context)activity);
        CodelessManager.onActivityResumed(activity);
        MetadataIndexer.onActivityResumed(activity);
        SuggestedEventsManager.trackActivity(activity);
        InAppPurchaseManager.INSTANCE.startTracking();
        Context appContext = activity.getApplicationContext();
        Runnable handleActivityResume = () -> ActivityLifecycleTracker.onActivityResumed$lambda-2(currentTime, activityName, appContext);
        singleThreadExecutor.execute(handleActivityResume);
    }

    private final void onActivityPaused(Activity activity) {
        int count = foregroundActivityCount.decrementAndGet();
        if (count < 0) {
            foregroundActivityCount.set(0);
            Log.w((String)TAG, (String)INCORRECT_IMPL_WARNING);
        }
        this.cancelCurrentTask();
        long currentTime = System.currentTimeMillis();
        String activityName = Utility.getActivityName((Context)activity);
        CodelessManager.onActivityPaused(activity);
        Runnable handleActivityPaused = () -> ActivityLifecycleTracker.onActivityPaused$lambda-6(currentTime, activityName);
        singleThreadExecutor.execute(handleActivityPaused);
    }

    private final void onActivityDestroyed(Activity activity) {
        CodelessManager.onActivityDestroyed(activity);
    }

    private final int getSessionTimeoutInSeconds() {
        FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.INSTANCE.getApplicationId());
        if (fetchedAppSettings == null) {
            return Constants.INSTANCE.getDefaultAppEventsSessionTimeoutInSeconds();
        }
        FetchedAppSettings settings = fetchedAppSettings;
        return settings.getSessionTimeoutInSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelCurrentTask() {
        Object object = currentFutureLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            ScheduledFuture<?> scheduledFuture;
            boolean bl3 = false;
            if (currentFuture != null && (scheduledFuture = currentFuture) != null) {
                scheduledFuture.cancel(false);
            }
            currentFuture = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    @Nullable
    public static final Activity getCurrentActivity() {
        WeakReference<Activity> weakReference;
        return currActivity != null ? ((weakReference = currActivity) == null ? null : (Activity)weakReference.get()) : null;
    }

    private static final void startTracking$lambda-0(boolean enabled) {
        if (enabled) {
            CodelessManager.INSTANCE.enable();
        } else {
            CodelessManager.INSTANCE.disable();
        }
    }

    private static final void onActivityCreated$lambda-1() {
        if (currentSession == null) {
            currentSession = SessionInfo.Companion.getStoredSessionInfo();
        }
    }

    private static final void onActivityResumed$lambda-2(long $currentTime, String $activityName, Context $appContext) {
        Long lastEventTime;
        Intrinsics.checkNotNullParameter((Object)$activityName, (String)"$activityName");
        SessionInfo sessionInfo = currentSession;
        Long l = lastEventTime = sessionInfo == null ? null : sessionInfo.getSessionLastEventTime();
        if (currentSession == null) {
            currentSession = new SessionInfo($currentTime, null, null, 4, null);
            Intrinsics.checkNotNullExpressionValue((Object)$appContext, (String)"appContext");
            SessionLogger.logActivateApp($activityName, null, appId, $appContext);
        } else if (lastEventTime != null) {
            SessionInfo sessionInfo2;
            long suspendTime = $currentTime - lastEventTime;
            if (suspendTime > (long)(INSTANCE.getSessionTimeoutInSeconds() * 1000)) {
                SessionLogger.logDeactivateApp($activityName, currentSession, appId);
                Intrinsics.checkNotNullExpressionValue((Object)$appContext, (String)"appContext");
                SessionLogger.logActivateApp($activityName, null, appId, $appContext);
                currentSession = new SessionInfo($currentTime, null, null, 4, null);
            } else if (suspendTime > 1000L && (sessionInfo2 = currentSession) != null) {
                sessionInfo2.incrementInterruptionCount();
            }
        }
        sessionInfo = currentSession;
        if (sessionInfo != null) {
            sessionInfo.setSessionLastEventTime($currentTime);
        }
        sessionInfo = currentSession;
        if (sessionInfo != null) {
            sessionInfo.writeSessionToDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onActivityPaused$lambda-6$lambda-4(long $currentTime, String $activityName) {
        Intrinsics.checkNotNullParameter((Object)$activityName, (String)"$activityName");
        if (currentSession == null) {
            currentSession = new SessionInfo($currentTime, null, null, 4, null);
        }
        if (foregroundActivityCount.get() <= 0) {
            SessionLogger.logDeactivateApp($activityName, currentSession, appId);
            SessionInfo.Companion.clearSavedSessionFromDisk();
            currentSession = null;
        }
        Object object = currentFutureLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            currentFuture = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onActivityPaused$lambda-6(long $currentTime, String $activityName) {
        long appearTime;
        SessionInfo sessionInfo;
        Intrinsics.checkNotNullParameter((Object)$activityName, (String)"$activityName");
        if (currentSession == null) {
            currentSession = new SessionInfo($currentTime, null, null, 4, null);
        }
        if ((sessionInfo = currentSession) != null) {
            sessionInfo.setSessionLastEventTime($currentTime);
        }
        if (foregroundActivityCount.get() <= 0) {
            Runnable task = () -> ActivityLifecycleTracker.onActivityPaused$lambda-6$lambda-4($currentTime, $activityName);
            Object object = currentFutureLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                currentFuture = singleThreadExecutor.schedule(task, (long)INSTANCE.getSessionTimeoutInSeconds(), TimeUnit.SECONDS);
                Unit unit = Unit.INSTANCE;
            }
        }
        long timeSpentOnActivityInSeconds = (appearTime = currentActivityAppearTime) > 0L ? ($currentTime - appearTime) / (long)1000 : 0L;
        AutomaticAnalyticsLogger.logActivityTimeSpentEvent($activityName, timeSpentOnActivityInSeconds);
        SessionInfo sessionInfo2 = currentSession;
        if (sessionInfo2 != null) {
            sessionInfo2.writeSessionToDisk();
        }
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    public static final /* synthetic */ int access$getActivityReferences$p() {
        return activityReferences;
    }

    public static final /* synthetic */ void access$setActivityReferences$p(int n) {
        activityReferences = n;
    }

    public static final /* synthetic */ void access$onActivityPaused(ActivityLifecycleTracker $this, Activity activity) {
        $this.onActivityPaused(activity);
    }

    public static final /* synthetic */ void access$onActivityDestroyed(ActivityLifecycleTracker $this, Activity activity) {
        $this.onActivityDestroyed(activity);
    }

    static {
        String string = ActivityLifecycleTracker.class.getCanonicalName();
        TAG = string == null ? "com.facebook.appevents.internal.ActivityLifecycleTracker" : string;
        singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
        currentFutureLock = new Object();
        foregroundActivityCount = new AtomicInteger(0);
        tracking = new AtomicBoolean(false);
    }
}

