/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.facebook.FacebookContentProvider;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007J\b\u0010\u000e\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0007J$\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\n\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001bH\u0007J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\bH\u0002J \u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/facebook/internal/NativeAppCallAttachmentStore;", "", "()V", "ATTACHMENTS_DIR_NAME", "", "TAG", "kotlin.jvm.PlatformType", "attachmentsDirectory", "Ljava/io/File;", "addAttachments", "", "attachments", "", "Lcom/facebook/internal/NativeAppCallAttachmentStore$Attachment;", "cleanupAllAttachments", "cleanupAttachmentsForCall", "callId", "Ljava/util/UUID;", "createAttachment", "attachmentBitmap", "Landroid/graphics/Bitmap;", "attachmentUri", "Landroid/net/Uri;", "ensureAttachmentsDirectoryExists", "getAttachmentFile", "attachmentName", "createDirs", "", "getAttachmentsDirectory", "getAttachmentsDirectoryForCall", "create", "openAttachment", "processAttachmentBitmap", "bitmap", "outputFile", "processAttachmentFile", "imageUri", "isContentUri", "Attachment", "facebook-core_release"})
public final class NativeAppCallAttachmentStore {
    @NotNull
    public static final NativeAppCallAttachmentStore INSTANCE = new NativeAppCallAttachmentStore();
    private static final String TAG = NativeAppCallAttachmentStore.class.getName();
    @NotNull
    public static final String ATTACHMENTS_DIR_NAME = "com.facebook.NativeAppCallAttachmentStore.files";
    @Nullable
    private static File attachmentsDirectory;

    private NativeAppCallAttachmentStore() {
    }

    @JvmStatic
    @NotNull
    public static final Attachment createAttachment(@NotNull UUID callId, @NotNull Bitmap attachmentBitmap) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Intrinsics.checkNotNullParameter((Object)attachmentBitmap, (String)"attachmentBitmap");
        return new Attachment(callId, attachmentBitmap, null);
    }

    @JvmStatic
    @NotNull
    public static final Attachment createAttachment(@NotNull UUID callId, @NotNull Uri attachmentUri) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Intrinsics.checkNotNullParameter((Object)attachmentUri, (String)"attachmentUri");
        return new Attachment(callId, null, attachmentUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processAttachmentBitmap(Bitmap bitmap, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        }
        finally {
            Utility.closeQuietly(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processAttachmentFile(Uri imageUri, boolean isContentUri, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            InputStream inputStream = !isContentUri ? (InputStream)new FileInputStream(imageUri.getPath()) : FacebookSdk.INSTANCE.getApplicationContext().getContentResolver().openInputStream(imageUri);
            Utility.copyAndCloseInputStream(inputStream, outputStream);
        }
        finally {
            Utility.closeQuietly(outputStream);
        }
    }

    @JvmStatic
    public static final void addAttachments(@Nullable Collection<Attachment> attachments) throws FacebookException {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        if (attachmentsDirectory == null) {
            INSTANCE.cleanupAllAttachments();
        }
        INSTANCE.ensureAttachmentsDirectoryExists();
        List filesToCleanup = new ArrayList();
        try {
            for (Attachment attachment : attachments) {
                if (!attachment.getShouldCreateFile()) continue;
                File file = NativeAppCallAttachmentStore.getAttachmentFile(attachment.getCallId(), attachment.getAttachmentName(), true);
                if (file == null) continue;
                filesToCleanup.add(file);
                if (attachment.getBitmap() != null) {
                    INSTANCE.processAttachmentBitmap(attachment.getBitmap(), file);
                    continue;
                }
                if (attachment.getOriginalUri() == null) continue;
                INSTANCE.processAttachmentFile(attachment.getOriginalUri(), attachment.isContentUri(), file);
            }
        }
        catch (IOException exception) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Got unexpected exception:", (Object)exception));
            for (File file : filesToCleanup) {
                try {
                    File file2 = file;
                    if (file2 == null) continue;
                    file2.delete();
                }
                catch (Exception exception2) {}
            }
            throw new FacebookException(exception);
        }
    }

    @JvmStatic
    public static final void cleanupAttachmentsForCall(@NotNull UUID callId) {
        File dir;
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        File file = dir = NativeAppCallAttachmentStore.getAttachmentsDirectoryForCall(callId, false);
        if (file != null) {
            FilesKt.deleteRecursively((File)file);
        }
    }

    @JvmStatic
    @Nullable
    public static final File openAttachment(@Nullable UUID callId, @Nullable String attachmentName) throws FileNotFoundException {
        File file;
        if (Utility.isNullOrEmpty(attachmentName) || callId == null) {
            throw new FileNotFoundException();
        }
        try {
            file = NativeAppCallAttachmentStore.getAttachmentFile(callId, attachmentName, false);
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
        return file;
    }

    @JvmStatic
    @Nullable
    public static final synchronized File getAttachmentsDirectory() {
        if (attachmentsDirectory == null) {
            attachmentsDirectory = new File(FacebookSdk.INSTANCE.getApplicationContext().getCacheDir(), ATTACHMENTS_DIR_NAME);
        }
        return attachmentsDirectory;
    }

    @JvmStatic
    @Nullable
    public static final File ensureAttachmentsDirectoryExists() {
        File dir = INSTANCE.getAttachmentsDirectory();
        File file = dir;
        if (file != null) {
            file.mkdirs();
        }
        return dir;
    }

    @JvmStatic
    @Nullable
    public static final File getAttachmentsDirectoryForCall(@NotNull UUID callId, boolean create) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        if (attachmentsDirectory == null) {
            return null;
        }
        File dir = new File(attachmentsDirectory, callId.toString());
        if (create && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    @JvmStatic
    @Nullable
    public static final File getAttachmentFile(@NotNull UUID callId, @Nullable String attachmentName, boolean createDirs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        File file = NativeAppCallAttachmentStore.getAttachmentsDirectoryForCall(callId, createDirs);
        if (file == null) {
            return null;
        }
        File dir = file;
        try {
            file = new File(dir, URLEncoder.encode(attachmentName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            file = null;
        }
        return file;
    }

    @JvmStatic
    public static final void cleanupAllAttachments() {
        File file = INSTANCE.getAttachmentsDirectory();
        if (file != null) {
            FilesKt.deleteRecursively((File)file);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0015\"\u0004\b\u001c\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/facebook/internal/NativeAppCallAttachmentStore$Attachment;", "", "callId", "Ljava/util/UUID;", "bitmap", "Landroid/graphics/Bitmap;", "originalUri", "Landroid/net/Uri;", "(Ljava/util/UUID;Landroid/graphics/Bitmap;Landroid/net/Uri;)V", "attachmentName", "", "getAttachmentName", "()Ljava/lang/String;", "attachmentUrl", "getAttachmentUrl", "getBitmap", "()Landroid/graphics/Bitmap;", "getCallId", "()Ljava/util/UUID;", "isContentUri", "", "()Z", "setContentUri", "(Z)V", "getOriginalUri", "()Landroid/net/Uri;", "shouldCreateFile", "getShouldCreateFile", "setShouldCreateFile", "facebook-core_release"})
    public static final class Attachment {
        @NotNull
        private final UUID callId;
        @Nullable
        private final Bitmap bitmap;
        @Nullable
        private final Uri originalUri;
        @NotNull
        private final String attachmentUrl;
        @Nullable
        private final String attachmentName;
        private boolean isContentUri;
        private boolean shouldCreateFile;

        /*
         * WARNING - void declaration
         */
        public Attachment(@NotNull UUID callId, @Nullable Bitmap bitmap, @Nullable Uri originalUri) {
            Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
            this.callId = callId;
            this.bitmap = bitmap;
            this.originalUri = originalUri;
            if (this.originalUri != null) {
                String scheme = this.originalUri.getScheme();
                if (StringsKt.equals((String)"content", (String)scheme, (boolean)true)) {
                    void $this$_init__u24lambda_u2d0;
                    this.isContentUri = true;
                    String string = this.originalUri.getAuthority();
                    boolean bl = false;
                    boolean bl2 = false;
                    String string2 = string;
                    Attachment attachment = this;
                    boolean bl3 = false;
                    boolean bl4 = $this$_init__u24lambda_u2d0 != null && !StringsKt.startsWith$default((String)$this$_init__u24lambda_u2d0, (String)"media", (boolean)false, (int)2, null);
                    attachment.shouldCreateFile = bl4;
                } else if (StringsKt.equals((String)"file", (String)this.originalUri.getScheme(), (boolean)true)) {
                    this.shouldCreateFile = true;
                } else if (!Utility.isWebUri(this.originalUri)) {
                    throw new FacebookException(Intrinsics.stringPlus((String)"Unsupported scheme for media Uri : ", (Object)scheme));
                }
            } else if (this.bitmap != null) {
                this.shouldCreateFile = true;
            } else {
                throw new FacebookException("Cannot share media without a bitmap or Uri set");
            }
            this.attachmentName = !this.shouldCreateFile ? null : UUID.randomUUID().toString();
            this.attachmentUrl = !this.shouldCreateFile ? String.valueOf(this.originalUri) : FacebookContentProvider.Companion.getAttachmentUrl(FacebookSdk.INSTANCE.getApplicationId(), this.callId, this.attachmentName);
        }

        @NotNull
        public final UUID getCallId() {
            return this.callId;
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @Nullable
        public final Uri getOriginalUri() {
            return this.originalUri;
        }

        @NotNull
        public final String getAttachmentUrl() {
            return this.attachmentUrl;
        }

        @Nullable
        public final String getAttachmentName() {
            return this.attachmentName;
        }

        public final boolean isContentUri() {
            return this.isContentUri;
        }

        public final void setContentUri(boolean bl) {
            this.isContentUri = bl;
        }

        public final boolean getShouldCreateFile() {
            return this.shouldCreateFile;
        }

        public final void setShouldCreateFile(boolean bl) {
            this.shouldCreateFile = bl;
        }
    }
}

