/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.errorreport;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.errorreport.ErrorReportData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/internal/instrument/errorreport/ErrorReportHandler;", "", "()V", "MAX_ERROR_REPORT_NUM", "", "enable", "", "listErrorReportFiles", "", "Ljava/io/File;", "()[Ljava/io/File;", "save", "msg", "", "sendErrorReports", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ErrorReportHandler {
    @NotNull
    public static final ErrorReportHandler INSTANCE = new ErrorReportHandler();
    private static final int MAX_ERROR_REPORT_NUM = 1000;

    private ErrorReportHandler() {
    }

    @JvmStatic
    public static final void save(@Nullable String msg) {
        try {
            ErrorReportData errorReport = new ErrorReportData(msg);
            errorReport.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void enable() {
        if (FacebookSdk.INSTANCE.getAutoLogAppEventsEnabled()) {
            INSTANCE.sendErrorReports();
        }
    }

    @JvmStatic
    public static final void sendErrorReports() {
        if (Utility.INSTANCE.isDataProcessingRestricted()) {
            return;
        }
        File[] reports = INSTANCE.listErrorReportFiles();
        ArrayList<ErrorReportData> validReports = new ArrayList<ErrorReportData>();
        for (File report : reports) {
            ErrorReportData errorData = new ErrorReportData(report);
            if (!errorData.isValid()) continue;
            validReports.add(errorData);
        }
        CollectionsKt.sortWith((List)validReports, ErrorReportHandler::sendErrorReports$lambda-0);
        JSONArray errorLogs = new JSONArray();
        int i = 0;
        while (i < validReports.size()) {
            if (i >= 1000) break;
            errorLogs.put(validReports.get(i));
            int n = i;
            i = n + 1;
        }
        InstrumentUtility.sendReports("error_reports", errorLogs, arg_0 -> ErrorReportHandler.sendErrorReports$lambda-2(validReports, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final File[] listErrorReportFiles() {
        File[] fileArray = InstrumentUtility.INSTANCE.getInstrumentReportDir();
        if (fileArray == null) {
            return new File[0];
        }
        File[] reportDir = fileArray;
        fileArray = reportDir.listFiles(ErrorReportHandler::listErrorReportFiles$lambda-3);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"reportDir.listFiles { dir, name ->\n      name.matches(Regex(String.format(\"^%s[0-9]+.json$\", InstrumentUtility.ERROR_REPORT_PREFIX)))\n    }");
        return fileArray;
    }

    private static final int sendErrorReports$lambda-0(ErrorReportData o1, ErrorReportData o2) {
        Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
        return o1.compareTo(o2);
    }

    private static final void sendErrorReports$lambda-2(ArrayList $validReports, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$validReports, (String)"$validReports");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            JSONObject jSONObject;
            if (response.getError() == null && Intrinsics.areEqual((Object)((jSONObject = response.getJsonObject()) == null ? null : Boolean.valueOf(jSONObject.getBoolean("success"))), (Object)true)) {
                Iterable $this$forEach$iv = $validReports;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ErrorReportData it = (ErrorReportData)element$iv;
                    boolean bl = false;
                    it.clear();
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static final boolean listErrorReportFiles$lambda-3(File dir, String name) {
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        CharSequence charSequence = name;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "^%s[0-9]+.json$";
        Object[] objectArray = new Object[]{"error_log_"};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        stringCompanionObject = new Regex(string2);
        boolean bl2 = false;
        return stringCompanionObject.matches(charSequence);
    }
}

