/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.internal.FacebookRequestErrorClassification;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002HIB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020(H\u0007J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0004H\u0002J\u0014\u00107\u001a\u0004\u0018\u00010%2\b\u00106\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u00108\u001a\u000202H\u0007J\u001d\u00109\u001a\u00020%2\u0006\u00106\u001a\u00020\u00042\u0006\u0010:\u001a\u000205H\u0000\u00a2\u0006\u0002\b;J*\u0010<\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020>0$0=2\b\u0010?\u001a\u0004\u0018\u000105H\u0002J\u001c\u0010@\u001a\u0004\u0018\u0001002\b\u0010A\u001a\u0004\u0018\u0001052\u0006\u0010B\u001a\u00020\u0004H\u0002J\b\u0010C\u001a\u000202H\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010%2\u0006\u00106\u001a\u00020\u00042\u0006\u0010E\u001a\u00020*H\u0007J\u0010\u0010F\u001a\u0002022\u0006\u0010G\u001a\u00020*H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n !*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u0010\u0012\f\u0012\n !*\u0004\u0018\u00010-0-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager;", "", "()V", "APPLICATION_FIELDS", "", "APP_SETTINGS_PREFS_KEY_FORMAT", "APP_SETTINGS_PREFS_STORE", "APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES", "APP_SETTING_APP_EVENTS_AAM_RULE", "APP_SETTING_APP_EVENTS_EVENT_BINDINGS", "APP_SETTING_APP_EVENTS_FEATURE_BITMASK", "APP_SETTING_APP_EVENTS_SESSION_TIMEOUT", "APP_SETTING_DIALOG_CONFIGS", "APP_SETTING_FIELDS", "", "APP_SETTING_NUX_CONTENT", "APP_SETTING_NUX_ENABLED", "APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD", "APP_SETTING_SMART_LOGIN_OPTIONS", "APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING", "AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD", "", "CODELESS_EVENTS_ENABLED_BITMASK_FIELD", "IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD", "MACA_RULES_KEY", "MONITOR_ENABLED_BITMASK_FIELD", "PROTECTED_MODE_RULES", "SDK_UPDATE_MESSAGE", "SMART_LOGIN_BOOKMARK_ICON_URL", "SMART_LOGIN_MENU_ICON_URL", "STANDARD_PARAMS_KEY", "SUGGESTED_EVENTS_SETTING", "TAG", "kotlin.jvm.PlatformType", "TRACK_UNINSTALL_ENABLED_BITMASK_FIELD", "fetchedAppSettings", "", "Lcom/facebook/internal/FetchedAppSettings;", "fetchedAppSettingsCallbacks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/facebook/internal/FetchedAppSettingsManager$FetchedAppSettingsCallback;", "isUnityInit", "", "loadingState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/facebook/internal/FetchedAppSettingsManager$FetchAppSettingState;", "printedSDKUpdatedMessage", "unityEventBindings", "Lorg/json/JSONArray;", "getAppSettingsAsync", "", "callback", "getAppSettingsQueryResponse", "Lorg/json/JSONObject;", "applicationId", "getAppSettingsWithoutQuery", "loadAppSettingsAsync", "parseAppSettingsFromJSON", "settingsJSON", "parseAppSettingsFromJSON$facebook_core_release", "parseDialogConfigurations", "", "Lcom/facebook/internal/FetchedAppSettings$DialogFeatureConfig;", "dialogConfigResponse", "parseProtectedModeRules", "protectedModeSettings", "ruleType", "pollCallbacks", "queryAppSettings", "forceRequery", "setIsUnityInit", "flag", "FetchAppSettingState", "FetchedAppSettingsCallback", "facebook-core_release"})
public final class FetchedAppSettingsManager {
    @NotNull
    public static final FetchedAppSettingsManager INSTANCE = new FetchedAppSettingsManager();
    private static final String TAG = FetchedAppSettingsManager.class.getSimpleName();
    @NotNull
    private static final String APP_SETTINGS_PREFS_STORE = "com.facebook.internal.preferences.APP_SETTINGS";
    @NotNull
    private static final String APP_SETTINGS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_SETTINGS.%s";
    @NotNull
    private static final String APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING = "supports_implicit_sdk_logging";
    @NotNull
    private static final String APP_SETTING_NUX_CONTENT = "gdpv4_nux_content";
    @NotNull
    private static final String APP_SETTING_NUX_ENABLED = "gdpv4_nux_enabled";
    @NotNull
    private static final String APP_SETTING_DIALOG_CONFIGS = "android_dialog_configs";
    @NotNull
    private static final String APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES = "android_sdk_error_categories";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_SESSION_TIMEOUT = "app_events_session_timeout";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_FEATURE_BITMASK = "app_events_feature_bitmask";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_EVENT_BINDINGS = "auto_event_mapping_android";
    @NotNull
    private static final String APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD = "restrictive_data_filter_params";
    private static final int AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 8;
    private static final int IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 16;
    private static final int CODELESS_EVENTS_ENABLED_BITMASK_FIELD = 32;
    private static final int TRACK_UNINSTALL_ENABLED_BITMASK_FIELD = 256;
    private static final int MONITOR_ENABLED_BITMASK_FIELD = 16384;
    @NotNull
    private static final String APP_SETTING_SMART_LOGIN_OPTIONS = "seamless_login";
    @NotNull
    private static final String SMART_LOGIN_BOOKMARK_ICON_URL = "smart_login_bookmark_icon_url";
    @NotNull
    private static final String SMART_LOGIN_MENU_ICON_URL = "smart_login_menu_icon_url";
    @NotNull
    private static final String SDK_UPDATE_MESSAGE = "sdk_update_message";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_AAM_RULE = "aam_rules";
    @NotNull
    private static final String SUGGESTED_EVENTS_SETTING = "suggested_events_setting";
    @NotNull
    private static final String PROTECTED_MODE_RULES = "protected_mode_rules";
    @NotNull
    private static final String STANDARD_PARAMS_KEY = "standard_params";
    @NotNull
    private static final String MACA_RULES_KEY = "maca_rules";
    @NotNull
    private static final List<String> APP_SETTING_FIELDS;
    @NotNull
    private static final String APPLICATION_FIELDS = "fields";
    @NotNull
    private static final Map<String, FetchedAppSettings> fetchedAppSettings;
    @NotNull
    private static final AtomicReference<FetchAppSettingState> loadingState;
    @NotNull
    private static final ConcurrentLinkedQueue<FetchedAppSettingsCallback> fetchedAppSettingsCallbacks;
    private static boolean printedSDKUpdatedMessage;
    private static boolean isUnityInit;
    @Nullable
    private static JSONArray unityEventBindings;

    private FetchedAppSettingsManager() {
    }

    @JvmStatic
    public static final void loadAppSettingsAsync() {
        boolean canStartLoading;
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        String applicationId = FacebookSdk.INSTANCE.getApplicationId();
        if (Utility.isNullOrEmpty(applicationId)) {
            loadingState.set(FetchAppSettingState.ERROR);
            INSTANCE.pollCallbacks();
            return;
        }
        if (fetchedAppSettings.containsKey(applicationId)) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            INSTANCE.pollCallbacks();
            return;
        }
        boolean bl = canStartLoading = loadingState.compareAndSet(FetchAppSettingState.NOT_LOADED, FetchAppSettingState.LOADING) || loadingState.compareAndSet(FetchAppSettingState.ERROR, FetchAppSettingState.LOADING);
        if (!canStartLoading) {
            INSTANCE.pollCallbacks();
            return;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = APP_SETTINGS_PREFS_KEY_FORMAT;
        Object[] objectArray = new Object[]{applicationId};
        boolean bl2 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String settingsKey = string2;
        FacebookSdk.INSTANCE.getExecutor().execute(() -> FetchedAppSettingsManager.loadAppSettingsAsync$lambda-0(context, settingsKey, applicationId));
    }

    @JvmStatic
    @Nullable
    public static final FetchedAppSettings getAppSettingsWithoutQuery(@Nullable String applicationId) {
        return applicationId != null ? fetchedAppSettings.get(applicationId) : null;
    }

    @JvmStatic
    public static final void getAppSettingsAsync(@NotNull FetchedAppSettingsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        fetchedAppSettingsCallbacks.add(callback);
        INSTANCE.loadAppSettingsAsync();
    }

    private final synchronized void pollCallbacks() {
        FetchAppSettingState currentState = loadingState.get();
        if (FetchAppSettingState.NOT_LOADED == currentState || FetchAppSettingState.LOADING == currentState) {
            return;
        }
        String applicationId = FacebookSdk.INSTANCE.getApplicationId();
        FetchedAppSettings appSettings = fetchedAppSettings.get(applicationId);
        Handler handler = new Handler(Looper.getMainLooper());
        if (FetchAppSettingState.ERROR == currentState) {
            while (!fetchedAppSettingsCallbacks.isEmpty()) {
                FetchedAppSettingsCallback callback = fetchedAppSettingsCallbacks.poll();
                handler.post(() -> FetchedAppSettingsManager.pollCallbacks$lambda-1(callback));
            }
            return;
        }
        while (!fetchedAppSettingsCallbacks.isEmpty()) {
            FetchedAppSettingsCallback callback = fetchedAppSettingsCallbacks.poll();
            handler.post(() -> FetchedAppSettingsManager.pollCallbacks$lambda-2(callback, appSettings));
        }
    }

    @JvmStatic
    @Nullable
    public static final FetchedAppSettings queryAppSettings(@NotNull String applicationId, boolean forceRequery) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        if (!forceRequery && fetchedAppSettings.containsKey(applicationId)) {
            return fetchedAppSettings.get(applicationId);
        }
        JSONObject jSONObject = INSTANCE.getAppSettingsQueryResponse(applicationId);
        if (jSONObject == null) {
            return null;
        }
        JSONObject response = jSONObject;
        FetchedAppSettings fetchedAppSettings = INSTANCE.parseAppSettingsFromJSON$facebook_core_release(applicationId, response);
        if (Intrinsics.areEqual((Object)applicationId, (Object)FacebookSdk.INSTANCE.getApplicationId())) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            INSTANCE.pollCallbacks();
        }
        return fetchedAppSettings;
    }

    @NotNull
    public final FetchedAppSettings parseAppSettingsFromJSON$facebook_core_release(@NotNull String applicationId, @NotNull JSONObject settingsJSON) {
        JSONArray eventBindings;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)settingsJSON, (String)"settingsJSON");
        JSONArray errorClassificationJSON = settingsJSON.optJSONArray(APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES);
        FacebookRequestErrorClassification facebookRequestErrorClassification = FacebookRequestErrorClassification.Companion.createFromJSON(errorClassificationJSON);
        FacebookRequestErrorClassification errorClassification = facebookRequestErrorClassification == null ? FacebookRequestErrorClassification.Companion.getDefaultErrorClassification() : facebookRequestErrorClassification;
        int featureBitmask = settingsJSON.optInt(APP_SETTING_APP_EVENTS_FEATURE_BITMASK, 0);
        boolean automaticLoggingEnabled = (featureBitmask & 8) != 0;
        boolean inAppPurchaseAutomaticLoggingEnabled = (featureBitmask & 0x10) != 0;
        boolean codelessEventsEnabled = (featureBitmask & 0x20) != 0;
        boolean trackUninstallEnabled = (featureBitmask & 0x100) != 0;
        boolean monitorEnabled = (featureBitmask & 0x4000) != 0;
        unityEventBindings = eventBindings = settingsJSON.optJSONArray(APP_SETTING_APP_EVENTS_EVENT_BINDINGS);
        if (unityEventBindings != null) {
            if (InternalSettings.INSTANCE.isUnityApp()) {
                JSONArray jSONArray = eventBindings;
                UnityReflection.sendEventMapping(jSONArray == null ? null : jSONArray.toString());
            }
        }
        boolean bl = settingsJSON.optBoolean(APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, false);
        Object object = settingsJSON.optString(APP_SETTING_NUX_CONTENT, "");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settingsJSON.optString(APP_SETTING_NUX_CONTENT, \"\")");
        String string = object;
        boolean bl2 = settingsJSON.optBoolean(APP_SETTING_NUX_ENABLED, false);
        int n = settingsJSON.optInt(APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, Constants.INSTANCE.getDefaultAppEventsSessionTimeoutInSeconds());
        EnumSet<SmartLoginOption> enumSet = SmartLoginOption.Companion.parseOptions(settingsJSON.optLong(APP_SETTING_SMART_LOGIN_OPTIONS));
        Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> map = this.parseDialogConfigurations(settingsJSON.optJSONObject(APP_SETTING_DIALOG_CONFIGS));
        object = settingsJSON.optString(SMART_LOGIN_BOOKMARK_ICON_URL);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settingsJSON.optString(SMART_LOGIN_BOOKMARK_ICON_URL)");
        String string2 = object;
        object = settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL)");
        String string3 = object;
        object = settingsJSON.optString(SDK_UPDATE_MESSAGE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settingsJSON.optString(SDK_UPDATE_MESSAGE)");
        FetchedAppSettings result = new FetchedAppSettings(bl, string, bl2, n, enumSet, map, automaticLoggingEnabled, errorClassification, string2, string3, inAppPurchaseAutomaticLoggingEnabled, codelessEventsEnabled, eventBindings, (String)object, trackUninstallEnabled, monitorEnabled, settingsJSON.optString(APP_SETTING_APP_EVENTS_AAM_RULE), settingsJSON.optString(SUGGESTED_EVENTS_SETTING), settingsJSON.optString(APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), STANDARD_PARAMS_KEY), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), MACA_RULES_KEY));
        object = fetchedAppSettings;
        boolean bl3 = false;
        object.put(applicationId, result);
        return result;
    }

    @JvmStatic
    public static final void setIsUnityInit(boolean flag) {
        isUnityInit = flag;
        if (unityEventBindings != null && isUnityInit) {
            UnityReflection.sendEventMapping(String.valueOf(unityEventBindings));
        }
    }

    private final JSONObject getAppSettingsQueryResponse(String applicationId) {
        Bundle appSettingsParams = new Bundle();
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$getAppSettingsQueryResponse_u24lambda_u2d3 = list;
        boolean bl4 = false;
        $this$getAppSettingsQueryResponse_u24lambda_u2d3.addAll((Collection)APP_SETTING_FIELDS);
        List appSettingFields = list;
        appSettingsParams.putString(APPLICATION_FIELDS, TextUtils.join((CharSequence)",", (Iterable)appSettingFields));
        GraphRequest request = GraphRequest.Companion.newGraphPathRequest(null, "app", null);
        request.setForceApplicationRequest(true);
        request.setParameters(appSettingsParams);
        JSONObject jSONObject = request.executeAndWait().getJsonObject();
        return jSONObject == null ? new JSONObject() : jSONObject;
    }

    private final Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> parseDialogConfigurations(JSONObject dialogConfigResponse) {
        int n;
        int n2;
        JSONArray dialogConfigData;
        HashMap dialogConfigMap = new HashMap();
        if (dialogConfigResponse != null && (dialogConfigData = dialogConfigResponse.optJSONArray("data")) != null && (n2 = 0) < (n = dialogConfigData.length())) {
            do {
                Map map;
                int i = n2++;
                JSONObject jSONObject = dialogConfigData.optJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"dialogConfigData.optJSONObject(i)");
                FetchedAppSettings.DialogFeatureConfig dialogFeatureConfig = FetchedAppSettings.DialogFeatureConfig.Companion.parseDialogConfig(jSONObject);
                if (dialogFeatureConfig == null) continue;
                FetchedAppSettings.DialogFeatureConfig dialogConfig = dialogFeatureConfig;
                String dialogName = dialogConfig.getDialogName();
                Map featureMap = (Map)dialogConfigMap.get(dialogName);
                if (featureMap == null) {
                    featureMap = new HashMap();
                    map = dialogConfigMap;
                    boolean bl = false;
                    map.put(dialogName, featureMap);
                }
                map = featureMap;
                String string = dialogConfig.getFeatureName();
                boolean bl = false;
                map.put(string, dialogConfig);
            } while (n2 < n);
        }
        return dialogConfigMap;
    }

    private final JSONArray parseProtectedModeRules(JSONObject protectedModeSettings, String ruleType) {
        JSONArray rule = null;
        if (protectedModeSettings != null) {
            rule = protectedModeSettings.optJSONArray(ruleType);
        }
        return rule;
    }

    private static final void loadAppSettingsAsync$lambda-0(Context $context, String $settingsKey, String $applicationId) {
        JSONObject resultJSON;
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$settingsKey, (String)"$settingsKey");
        Intrinsics.checkNotNullParameter((Object)$applicationId, (String)"$applicationId");
        SharedPreferences sharedPrefs = $context.getSharedPreferences(APP_SETTINGS_PREFS_STORE, 0);
        String settingsJSONString = sharedPrefs.getString($settingsKey, null);
        FetchedAppSettings appSettings = null;
        if (!Utility.isNullOrEmpty(settingsJSONString)) {
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (settingsJSONString == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            JSONObject settingsJSON = null;
            try {
                settingsJSON = new JSONObject(settingsJSONString);
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
            if (settingsJSON != null) {
                appSettings = INSTANCE.parseAppSettingsFromJSON$facebook_core_release($applicationId, settingsJSON);
            }
        }
        if ((resultJSON = INSTANCE.getAppSettingsQueryResponse($applicationId)) != null) {
            INSTANCE.parseAppSettingsFromJSON$facebook_core_release($applicationId, resultJSON);
            sharedPrefs.edit().putString($settingsKey, resultJSON.toString()).apply();
        }
        if (appSettings != null) {
            String updateMessage = appSettings.getSdkUpdateMessage();
            if (!printedSDKUpdatedMessage && updateMessage != null && updateMessage.length() > 0) {
                printedSDKUpdatedMessage = true;
                Log.w((String)TAG, (String)updateMessage);
            }
        }
        FetchedAppGateKeepersManager.queryAppGateKeepers($applicationId, true);
        AutomaticAnalyticsLogger.INSTANCE.logActivateAppEvent();
        loadingState.set(fetchedAppSettings.containsKey($applicationId) ? FetchAppSettingState.SUCCESS : FetchAppSettingState.ERROR);
        INSTANCE.pollCallbacks();
    }

    private static final void pollCallbacks$lambda-1(FetchedAppSettingsCallback $callback) {
        $callback.onError();
    }

    private static final void pollCallbacks$lambda-2(FetchedAppSettingsCallback $callback, FetchedAppSettings $appSettings) {
        $callback.onSuccess($appSettings);
    }

    static {
        Object[] objectArray = new String[]{APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, APP_SETTING_NUX_CONTENT, APP_SETTING_NUX_ENABLED, APP_SETTING_DIALOG_CONFIGS, APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES, APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, APP_SETTING_APP_EVENTS_FEATURE_BITMASK, APP_SETTING_APP_EVENTS_EVENT_BINDINGS, APP_SETTING_SMART_LOGIN_OPTIONS, SMART_LOGIN_BOOKMARK_ICON_URL, SMART_LOGIN_MENU_ICON_URL, APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD, APP_SETTING_APP_EVENTS_AAM_RULE, SUGGESTED_EVENTS_SETTING, PROTECTED_MODE_RULES};
        APP_SETTING_FIELDS = CollectionsKt.listOf((Object[])objectArray);
        fetchedAppSettings = new ConcurrentHashMap();
        loadingState = new AtomicReference<FetchAppSettingState>(FetchAppSettingState.NOT_LOADED);
        fetchedAppSettingsCallbacks = new ConcurrentLinkedQueue();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager$FetchAppSettingState;", "", "(Ljava/lang/String;I)V", "NOT_LOADED", "LOADING", "SUCCESS", "ERROR", "facebook-core_release"})
    public static final class FetchAppSettingState
    extends Enum<FetchAppSettingState> {
        public static final /* enum */ FetchAppSettingState NOT_LOADED = new FetchAppSettingState();
        public static final /* enum */ FetchAppSettingState LOADING = new FetchAppSettingState();
        public static final /* enum */ FetchAppSettingState SUCCESS = new FetchAppSettingState();
        public static final /* enum */ FetchAppSettingState ERROR = new FetchAppSettingState();
        private static final /* synthetic */ FetchAppSettingState[] $VALUES;

        public static FetchAppSettingState[] values() {
            FetchAppSettingState[] fetchAppSettingStateArray = $VALUES;
            return Arrays.copyOf(fetchAppSettingStateArray, fetchAppSettingStateArray.length);
        }

        public static FetchAppSettingState valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(FetchAppSettingState.class, value);
        }

        static {
            $VALUES = fetchAppSettingStateArray = new FetchAppSettingState[]{FetchAppSettingState.NOT_LOADED, FetchAppSettingState.LOADING, FetchAppSettingState.SUCCESS, FetchAppSettingState.ERROR};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager$FetchedAppSettingsCallback;", "", "onError", "", "onSuccess", "fetchedAppSettings", "Lcom/facebook/internal/FetchedAppSettings;", "facebook-core_release"})
    public static interface FetchedAppSettingsCallback {
        public void onSuccess(@Nullable FetchedAppSettings var1);

        public void onError();
    }
}

