/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.security;

import android.util.Base64;
import android.util.Log;
import com.facebook.FacebookSdk;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/internal/security/OidcSecurityUtil;", "", "()V", "OPENID_KEYS_PATH", "", "getOPENID_KEYS_PATH", "()Ljava/lang/String;", "SIGNATURE_ALGORITHM_SHA256", "TIMEOUT_IN_MILLISECONDS", "", "getPublicKeyFromString", "Ljava/security/PublicKey;", "key", "getRawKeyFromEndPoint", "kid", "verify", "", "publicKey", "data", "signature", "facebook-core_release"})
public final class OidcSecurityUtil {
    @NotNull
    public static final OidcSecurityUtil INSTANCE = new OidcSecurityUtil();
    @NotNull
    private static final String OPENID_KEYS_PATH = "/.well-known/oauth/openid/keys/";
    @NotNull
    public static final String SIGNATURE_ALGORITHM_SHA256 = "SHA256withRSA";
    public static final long TIMEOUT_IN_MILLISECONDS = 5000L;

    private OidcSecurityUtil() {
    }

    @NotNull
    public final String getOPENID_KEYS_PATH() {
        return OPENID_KEYS_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String getRawKeyFromEndPoint(@NotNull String kid) {
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        String host = Intrinsics.stringPlus((String)"www.", (Object)FacebookSdk.INSTANCE.getFacebookDomain());
        URL openIdKeyUrl = new URL("https", host, OPENID_KEYS_PATH);
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        Ref.ObjectRef result = new Ref.ObjectRef();
        FacebookSdk.INSTANCE.getExecutor().execute(() -> OidcSecurityUtil.getRawKeyFromEndPoint$lambda-1(openIdKeyUrl, result, kid, lock, condition));
        Lock lock2 = lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            bl2 = condition.await(5000L, TimeUnit.MILLISECONDS);
        }
        finally {
            lock2.unlock();
        }
        return (String)result.element;
    }

    @JvmStatic
    @NotNull
    public static final PublicKey getPublicKeyFromString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String pubKeyString = StringsKt.replace$default((String)key, (String)"\n", (String)"", (boolean)false, (int)4, null);
        pubKeyString = StringsKt.replace$default((String)pubKeyString, (String)"-----BEGIN PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        pubKeyString = StringsKt.replace$default((String)pubKeyString, (String)"-----END PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        byte[] byArray = Base64.decode((String)pubKeyString, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(pubKeyString, Base64.DEFAULT)");
        byte[] byteKey = byArray;
        X509EncodedKeySpec x509publicKey = new X509EncodedKeySpec(byteKey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey publicKey = kf.generatePublic(x509publicKey);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"kf.generatePublic(x509publicKey)");
        return publicKey;
    }

    @JvmStatic
    public static final boolean verify(@NotNull PublicKey publicKey, @NotNull String data, @NotNull String signature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM_SHA256);
            sig.initVerify(publicKey);
            String string = data;
            Object object = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray = string.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            sig.update(byArray);
            object = Base64.decode((String)signature, (int)8);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(signature, Base64.URL_SAFE)");
            Object decodedSignature = object;
            bl = sig.verify((byte[])decodedSignature);
        }
        catch (Exception _ex) {
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getRawKeyFromEndPoint$lambda-1(URL $openIdKeyUrl, Ref.ObjectRef $result, String $kid, ReentrantLock $lock, Condition $condition) {
        Intrinsics.checkNotNullParameter((Object)$openIdKeyUrl, (String)"$openIdKeyUrl");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$kid, (String)"$kid");
        Intrinsics.checkNotNullParameter((Object)$lock, (String)"$lock");
        URLConnection uRLConnection = $openIdKeyUrl.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            String data = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            connection.getInputStream().close();
            $result.element = new JSONObject(data).optString($kid);
        }
        catch (Exception _ex) {
            String string = _ex.getMessage();
            Log.d((String)INSTANCE.getClass().getName(), (String)(string == null ? "Error getting public key" : string));
        }
        finally {
            connection.disconnect();
            Lock lock = $lock;
            boolean bl = false;
            boolean bl3 = false;
            lock.lock();
            try {
                boolean bl4 = false;
                $condition.signal();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

