/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.loadframe;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFrameOutput;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFramePriorityTask;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask;", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFramePriorityTask;", "width", "", "height", "untilFrame", "priority", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFramePriorityTask$Priority;", "output", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameOutput;", "platformBitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "bitmapFrameRenderer", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "(IIILcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFramePriorityTask$Priority;Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameOutput;Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;)V", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "getPriority", "()Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFramePriorityTask$Priority;", "run", "", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nLoadFrameTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadFrameTask.kt\ncom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1855#2:64\n1855#2,2:65\n1856#2:67\n*S KotlinDebug\n*F\n+ 1 LoadFrameTask.kt\ncom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask\n*L\n37#1:64\n49#1:65,2\n37#1:67\n*E\n"})
public final class LoadFrameTask
implements LoadFramePriorityTask {
    private final int width;
    private final int height;
    private final int untilFrame;
    @NotNull
    private final LoadFramePriorityTask.Priority priority;
    @NotNull
    private final LoadFrameOutput output;
    @NotNull
    private final PlatformBitmapFactory platformBitmapFactory;
    @NotNull
    private final BitmapFrameRenderer bitmapFrameRenderer;
    @NotNull
    private final Bitmap.Config bitmapConfig;

    public LoadFrameTask(int width, int height, int untilFrame, @NotNull LoadFramePriorityTask.Priority priority, @NotNull LoadFrameOutput output, @NotNull PlatformBitmapFactory platformBitmapFactory, @NotNull BitmapFrameRenderer bitmapFrameRenderer) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)platformBitmapFactory, (String)"platformBitmapFactory");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameRenderer, (String)"bitmapFrameRenderer");
        this.width = width;
        this.height = height;
        this.untilFrame = untilFrame;
        this.priority = priority;
        this.output = output;
        this.platformBitmapFactory = platformBitmapFactory;
        this.bitmapFrameRenderer = bitmapFrameRenderer;
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
    }

    @Override
    @NotNull
    public LoadFramePriorityTask.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void run() {
        Map frameCollection = new LinkedHashMap();
        CloseableReference closeableReference = this.platformBitmapFactory.createBitmap(this.width, this.height, this.bitmapConfig);
        Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"platformBitmapFactory.cr\u2026th, height, bitmapConfig)");
        CloseableReference canvasBitmapFrame = closeableReference;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.untilFrame);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            CloseableReference copyFrame;
            int element$iv;
            int frameNumber = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Bitmap currentFrame = null;
            boolean renderSucceed = false;
            if (CloseableReference.isValid((CloseableReference)canvasBitmapFrame)) {
                currentFrame = (Bitmap)canvasBitmapFrame.get();
                renderSucceed = this.bitmapFrameRenderer.renderFrame(frameNumber, currentFrame);
            }
            if (currentFrame == null || !renderSucceed) {
                CloseableReference.closeSafely((CloseableReference)canvasBitmapFrame);
                Iterable $this$forEach$iv2 = frameCollection.values();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    CloseableReference it = (CloseableReference)element$iv2;
                    boolean bl2 = false;
                    CloseableReference.closeSafely((CloseableReference)it);
                }
                this.output.onFail();
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.platformBitmapFactory.createBitmap(currentFrame), (String)"platformBitmapFactory.createBitmap(currentFrame)");
            Integer n = frameNumber;
            frameCollection.put(n, copyFrame);
        }
        CloseableReference.closeSafely((CloseableReference)canvasBitmapFrame);
        this.output.onSuccess(frameCollection);
    }

    @Override
    public int compareTo(@NotNull LoadFramePriorityTask other) {
        return LoadFramePriorityTask.DefaultImpls.compareTo(this, other);
    }
}

