/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable.animator;

import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/facebook/fresco/animation/drawable/animator/AnimatedDrawable2ValueAnimatorHelper;", "", "()V", "createAnimatorUpdateListener", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "drawable", "Landroid/graphics/drawable/Drawable;", "createValueAnimator", "Landroid/animation/ValueAnimator;", "animatedDrawable", "loopCount", "", "loopDurationMs", "", "Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2;", "maxDurationMs", "animated-drawable_release"})
public final class AnimatedDrawable2ValueAnimatorHelper {
    @NotNull
    public static final AnimatedDrawable2ValueAnimatorHelper INSTANCE = new AnimatedDrawable2ValueAnimatorHelper();

    private AnimatedDrawable2ValueAnimatorHelper() {
    }

    @JvmStatic
    @Nullable
    public static final ValueAnimator createValueAnimator(@NotNull AnimatedDrawable2 animatedDrawable, int maxDurationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatedDrawable), (String)"animatedDrawable");
        ValueAnimator valueAnimator = AnimatedDrawable2ValueAnimatorHelper.createValueAnimator(animatedDrawable, animatedDrawable.getLoopCount(), animatedDrawable.getLoopDurationMs());
        if (valueAnimator == null) {
            return null;
        }
        ValueAnimator animator = valueAnimator;
        int repeatCount = (int)Math.max((long)maxDurationMs / animatedDrawable.getLoopDurationMs(), 1L);
        animator.setRepeatCount(repeatCount);
        return animator;
    }

    @JvmStatic
    @NotNull
    public static final ValueAnimator createValueAnimator(@NotNull Drawable animatedDrawable, int loopCount, long loopDurationMs) {
        Intrinsics.checkNotNullParameter((Object)animatedDrawable, (String)"animatedDrawable");
        ValueAnimator animator = new ValueAnimator();
        int[] nArray = new int[]{0, (int)loopDurationMs};
        animator.setIntValues(nArray);
        animator.setDuration(loopDurationMs);
        animator.setRepeatCount(loopCount != 0 ? loopCount : -1);
        animator.setRepeatMode(1);
        animator.setInterpolator(null);
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = AnimatedDrawable2ValueAnimatorHelper.createAnimatorUpdateListener(animatedDrawable);
        animator.addUpdateListener(animatorUpdateListener);
        return animator;
    }

    @JvmStatic
    @NotNull
    public static final ValueAnimator.AnimatorUpdateListener createAnimatorUpdateListener(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        return arg_0 -> AnimatedDrawable2ValueAnimatorHelper.createAnimatorUpdateListener$lambda$0(drawable, arg_0);
    }

    private static final void createAnimatorUpdateListener$lambda$0(Drawable $drawable, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)$drawable, (String)"$drawable");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Object object = animation.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        $drawable.setLevel(((Integer)object).intValue());
    }
}

