/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.CloneableDrawable;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010\u000b\u001a\u00020\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J&\u0010\u000e\u001a\u00020\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007\u00a8\u0006\u0018"}, d2={"Lcom/facebook/drawee/drawable/DrawableUtils;", "", "<init>", "()V", "cloneDrawable", "Landroid/graphics/drawable/Drawable;", "drawable", "copyProperties", "", "to", "from", "setDrawableProperties", "properties", "Lcom/facebook/drawee/drawable/DrawableProperties;", "setCallbacks", "callback", "Landroid/graphics/drawable/Drawable$Callback;", "transformCallback", "Lcom/facebook/drawee/drawable/TransformCallback;", "multiplyColorAlpha", "", "color", "alpha", "getOpacityFromColor", "drawee_release"})
public final class DrawableUtils {
    @NotNull
    public static final DrawableUtils INSTANCE = new DrawableUtils();

    private DrawableUtils() {
    }

    @JvmStatic
    @Nullable
    public static final Drawable cloneDrawable(@Nullable Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        CloneableDrawable cloneableDrawable = drawable instanceof CloneableDrawable ? (CloneableDrawable)drawable : null;
        if (cloneableDrawable == null || (cloneableDrawable = cloneableDrawable.cloneDrawable()) == null) {
            Drawable.ConstantState constantState = drawable.getConstantState();
            cloneableDrawable = constantState != null ? constantState.newDrawable() : null;
        }
        return cloneableDrawable;
    }

    @JvmStatic
    public static final void copyProperties(@Nullable Drawable to, @Nullable Drawable from) {
        if (from == null || to == null || to == from) {
            return;
        }
        to.setBounds(from.getBounds());
        to.setChangingConfigurations(from.getChangingConfigurations());
        to.setLevel(from.getLevel());
        to.setVisible(from.isVisible(), false);
        to.setState(from.getState());
    }

    @JvmStatic
    public static final void setDrawableProperties(@Nullable Drawable drawable, @Nullable DrawableProperties properties) {
        block1: {
            if (drawable == null) {
                return;
            }
            DrawableProperties drawableProperties = properties;
            if (drawableProperties == null) break block1;
            drawableProperties.applyTo(drawable);
        }
    }

    @JvmStatic
    public static final void setCallbacks(@Nullable Drawable drawable, @Nullable Drawable.Callback callback, @Nullable TransformCallback transformCallback) {
        block1: {
            if (drawable == null) {
                return;
            }
            drawable.setCallback(callback);
            TransformAwareDrawable transformAwareDrawable = drawable instanceof TransformAwareDrawable ? (TransformAwareDrawable)drawable : null;
            if (transformAwareDrawable == null) break block1;
            transformAwareDrawable.setTransformCallback(transformCallback);
        }
    }

    @JvmStatic
    public static final int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        int clippedAlpha = alpha;
        clippedAlpha += clippedAlpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * clippedAlpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    @JvmStatic
    public static final int getOpacityFromColor(int color) {
        int n;
        switch (color >>> 24) {
            case 255: {
                n = -1;
                break;
            }
            case 0: {
                n = -2;
                break;
            }
            default: {
                n = -3;
            }
        }
        return n;
    }
}

