/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;

public class BranchOnSeparateImagesProducer
implements Producer<EncodedImage> {
    private final Producer<EncodedImage> mNextProducer1;
    private final Producer<EncodedImage> mNextProducer2;

    public BranchOnSeparateImagesProducer(Producer<EncodedImage> nextProducer1, Producer<EncodedImage> nextProducer2) {
        this.mNextProducer1 = nextProducer1;
        this.mNextProducer2 = nextProducer2;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        OnFirstImageConsumer onFirstImageConsumer = new OnFirstImageConsumer(consumer, context);
        this.mNextProducer1.produceResults(onFirstImageConsumer, context);
    }

    private class OnFirstImageConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private ProducerContext mProducerContext;

        private OnFirstImageConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
            super(consumer);
            this.mProducerContext = producerContext;
        }

        @Override
        protected void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            ImageRequest request = this.mProducerContext.getImageRequest();
            boolean isGoodEnough = this.isResultGoodEnough(newResult, request);
            if (newResult != null && (isGoodEnough || request.getLocalThumbnailPreviewsEnabled())) {
                this.getConsumer().onNewResult(newResult, isLast && isGoodEnough);
            }
            if (isLast && !isGoodEnough) {
                BranchOnSeparateImagesProducer.this.mNextProducer2.produceResults(this.getConsumer(), this.mProducerContext);
            }
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            BranchOnSeparateImagesProducer.this.mNextProducer2.produceResults(this.getConsumer(), this.mProducerContext);
        }

        private boolean isResultGoodEnough(EncodedImage encodedImage, ImageRequest imageRequest) {
            if (encodedImage == null) {
                return false;
            }
            return encodedImage.getWidth() >= imageRequest.getPreferredWidth() && encodedImage.getHeight() >= imageRequest.getPreferredHeight();
        }
    }
}

