/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.Constants;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformCollator;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleMatcher;
import com.facebook.hermes.intl.LocaleResolver;
import com.facebook.hermes.intl.OptionHelpers;
import com.facebook.hermes.intl.PlatformCollatorAndroid;
import com.facebook.hermes.intl.PlatformCollatorICU;
import com.facebook.hermes.intl.UnicodeExtensionKeys;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@DoNotStrip
public class Collator {
    private IPlatformCollator.Usage mResolvedUsage;
    private IPlatformCollator.Sensitivity mResolvedSensitivity;
    private boolean mResolvedIgnorePunctuation;
    private String mResolvedCollation = "default";
    private boolean mResolvedNumeric;
    private IPlatformCollator.CaseFirst mResolvedCaseFirst;
    private ILocaleObject<?> mResolvedLocaleObject;
    private ILocaleObject<?> mResolvedLocaleObjectForResolvedOptions;
    private IPlatformCollator mPlatformCollatorObject = Build.VERSION.SDK_INT >= 24 ? new PlatformCollatorICU() : new PlatformCollatorAndroid();

    private void initializeCollator(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        Object sensitivity;
        Object usage = OptionHelpers.GetOption(options, "usage", OptionHelpers.OptionType.STRING, Constants.COLLATOR_USAGE_POSSIBLE_VALUES, "sort");
        this.mResolvedUsage = OptionHelpers.searchEnum(IPlatformCollator.Usage.class, JSObjects.getJavaString(usage));
        Object opt = JSObjects.newObject();
        Object matcher = OptionHelpers.GetOption(options, "localeMatcher", OptionHelpers.OptionType.STRING, Constants.LOCALEMATCHER_POSSIBLE_VALUES, "best fit");
        JSObjects.Put(opt, "localeMatcher", matcher);
        Object numeric = OptionHelpers.GetOption(options, "numeric", OptionHelpers.OptionType.BOOLEAN, JSObjects.Undefined(), JSObjects.Undefined());
        if (!JSObjects.isUndefined(numeric)) {
            numeric = JSObjects.newString(String.valueOf(JSObjects.getJavaBoolean(numeric)));
        }
        JSObjects.Put(opt, "kn", numeric);
        Object caseFirst = OptionHelpers.GetOption(options, "caseFirst", OptionHelpers.OptionType.STRING, Constants.CASEFIRST_POSSIBLE_VALUES, JSObjects.Undefined());
        JSObjects.Put(opt, "kf", caseFirst);
        List<String> relevantExtensionKeys = Arrays.asList("co", "kf", "kn");
        HashMap<String, Object> r = LocaleResolver.resolveLocale(locales, opt, relevantExtensionKeys);
        this.mResolvedLocaleObject = (ILocaleObject)JSObjects.getJavaMap(r).get("locale");
        this.mResolvedLocaleObjectForResolvedOptions = this.mResolvedLocaleObject.cloneObject();
        Object collation = JSObjects.Get(r, "co");
        if (JSObjects.isNull(collation)) {
            collation = JSObjects.newString("default");
        }
        this.mResolvedCollation = JSObjects.getJavaString(collation);
        Object numericCollation = JSObjects.Get(r, "kn");
        if (JSObjects.isNull(numericCollation)) {
            this.mResolvedNumeric = false;
        } else {
            String numericCollationValue = JSObjects.getJavaString(numericCollation);
            this.mResolvedNumeric = Boolean.parseBoolean(numericCollationValue);
        }
        Object caseFirstCollation = JSObjects.Get(r, "kf");
        if (JSObjects.isNull(caseFirstCollation)) {
            caseFirstCollation = JSObjects.newString("false");
        }
        this.mResolvedCaseFirst = OptionHelpers.searchEnum(IPlatformCollator.CaseFirst.class, JSObjects.getJavaString(caseFirstCollation));
        if (this.mResolvedUsage == IPlatformCollator.Usage.SEARCH) {
            ArrayList<String> currentCollationExtensions = this.mResolvedLocaleObject.getUnicodeExtensions("collation");
            ArrayList<String> currentResolvedCollationExtensions = new ArrayList<String>();
            for (String currentCollationExtension : currentCollationExtensions) {
                currentResolvedCollationExtensions.add(UnicodeExtensionKeys.resolveCollationAlias(currentCollationExtension));
            }
            currentResolvedCollationExtensions.add(UnicodeExtensionKeys.resolveCollationAlias("search"));
            this.mResolvedLocaleObject.setUnicodeExtensions("co", currentResolvedCollationExtensions);
        }
        this.mResolvedSensitivity = !JSObjects.isUndefined(sensitivity = OptionHelpers.GetOption(options, "sensitivity", OptionHelpers.OptionType.STRING, Constants.SENSITIVITY_POSSIBLE_VALUES, JSObjects.Undefined())) ? OptionHelpers.searchEnum(IPlatformCollator.Sensitivity.class, JSObjects.getJavaString(sensitivity)) : (this.mResolvedUsage == IPlatformCollator.Usage.SORT ? IPlatformCollator.Sensitivity.VARIANT : IPlatformCollator.Sensitivity.LOCALE);
        Object ignorePunctuation = OptionHelpers.GetOption(options, "ignorePunctuation", OptionHelpers.OptionType.BOOLEAN, JSObjects.Undefined(), false);
        this.mResolvedIgnorePunctuation = JSObjects.getJavaBoolean(ignorePunctuation);
    }

    @DoNotStrip
    public Collator(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        this.initializeCollator(locales, options);
        this.mPlatformCollatorObject.configure(this.mResolvedLocaleObject).setNumericAttribute(this.mResolvedNumeric).setCaseFirstAttribute(this.mResolvedCaseFirst).setSensitivity(this.mResolvedSensitivity).setIgnorePunctuation(this.mResolvedIgnorePunctuation);
    }

    @DoNotStrip
    public static List<String> supportedLocalesOf(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        String matcher = JSObjects.getJavaString(OptionHelpers.GetOption(options, "localeMatcher", OptionHelpers.OptionType.STRING, Constants.LOCALEMATCHER_POSSIBLE_VALUES, "best fit"));
        if (Build.VERSION.SDK_INT >= 24 && matcher.equals("best fit")) {
            return Arrays.asList(LocaleMatcher.bestFitSupportedLocales(locales.toArray(new String[locales.size()])));
        }
        return Arrays.asList(LocaleMatcher.lookupSupportedLocales(locales.toArray(new String[locales.size()])));
    }

    @DoNotStrip
    public Map<String, Object> resolvedOptions() throws JSRangeErrorException {
        LinkedHashMap<String, Object> finalResolvedOptions = new LinkedHashMap<String, Object>();
        String finalResolvedLocaleId = this.mResolvedLocaleObjectForResolvedOptions.toCanonicalTag();
        finalResolvedLocaleId = finalResolvedLocaleId.replace("-kn-true", "-kn");
        finalResolvedOptions.put("locale", finalResolvedLocaleId);
        finalResolvedOptions.put("usage", this.mResolvedUsage.toString());
        if (this.mResolvedSensitivity == IPlatformCollator.Sensitivity.LOCALE) {
            IPlatformCollator.Sensitivity defaultSensitivity = this.mPlatformCollatorObject.getSensitivity();
            finalResolvedOptions.put("sensitivity", defaultSensitivity.toString());
        } else {
            finalResolvedOptions.put("sensitivity", this.mResolvedSensitivity.toString());
        }
        finalResolvedOptions.put("ignorePunctuation", this.mResolvedIgnorePunctuation);
        finalResolvedOptions.put("collation", this.mResolvedCollation);
        finalResolvedOptions.put("numeric", this.mResolvedNumeric);
        finalResolvedOptions.put("caseFirst", this.mResolvedCaseFirst.toString());
        return finalResolvedOptions;
    }

    @DoNotStrip
    public double compare(String source, String target) {
        return this.mPlatformCollatorObject.compare(source, target);
    }
}

