/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.text.DateFormat;
import android.icu.text.NumberingSystem;
import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import androidx.annotation.RequiresApi;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformDateTimeFormatter;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.UnicodeExtensionKeys;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class PlatformDateTimeFormatterICU
implements IPlatformDateTimeFormatter {
    private DateFormat mDateFormat = null;

    @Override
    @RequiresApi(api=24)
    public String format(double n) {
        return this.mDateFormat.format(new Date((long)n));
    }

    @Override
    @RequiresApi(api=24)
    public String fieldToString(AttributedCharacterIterator.Attribute field, String fieldValue) {
        if (field == DateFormat.Field.DAY_OF_WEEK) {
            return "weekday";
        }
        if (field == DateFormat.Field.ERA) {
            return "era";
        }
        if (field == DateFormat.Field.YEAR) {
            try {
                Double.parseDouble(fieldValue);
                return "year";
            }
            catch (NumberFormatException nfe) {
                return "yearName";
            }
        }
        if (field == DateFormat.Field.MONTH) {
            return "month";
        }
        if (field == DateFormat.Field.DAY_OF_MONTH) {
            return "day";
        }
        if (field == DateFormat.Field.HOUR0) {
            return "hour";
        }
        if (field == DateFormat.Field.HOUR1) {
            return "hour";
        }
        if (field == DateFormat.Field.HOUR_OF_DAY0) {
            return "hour";
        }
        if (field == DateFormat.Field.HOUR_OF_DAY1) {
            return "hour";
        }
        if (field == DateFormat.Field.MINUTE) {
            return "minute";
        }
        if (field == DateFormat.Field.SECOND) {
            return "second";
        }
        if (field == DateFormat.Field.TIME_ZONE) {
            return "timeZoneName";
        }
        if (field == DateFormat.Field.AM_PM) {
            return "dayPeriod";
        }
        if (field.toString().equals("android.icu.text.DateFormat$Field(related year)")) {
            return "relatedYear";
        }
        return "literal";
    }

    @Override
    public AttributedCharacterIterator formatToParts(double n) {
        return this.mDateFormat.formatToCharacterIterator((Object)n);
    }

    @Override
    @RequiresApi(api=24)
    public String getDefaultCalendarName(ILocaleObject<?> mResolvedLocaleObject) throws JSRangeErrorException {
        String defaultCalendar = DateFormat.getDateInstance((int)3, (ULocale)((ULocale)mResolvedLocaleObject.getLocale())).getCalendar().getType();
        defaultCalendar = UnicodeExtensionKeys.resolveCalendarAlias(defaultCalendar);
        return defaultCalendar;
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformDateTimeFormatter.HourCycle getDefaultHourCycle(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        IPlatformDateTimeFormatter.HourCycle hourCycle;
        try {
            String dateFormatPattern = ((SimpleDateFormat)DateFormat.getTimeInstance((int)0, (ULocale)((ULocale)localeObject.getLocale()))).toPattern();
            String dateFormatPatternWithoutLiterals = PatternUtils.getPatternWithoutLiterals(dateFormatPattern);
            hourCycle = dateFormatPatternWithoutLiterals.contains(String.valueOf('h')) ? IPlatformDateTimeFormatter.HourCycle.H12 : (dateFormatPatternWithoutLiterals.contains(String.valueOf('K')) ? IPlatformDateTimeFormatter.HourCycle.H11 : (dateFormatPatternWithoutLiterals.contains(String.valueOf('H')) ? IPlatformDateTimeFormatter.HourCycle.H23 : IPlatformDateTimeFormatter.HourCycle.H24));
        }
        catch (ClassCastException ex) {
            hourCycle = IPlatformDateTimeFormatter.HourCycle.H24;
        }
        return hourCycle;
    }

    @Override
    @RequiresApi(api=24)
    public String getDefaultTimeZone(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        return Calendar.getInstance((ULocale)((ULocale)localeObject.getLocale())).getTimeZone().getID();
    }

    @Override
    @RequiresApi(api=24)
    public String getDefaultNumberingSystem(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        return NumberingSystem.getInstance((ULocale)((ULocale)localeObject.getLocale())).getName();
    }

    @RequiresApi(api=24)
    static int toICUDateStyle(IPlatformDateTimeFormatter.DateStyle dateStyle) throws JSRangeErrorException {
        switch (dateStyle) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        throw new JSRangeErrorException("Invalid DateStyle: " + dateStyle.toString());
    }

    @RequiresApi(api=24)
    static int toICUTimeStyle(IPlatformDateTimeFormatter.TimeStyle timeStyle) throws JSRangeErrorException {
        switch (timeStyle) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        throw new JSRangeErrorException("Invalid DateStyle: " + timeStyle.toString());
    }

    private static void replaceChars(StringBuilder builder, String from, String to) {
        int index = builder.indexOf(from);
        if (index != -1) {
            builder.replace(index, index + from.length(), to);
        }
    }

    @RequiresApi(api=24)
    private static String getPatternForStyle(ILocaleObject<?> resolvedLocaleObject, IPlatformDateTimeFormatter.DateStyle dateStyle, IPlatformDateTimeFormatter.TimeStyle timeStyle) throws JSRangeErrorException {
        if (dateStyle == IPlatformDateTimeFormatter.DateStyle.UNDEFINED) {
            return ((SimpleDateFormat)DateFormat.getTimeInstance((int)PlatformDateTimeFormatterICU.toICUTimeStyle(timeStyle), (ULocale)((ULocale)resolvedLocaleObject.getLocale()))).toLocalizedPattern();
        }
        if (timeStyle == IPlatformDateTimeFormatter.TimeStyle.UNDEFINED) {
            return ((SimpleDateFormat)DateFormat.getDateInstance((int)PlatformDateTimeFormatterICU.toICUDateStyle(dateStyle), (ULocale)((ULocale)resolvedLocaleObject.getLocale()))).toLocalizedPattern();
        }
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance((int)PlatformDateTimeFormatterICU.toICUDateStyle(dateStyle), (int)PlatformDateTimeFormatterICU.toICUTimeStyle(timeStyle), (ULocale)((ULocale)resolvedLocaleObject.getLocale()))).toLocalizedPattern();
    }

    private static void replacePatternChars(StringBuilder skeletonBuffer, char[] fromSet, char to) {
        block0: for (int idx = 0; idx < skeletonBuffer.length(); ++idx) {
            for (char fromChar : fromSet) {
                if (skeletonBuffer.charAt(idx) != fromChar) continue;
                skeletonBuffer.setCharAt(idx, to);
                continue block0;
            }
        }
    }

    @RequiresApi(api=24)
    private static String getSkeleton(ILocaleObject<?> resolvedLocaleObject, IPlatformDateTimeFormatter.WeekDay weekDay, IPlatformDateTimeFormatter.Era era, IPlatformDateTimeFormatter.Year year, IPlatformDateTimeFormatter.Month month, IPlatformDateTimeFormatter.Day day, IPlatformDateTimeFormatter.Hour hour, IPlatformDateTimeFormatter.Minute minute, IPlatformDateTimeFormatter.Second second, IPlatformDateTimeFormatter.TimeZoneName timeZoneName, IPlatformDateTimeFormatter.HourCycle hourCycle, IPlatformDateTimeFormatter.DateStyle dateStyle, IPlatformDateTimeFormatter.TimeStyle timeStyle, Object hour12) throws JSRangeErrorException {
        StringBuilder skeletonBuffer = new StringBuilder();
        if (dateStyle != IPlatformDateTimeFormatter.DateStyle.UNDEFINED || timeStyle != IPlatformDateTimeFormatter.TimeStyle.UNDEFINED) {
            skeletonBuffer.append(PlatformDateTimeFormatterICU.getPatternForStyle(resolvedLocaleObject, dateStyle, timeStyle));
            HashMap<String, String> exts = resolvedLocaleObject.getUnicodeExtensions();
            if (exts.containsKey("hc")) {
                String hourCycleExt = exts.get("hc");
                if (hourCycleExt == "h11" || hourCycleExt == "h12") {
                    PlatformDateTimeFormatterICU.replacePatternChars(skeletonBuffer, new char[]{'H', 'K', 'k'}, 'h');
                } else if (hourCycleExt == "h23" || hourCycleExt == "h24") {
                    PlatformDateTimeFormatterICU.replacePatternChars(skeletonBuffer, new char[]{'h', 'H', 'K'}, 'k');
                }
            }
            if (hourCycle == IPlatformDateTimeFormatter.HourCycle.H11 || hourCycle == IPlatformDateTimeFormatter.HourCycle.H12) {
                PlatformDateTimeFormatterICU.replacePatternChars(skeletonBuffer, new char[]{'H', 'K', 'k'}, 'h');
            } else if (hourCycle == IPlatformDateTimeFormatter.HourCycle.H23 || hourCycle == IPlatformDateTimeFormatter.HourCycle.H24) {
                PlatformDateTimeFormatterICU.replacePatternChars(skeletonBuffer, new char[]{'h', 'H', 'K'}, 'k');
            }
            if (!JSObjects.isUndefined(hour12) && !JSObjects.isNull(hour12)) {
                if (JSObjects.getJavaBoolean(hour12)) {
                    PlatformDateTimeFormatterICU.replacePatternChars(skeletonBuffer, new char[]{'H', 'K', 'k'}, 'h');
                } else {
                    PlatformDateTimeFormatterICU.replacePatternChars(skeletonBuffer, new char[]{'h', 'H', 'K'}, 'k');
                }
            }
        } else {
            skeletonBuffer.append(weekDay.getSkeleonSymbol());
            skeletonBuffer.append(era.getSkeleonSymbol());
            skeletonBuffer.append(year.getSkeleonSymbol());
            skeletonBuffer.append(month.getSkeleonSymbol());
            skeletonBuffer.append(day.getSkeleonSymbol());
            if (hourCycle == IPlatformDateTimeFormatter.HourCycle.H11 || hourCycle == IPlatformDateTimeFormatter.HourCycle.H12) {
                skeletonBuffer.append(hour.getSkeleonSymbol12());
            } else {
                skeletonBuffer.append(hour.getSkeleonSymbol24());
            }
            skeletonBuffer.append(minute.getSkeleonSymbol());
            skeletonBuffer.append(second.getSkeleonSymbol());
            skeletonBuffer.append(timeZoneName.getSkeleonSymbol());
        }
        return skeletonBuffer.toString();
    }

    @Override
    @RequiresApi(api=24)
    public void configure(ILocaleObject<?> resolvedLocaleObject, String calendar, String numberingSystem, IPlatformDateTimeFormatter.FormatMatcher formatMatcher, IPlatformDateTimeFormatter.WeekDay weekDay, IPlatformDateTimeFormatter.Era era, IPlatformDateTimeFormatter.Year year, IPlatformDateTimeFormatter.Month month, IPlatformDateTimeFormatter.Day day, IPlatformDateTimeFormatter.Hour hour, IPlatformDateTimeFormatter.Minute minute, IPlatformDateTimeFormatter.Second second, IPlatformDateTimeFormatter.TimeZoneName timeZoneName, IPlatformDateTimeFormatter.HourCycle hourCycle, Object timeZone, IPlatformDateTimeFormatter.DateStyle dateStyle, IPlatformDateTimeFormatter.TimeStyle timeStyle, Object hour12) throws JSRangeErrorException {
        String skeleton = PlatformDateTimeFormatterICU.getSkeleton(resolvedLocaleObject, weekDay, era, year, month, day, hour, minute, second, timeZoneName, hourCycle, dateStyle, timeStyle, hour12);
        Calendar calendarInstance = null;
        if (!calendar.isEmpty()) {
            ArrayList<String> calendarList = new ArrayList<String>();
            calendarList.add(JSObjects.getJavaString(calendar));
            ILocaleObject<?> modifiedLocaleObject = resolvedLocaleObject.cloneObject();
            modifiedLocaleObject.setUnicodeExtensions("ca", calendarList);
            calendarInstance = Calendar.getInstance((ULocale)((ULocale)modifiedLocaleObject.getLocale()));
        }
        if (!numberingSystem.isEmpty()) {
            NumberingSystem numberingSystemObject;
            try {
                numberingSystemObject = NumberingSystem.getInstanceByName((String)JSObjects.getJavaString(numberingSystem));
            }
            catch (RuntimeException ex) {
                throw new JSRangeErrorException("Invalid numbering system: " + numberingSystem);
            }
            if (numberingSystemObject == null) {
                throw new JSRangeErrorException("Invalid numbering system: " + numberingSystem);
            }
            ArrayList<String> numberingSystemList = new ArrayList<String>();
            numberingSystemList.add(JSObjects.getJavaString(numberingSystem));
            resolvedLocaleObject.setUnicodeExtensions("nu", numberingSystemList);
        }
        this.mDateFormat = calendarInstance != null ? DateFormat.getPatternInstance(calendarInstance, (String)skeleton, (ULocale)((ULocale)resolvedLocaleObject.getLocale())) : DateFormat.getPatternInstance((String)skeleton, (ULocale)((ULocale)resolvedLocaleObject.getLocale()));
        if (!JSObjects.isUndefined(timeZone) && !JSObjects.isNull(timeZone)) {
            TimeZone timeZoneObject = TimeZone.getTimeZone((String)JSObjects.getJavaString(timeZone));
            this.mDateFormat.setTimeZone(timeZoneObject);
        }
    }

    @Override
    @RequiresApi(api=24)
    public String[] getAvailableLocales() {
        ULocale[] availableLocales;
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (ULocale locale : availableLocales = ULocale.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }

    PlatformDateTimeFormatterICU() {
    }

    private static class PatternUtils {
        private PatternUtils() {
        }

        public static String getPatternWithoutLiterals(String pattern) {
            StringBuilder segment = new StringBuilder();
            boolean literalSegmentRunning = false;
            for (int idx = 0; idx < pattern.length(); ++idx) {
                char c = pattern.charAt(idx);
                if (c == '\'') {
                    literalSegmentRunning = !literalSegmentRunning;
                    continue;
                }
                if (literalSegmentRunning || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
                segment.append(pattern.charAt(idx));
            }
            return segment.toString();
        }
    }
}

