/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.text.NumberingSystem;
import android.icu.text.RuleBasedCollator;
import android.icu.util.Calendar;
import android.icu.util.ULocale;
import android.os.Build;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UnicodeExtensionKeys {
    public static String CALENDAR = "calendar";
    public static String CALENDAR_CANON = "ca";
    public static String NUMERINGSYSTEM = "numbers";
    public static String NUMERINGSYSTEM_CANON = "nu";
    public static String HOURCYCLE = "hours";
    public static String HOURCYCLE_CANON = "hc";
    public static String COLLATION = "collation";
    public static String COLLATION_CANON = "co";
    public static String COLLATION_NUMERIC = "colnumeric";
    public static String COLLATION_NUMERIC_CANON = "kn";
    public static String COLLATION_CASEFIRST = "colcasefirst";
    public static String COLLATION_CASEFIRST_CANON = "kf";
    private static HashMap<String, String> s_canonicalkey_icukey_map = new HashMap<String, String>(){
        {
            this.put(CALENDAR_CANON, CALENDAR);
            this.put(NUMERINGSYSTEM_CANON, NUMERINGSYSTEM);
            this.put(HOURCYCLE_CANON, HOURCYCLE);
            this.put(COLLATION_CANON, COLLATION);
            this.put(COLLATION_NUMERIC_CANON, COLLATION_NUMERIC);
            this.put(COLLATION_CASEFIRST_CANON, COLLATION_CASEFIRST);
        }
    };
    private static HashMap<String, String> s_icukey_canonicalkey_map = new HashMap<String, String>(){
        {
            this.put(CALENDAR, CALENDAR_CANON);
            this.put(NUMERINGSYSTEM, NUMERINGSYSTEM_CANON);
            this.put(HOURCYCLE, HOURCYCLE_CANON);
            this.put(COLLATION, COLLATION_CANON);
            this.put(COLLATION_NUMERIC, COLLATION_NUMERIC_CANON);
            this.put(COLLATION_CASEFIRST, COLLATION_CASEFIRST_CANON);
        }
    };
    private static final Map<String, String> s_collationAliasMappings = new HashMap<String, String>(){
        {
            this.put("dictionary", "dict");
            this.put("phonebook", "phonebk");
            this.put("traditional", "trad");
            this.put("gb2312han", "gb2312");
        }
    };
    private static Map<String, String> s_calendarAliasMappings = new HashMap<String, String>(){
        {
            this.put("gregorian", "gregory");
        }
    };
    private static Map<String, String> s_numberSystemAliasMappings = new HashMap<String, String>(){
        {
            this.put("traditional", "traditio");
        }
    };
    private static Map<String, String[]> s_validKeywords = new HashMap<String, String[]>(){
        {
            this.put("nu", new String[]{"adlm", "ahom", "arab", "arabext", "bali", "beng", "bhks", "brah", "cakm", "cham", "deva", "diak", "fullwide", "gong", "gonm", "gujr", "guru", "hanidec", "hmng", "hmnp", "java", "kali", "khmr", "knda", "lana", "lanatham", "laoo", "latn", "lepc", "limb", "mathbold", "mathdbl", "mathmono", "mathsanb", "mathsans", "mlym", "modi", "mong", "mroo", "mtei", "mymr", "mymrshan", "mymrtlng", "newa", "nkoo", "olck", "orya", "osma", "rohg", "saur", "segment", "shrd", "sind", "sinh", "sora", "sund", "takr", "talu", "tamldec", "telu", "thai", "tibt", "tirh", "vaii", "wara", "wcho"});
            this.put("co", new String[]{"big5han", "compat", "dict", "direct", "ducet", "emoji", "eor", "gb2312", "phonebk", "phonetic", "pinyin", "reformed", "searchjl", "stroke", "trad", "unihan", "zhuyin"});
            this.put("ca", new String[]{"buddhist", "chinese", "coptic", "dangi", "ethioaa", "ethiopic", "gregory", "hebrew", "indian", "islamic", "islamic-umalqura", "islamic-tbla", "islamic-civil", "islamic-rgsa", "iso8601", "japanese", "persian", "roc"});
        }
    };

    public static String CanonicalKeyToICUKey(String key) {
        if (s_canonicalkey_icukey_map.containsKey(key)) {
            return s_canonicalkey_icukey_map.get(key);
        }
        return key;
    }

    public static String ICUKeyToCanonicalKey(String key) {
        if (s_icukey_canonicalkey_map.containsKey(key)) {
            return s_icukey_canonicalkey_map.get(key);
        }
        return key;
    }

    public static String resolveCollationAlias(String value) {
        if (!s_collationAliasMappings.containsKey(value)) {
            return value;
        }
        return s_collationAliasMappings.get(value);
    }

    public static String resolveCalendarAlias(String value) {
        if (!s_calendarAliasMappings.containsKey(value)) {
            return value;
        }
        return s_calendarAliasMappings.get(value);
    }

    public static String resolveNumberSystemAlias(String value) {
        if (!s_numberSystemAliasMappings.containsKey(value)) {
            return value;
        }
        return s_numberSystemAliasMappings.get(value);
    }

    public static boolean isValidKeyword(String key, String value, ILocaleObject localeObject) throws JSRangeErrorException {
        if (Build.VERSION.SDK_INT >= 24) {
            ULocale locale = (ULocale)localeObject.getLocale();
            String[] availableValues = new String[]{};
            if (key.equals("co")) {
                if (value.equals("standard") || value.equals("search")) {
                    return false;
                }
                availableValues = RuleBasedCollator.getKeywordValuesForLocale((String)"co", (ULocale)locale, (boolean)false);
            } else if (key.equals("ca")) {
                availableValues = Calendar.getKeywordValuesForLocale((String)"ca", (ULocale)locale, (boolean)false);
            } else if (key.equals("nu")) {
                availableValues = NumberingSystem.getAvailableNames();
            }
            if (availableValues.length == 0) {
                return true;
            }
            return Arrays.asList(availableValues).contains(value);
        }
        if (s_validKeywords.containsKey(key)) {
            return Arrays.asList(s_validKeywords.get(key)).contains(value);
        }
        return true;
    }

    public static Object resolveKnownAliases(String key, Object value) {
        if (key.equals("ca") && JSObjects.isString(value)) {
            return UnicodeExtensionKeys.resolveCalendarAlias((String)value);
        }
        if (key.equals("nu") && JSObjects.isString(value)) {
            return UnicodeExtensionKeys.resolveNumberSystemAlias((String)value);
        }
        if (key.equals("co") && JSObjects.isString(value)) {
            return UnicodeExtensionKeys.resolveCollationAlias((String)value);
        }
        if (key.equals("kn") && JSObjects.isString(value) && value.equals("yes")) {
            return JSObjects.newString("true");
        }
        if ((key.equals("kn") || key.equals("kf")) && JSObjects.isString(value) && value.equals("no")) {
            return JSObjects.newString("false");
        }
        return value;
    }
}

