/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader.nativeloader;

import android.content.Context;
import com.facebook.soloader.nativeloader.delegate.NativeLoaderDelegate;
import com.facebook.soloader.nativeloader.delegate.SystemDelegateImpl;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeLoader {
    private static final AtomicBoolean sAlreadyInitialized = new AtomicBoolean(false);
    private static NativeLoaderDelegate sDelegate;

    private NativeLoader() {
    }

    public static void set(NativeLoaderDelegate delegate) {
        sAlreadyInitialized.set(false);
        sDelegate = delegate;
    }

    public static boolean loadLibrary(String shortName) {
        if (!sAlreadyInitialized.get()) {
            throw new RuntimeException("NativeLoader.init() not yet called");
        }
        return sDelegate.loadLibrary(shortName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) throws IOException {
        AtomicBoolean atomicBoolean = sAlreadyInitialized;
        synchronized (atomicBoolean) {
            if (sDelegate == null) {
                sDelegate = new SystemDelegateImpl();
            }
            if (sAlreadyInitialized.compareAndSet(false, true)) {
                sDelegate.init(context);
            }
        }
    }
}

