// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.firebase.ui.auth

import android.util.Log
import androidx.annotation.Keep
import com.google.firebase.components.Component
import com.google.firebase.components.ComponentRegistrar
import com.google.firebase.platforminfo.LibraryVersionComponent

/**
 * Registers the FirebaseUI-Android Compose library with Firebase Analytics.
 * This enables Firebase to track which versions of FirebaseUI are being used.
 */
@Keep
class FirebaseUIComposeRegistrar : ComponentRegistrar {
    override fun getComponents(): List<Component<*>> {
        Log.d("FirebaseUIRegistrar", "FirebaseUI Compose Registrar initialized: " +
                "LIBRARY_NAME: ${BuildConfig.LIBRARY_NAME}, " +
                "VERSION_NAME: ${BuildConfig.VERSION_NAME}")
        return listOf(
            LibraryVersionComponent.create(BuildConfig.LIBRARY_NAME, BuildConfig.VERSION_NAME)
        )
    }
}
