/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

import com.fyber.inneractive.sdk.flow.InneractiveAdContent;
import com.fyber.inneractive.sdk.flow.InneractiveVideoAdContent;
import com.fyber.inneractive.sdk.flow.InneractiveVideoContentControllerBase;
import com.fyber.inneractive.sdk.renderers.InneractiveFullscreenVideoAdRenderer;

import java.lang.ref.WeakReference;

/**
 * Adds specific native related video actions
 */

public class InneractiveAdViewVideoContentController extends InneractiveVideoContentControllerBase {
    // Members
    /** The controller renderer */
    WeakReference<InneractiveFullscreenVideoAdRenderer> mRenderer;

    /**
     * Sets the renderer this content controller will control. Called by unit controller
     * @param renderer
     */
    public void setControlledRenderer(InneractiveFullscreenVideoAdRenderer renderer) {
        mRenderer = new WeakReference<InneractiveFullscreenVideoAdRenderer>(renderer);
    }

    /** Call this method if you want the video to start playing, and you have disabled auto-play through the config */
    public void playVideo() {

    }

    /** Call this method if you want the video to pause playing, and you have disabled auto-pause through the config */
    public void pauseVideo() {

    }

    @Override
    public boolean canControl(InneractiveAdSpot adSpot) {
        InneractiveAdContent adContent = adSpot.getAdContent();
        if (adContent instanceof InneractiveVideoAdContent) {
            return true;
        }

        return false;
    }
}
