/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

import com.fyber.inneractive.sdk.util.IAJavaUtil;
import com.fyber.inneractive.sdk.util.IAdefines;
import com.fyber.inneractive.sdk.util.IAlog;

/**
 * Public configuration class
 * <br>Use to define your user level parameters when initializing the Inneractive library or a specific ad placement
 * <br>Written with a simple builder pattern, for ease of use
 */
public class InneractiveUserConfig {
	// Members
	/** Age of user */
	private int mAge			= IAdefines.INT_UNDEFINED;
	/** Gender of user */
	private Gender mGender		= null;
	/** Zip code of user */
	@Deprecated private String mZipCode		= null;
	
    /**
     * Simple enumeration helper
	 * <br>Gender values are Male and Female. Passing the user gender can significantly improve your ad performance.
     */
    public enum Gender {
    	MALE,
    	FEMALE;
    }
    
    /**
     * Set the user's age
     * @param age	a number between 1 and 120
     */
    public InneractiveUserConfig setAge(int age) {
		if (ageIsValid(age)){
			mAge = age;
		}
		else{
			IAlog.w("The Age is invalid. Please use a number between 1 and 120");
		}
		
    	return this;
    }

	/**
	 * Small helper for checking age validity
	 * @param age
	 * @return
	 */
	public static boolean ageIsValid(int age) {
    	return age >= 1 && age <= 120;
	}

	/** Getter for user's age */
    public int getAge() {
    	return mAge;
    }
    
    /**
     * Set the user's gender
     * @param gender	Either male or female
     */
    public InneractiveUserConfig setGender(Gender gender) {
		if (null != gender) {
			mGender = gender;
		}
		else{
			IAlog.w("The gender is invalid. Please use one of the suggested InneractiveAdView.Gender");
		}
		
    	return this;
    }

	/** Getter for user's gender */
    public Gender getGender() {
    	return mGender;
    }
    
    /**
     * Set the user's zipCode
     * @param zipCode
     */
	@Deprecated
    public InneractiveUserConfig setZipCode(String zipCode) {
		if(zipCode != null && IAJavaUtil.isValidZipCode(zipCode)){
			mZipCode = zipCode;
		}
		else {
			IAlog.i("The zipcode format is invalid. Please use a valid value.");
		}
		
    	return this;
    }

	/** Getter for user's zip code */
	@Deprecated
    public String getZipCode() {
    	return mZipCode;
    }
}
