/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

/** External listener interface */
public interface VideoContentListener extends InneractiveContentController.EventsListener {
    /**
     * This callback is called by the controller every 1 second
     * @param totalDurationInMsec total duration of the video in milliseconds
     * @param positionInMsec current play position in milliseconds
     */
    public void onProgress(int totalDurationInMsec, int positionInMsec);
    /** Called when the video is completed */
    public void onCompleted();
    /**
     * Called when there was un unrecovarable error playing the video
     * @deprecated this method is obsolete and not in use.
     * */
    @Deprecated
    public void onPlayerError();
}
