/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

public class ImpressionData {

    private Pricing pricing = new Pricing();
    private Video video;
    private String demandSource;
    private Long demandId;
    private String country;
    private String impressionId;
    private String creativeId;
    private String campaignId;
    private String advertiserDomain;

    public Pricing getPricing() {
        return pricing;
    }

    public void setPricing(Pricing pricing) {
        this.pricing = pricing;
    }

    public Video getVideo() {
        return video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public String getDemandSource() {
        return demandSource;
    }

    public void setDemandSource(String demandSource) {
        this.demandSource = demandSource;
    }

    public Long getDemandId() {
        return demandId;
    }

    public void setDemandId(Long demandId) {
        this.demandId = demandId;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getImpressionId() {
        return impressionId;
    }

    public void setImpressionId(String impressionId) {
        this.impressionId = impressionId;
    }

    public String getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(String creativeId) {
        this.creativeId = creativeId;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public String getAdvertiserDomain() {
        return advertiserDomain;
    }

    public void setAdvertiserDomain(String advertiserDomain) {
        this.advertiserDomain = advertiserDomain;
    }

    public void setDuration(long duration) {
        this.video.duration = duration;
    }

    public void setCurrency(String currency) {
        this.pricing.currency = currency;
    }

    public void setCpmValue(String cpmValue) {
        double cpmval = 0;
        try {
            cpmval = Double.parseDouble(cpmValue);
        } catch (Exception ignore) {

        }
        this.pricing.value = cpmval;
    }


    public static class Video {

        private boolean skippable;
        private long duration;

        public Video(boolean skippable, long duration) {
            this.skippable = skippable;
            this.duration = duration;
        }

        public boolean isSkippable() {
            return skippable;
        }

        public long getDuration() {
            return duration;
        }

        @Override
        public String toString() {
            return "Video{" +
                    "skippable=" + skippable +
                    ", duration=" + duration +
                    '}';
        }
    }

    public static class Pricing {
        private double value;
        private String currency;

        public void setValue(double value) {
            this.value = value;
        }


        public double getValue() {
            return value;
        }


        public String getCurrency() {
            return currency;
        }

        @Override
        public String toString() {
            return "Pricing{" +
                    "value=" + value +
                    ", currency='" + currency + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "ImpressionData{" +
                "pricing=" + pricing +
                ", video=" + video +
                ", demandSource='" + demandSource + '\'' +
                ", country='" + country + '\'' +
                ", impressionId='" + impressionId + '\'' +
                ", creativeId='" + creativeId + '\'' +
                ", campaignId='" + campaignId + '\'' +
                ", advertiserDomain='" + advertiserDomain + '\'' +
                '}';
    }
}
