/*
 * Decompiled with CFR 0.152.
 */
package com.bosphere.fadingedgelayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.FrameLayout;
import com.bosphere.fadingedgelayout.R;

public class FadingEdgeLayout
extends FrameLayout {
    private static final int DEFAULT_GRADIENT_SIZE_DP = 80;
    public static final int FADE_EDGE_TOP = 1;
    public static final int FADE_EDGE_BOTTOM = 2;
    public static final int FADE_EDGE_LEFT = 4;
    public static final int FADE_EDGE_RIGHT = 8;
    private static final int DIRTY_FLAG_TOP = 1;
    private static final int DIRTY_FLAG_BOTTOM = 2;
    private static final int DIRTY_FLAG_LEFT = 4;
    private static final int DIRTY_FLAG_RIGHT = 8;
    private static final int[] FADE_COLORS = new int[]{0, -16777216};
    private static final int[] FADE_COLORS_REVERSE = new int[]{-16777216, 0};
    private boolean fadeTop;
    private boolean fadeBottom;
    private boolean fadeLeft;
    private boolean fadeRight;
    private int gradientSizeTop;
    private int gradientSizeBottom;
    private int gradientSizeLeft;
    private int gradientSizeRight;
    private Paint gradientPaintTop;
    private Paint gradientPaintBottom;
    private Paint gradientPaintLeft;
    private Paint gradientPaintRight;
    private Rect gradientRectTop;
    private Rect gradientRectBottom;
    private Rect gradientRectLeft;
    private Rect gradientRectRight;
    private int gradientDirtyFlags;

    public FadingEdgeLayout(Context context) {
        super(context);
        this.init(null, 0);
    }

    public FadingEdgeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public FadingEdgeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, 0);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        int defaultSize = (int)TypedValue.applyDimension((int)1, (float)80.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        if (attrs != null) {
            TypedArray arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.FadingEdgeLayout, defStyleAttr, 0);
            int flags = arr.getInt(R.styleable.FadingEdgeLayout_fel_edge, 0);
            this.fadeTop = (flags & 1) == 1;
            this.fadeBottom = (flags & 2) == 2;
            this.fadeLeft = (flags & 4) == 4;
            this.fadeRight = (flags & 8) == 8;
            this.gradientSizeTop = arr.getDimensionPixelSize(R.styleable.FadingEdgeLayout_fel_size_top, defaultSize);
            this.gradientSizeBottom = arr.getDimensionPixelSize(R.styleable.FadingEdgeLayout_fel_size_bottom, defaultSize);
            this.gradientSizeLeft = arr.getDimensionPixelSize(R.styleable.FadingEdgeLayout_fel_size_left, defaultSize);
            this.gradientSizeRight = arr.getDimensionPixelSize(R.styleable.FadingEdgeLayout_fel_size_right, defaultSize);
            if (this.fadeTop && this.gradientSizeTop > 0) {
                this.gradientDirtyFlags |= 1;
            }
            if (this.fadeLeft && this.gradientSizeLeft > 0) {
                this.gradientDirtyFlags |= 4;
            }
            if (this.fadeBottom && this.gradientSizeBottom > 0) {
                this.gradientDirtyFlags |= 2;
            }
            if (this.fadeRight && this.gradientSizeRight > 0) {
                this.gradientDirtyFlags |= 8;
            }
            arr.recycle();
        } else {
            this.gradientSizeLeft = this.gradientSizeRight = defaultSize;
            this.gradientSizeBottom = this.gradientSizeRight;
            this.gradientSizeTop = this.gradientSizeRight;
        }
        PorterDuffXfermode mode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        this.gradientPaintTop = new Paint(1);
        this.gradientPaintTop.setXfermode((Xfermode)mode);
        this.gradientPaintBottom = new Paint(1);
        this.gradientPaintBottom.setXfermode((Xfermode)mode);
        this.gradientPaintLeft = new Paint(1);
        this.gradientPaintLeft.setXfermode((Xfermode)mode);
        this.gradientPaintRight = new Paint(1);
        this.gradientPaintRight.setXfermode((Xfermode)mode);
        this.gradientRectTop = new Rect();
        this.gradientRectLeft = new Rect();
        this.gradientRectBottom = new Rect();
        this.gradientRectRight = new Rect();
    }

    public void setFadeSizes(int top, int left, int bottom, int right) {
        if (this.gradientSizeTop != top) {
            this.gradientSizeTop = top;
            this.gradientDirtyFlags |= 1;
        }
        if (this.gradientSizeLeft != left) {
            this.gradientSizeLeft = left;
            this.gradientDirtyFlags |= 4;
        }
        if (this.gradientSizeBottom != bottom) {
            this.gradientSizeBottom = bottom;
            this.gradientDirtyFlags |= 2;
        }
        if (this.gradientSizeRight != right) {
            this.gradientSizeRight = right;
            this.gradientDirtyFlags |= 8;
        }
        if (this.gradientDirtyFlags != 0) {
            this.invalidate();
        }
    }

    public void setFadeEdges(boolean fadeTop, boolean fadeLeft, boolean fadeBottom, boolean fadeRight) {
        if (this.fadeTop != fadeTop) {
            this.fadeTop = fadeTop;
            this.gradientDirtyFlags |= 1;
        }
        if (this.fadeLeft != fadeLeft) {
            this.fadeLeft = fadeLeft;
            this.gradientDirtyFlags |= 4;
        }
        if (this.fadeBottom != fadeBottom) {
            this.fadeBottom = fadeBottom;
            this.gradientDirtyFlags |= 2;
        }
        if (this.fadeRight != fadeRight) {
            this.fadeRight = fadeRight;
            this.gradientDirtyFlags |= 8;
        }
        if (this.gradientDirtyFlags != 0) {
            this.invalidate();
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.getPaddingLeft() != left) {
            this.gradientDirtyFlags |= 4;
        }
        if (this.getPaddingTop() != top) {
            this.gradientDirtyFlags |= 1;
        }
        if (this.getPaddingRight() != right) {
            this.gradientDirtyFlags |= 8;
        }
        if (this.getPaddingBottom() != bottom) {
            this.gradientDirtyFlags |= 2;
        }
        super.setPadding(left, top, right, bottom);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.gradientDirtyFlags |= 4;
            this.gradientDirtyFlags |= 8;
        }
        if (h != oldh) {
            this.gradientDirtyFlags |= 1;
            this.gradientDirtyFlags |= 2;
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean fadeAnyEdge;
        int newWidth = this.getWidth();
        int newHeight = this.getHeight();
        boolean bl = fadeAnyEdge = this.fadeTop || this.fadeBottom || this.fadeLeft || this.fadeRight;
        if (this.getVisibility() == 8 || newWidth == 0 || newHeight == 0 || !fadeAnyEdge) {
            super.dispatchDraw(canvas);
            return;
        }
        if ((this.gradientDirtyFlags & 1) == 1) {
            this.gradientDirtyFlags &= 0xFFFFFFFE;
            this.initTopGradient();
        }
        if ((this.gradientDirtyFlags & 4) == 4) {
            this.gradientDirtyFlags &= 0xFFFFFFFB;
            this.initLeftGradient();
        }
        if ((this.gradientDirtyFlags & 2) == 2) {
            this.gradientDirtyFlags &= 0xFFFFFFFD;
            this.initBottomGradient();
        }
        if ((this.gradientDirtyFlags & 8) == 8) {
            this.gradientDirtyFlags &= 0xFFFFFFF7;
            this.initRightGradient();
        }
        int count = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        super.dispatchDraw(canvas);
        if (this.fadeTop && this.gradientSizeTop > 0) {
            canvas.drawRect(this.gradientRectTop, this.gradientPaintTop);
        }
        if (this.fadeBottom && this.gradientSizeBottom > 0) {
            canvas.drawRect(this.gradientRectBottom, this.gradientPaintBottom);
        }
        if (this.fadeLeft && this.gradientSizeLeft > 0) {
            canvas.drawRect(this.gradientRectLeft, this.gradientPaintLeft);
        }
        if (this.fadeRight && this.gradientSizeRight > 0) {
            canvas.drawRect(this.gradientRectRight, this.gradientPaintRight);
        }
        canvas.restoreToCount(count);
    }

    private void initTopGradient() {
        int actualHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int size = Math.min(this.gradientSizeTop, actualHeight);
        int l = this.getPaddingLeft();
        int t = this.getPaddingTop();
        int r = this.getWidth() - this.getPaddingRight();
        int b = t + size;
        this.gradientRectTop.set(l, t, r, b);
        LinearGradient gradient = new LinearGradient((float)l, (float)t, (float)l, (float)b, FADE_COLORS, null, Shader.TileMode.CLAMP);
        this.gradientPaintTop.setShader((Shader)gradient);
    }

    private void initLeftGradient() {
        int actualWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int size = Math.min(this.gradientSizeLeft, actualWidth);
        int l = this.getPaddingLeft();
        int t = this.getPaddingTop();
        int r = l + size;
        int b = this.getHeight() - this.getPaddingBottom();
        this.gradientRectLeft.set(l, t, r, b);
        LinearGradient gradient = new LinearGradient((float)l, (float)t, (float)r, (float)t, FADE_COLORS, null, Shader.TileMode.CLAMP);
        this.gradientPaintLeft.setShader((Shader)gradient);
    }

    private void initBottomGradient() {
        int actualHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int size = Math.min(this.gradientSizeBottom, actualHeight);
        int l = this.getPaddingLeft();
        int t = this.getPaddingTop() + actualHeight - size;
        int r = this.getWidth() - this.getPaddingRight();
        int b = t + size;
        this.gradientRectBottom.set(l, t, r, b);
        LinearGradient gradient = new LinearGradient((float)l, (float)t, (float)l, (float)b, FADE_COLORS_REVERSE, null, Shader.TileMode.CLAMP);
        this.gradientPaintBottom.setShader((Shader)gradient);
    }

    private void initRightGradient() {
        int actualWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int size = Math.min(this.gradientSizeRight, actualWidth);
        int l = this.getPaddingLeft() + actualWidth - size;
        int t = this.getPaddingTop();
        int r = l + size;
        int b = this.getHeight() - this.getPaddingBottom();
        this.gradientRectRight.set(l, t, r, b);
        LinearGradient gradient = new LinearGradient((float)l, (float)t, (float)r, (float)t, FADE_COLORS_REVERSE, null, Shader.TileMode.CLAMP);
        this.gradientPaintRight.setShader((Shader)gradient);
    }
}

