/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.GlideType;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class GlideExtensionValidator {
    private final ProcessingEnvironment processingEnvironment;
    private final ProcessorUtil processorUtil;

    GlideExtensionValidator(ProcessingEnvironment processingEnvironment, ProcessorUtil processorUtil) {
        this.processingEnvironment = processingEnvironment;
        this.processorUtil = processorUtil;
    }

    void validateExtension(TypeElement typeElement) {
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new IllegalArgumentException("RequestOptionsExtensions must be public");
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                GlideExtensionValidator.validateExtensionConstructor(element);
                continue;
            }
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getAnnotation(GlideOption.class) != null) {
                this.validateGlideOption(executableElement);
                continue;
            }
            if (executableElement.getAnnotation(GlideType.class) == null) continue;
            this.validateGlideType(executableElement);
        }
    }

    private static void validateExtensionConstructor(Element element) {
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new IllegalArgumentException("RequestOptionsExtensions must be public, with private constructors and only static methods. Found a non-private constructor");
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!executableElement.getParameters().isEmpty()) {
            throw new IllegalArgumentException("RequestOptionsExtensions must be public, with private constructors and only static methods. Found parameters in the constructor");
        }
    }

    private void validateGlideOption(ExecutableElement executableElement) {
        if (GlideExtensionValidator.returnsVoid(executableElement)) {
            this.validateDeprecatedGlideOption(executableElement);
        } else {
            this.validateNewGlideOption(executableElement);
        }
    }

    private void validateNewGlideOption(ExecutableElement executableElement) {
        this.validateNewGlideOptionAnnotations(executableElement);
        GlideExtensionValidator.validateGlideOptionParameters(executableElement);
        TypeMirror returnType = executableElement.getReturnType();
        if (!GlideExtensionValidator.isRequestOptions(returnType)) {
            throw new IllegalArgumentException("@GlideOption methods should return a RequestOptions object, but given: " + returnType + ". If you're using old style @GlideOption methods, your method may have a void return type, but doing so is deprecated and support will be removed in a future version");
        }
        this.validateGlideOptionOverride(executableElement);
    }

    private void validateNewGlideOptionAnnotations(ExecutableElement executableElement) {
        this.validateAnnotatedNonNull(executableElement);
    }

    private void validateDeprecatedGlideOption(ExecutableElement executableElement) {
        GlideExtensionValidator.validateStaticVoid(executableElement, GlideOption.class);
        GlideExtensionValidator.validateGlideOptionParameters(executableElement);
        this.validateGlideOptionOverride(executableElement);
    }

    private static void validateGlideOptionParameters(ExecutableElement executableElement) {
        if (executableElement.getParameters().isEmpty()) {
            throw new IllegalArgumentException("@GlideOption methods must take a RequestOptions object as their first parameter, but given none");
        }
        VariableElement first = executableElement.getParameters().get(0);
        TypeMirror expected = first.asType();
        if (!GlideExtensionValidator.isRequestOptions(expected)) {
            throw new IllegalArgumentException("@GlideOption methods must take a RequestOptions object as their first parameter, but given: " + expected);
        }
    }

    private static boolean isRequestOptions(TypeMirror typeMirror) {
        return typeMirror.toString().equals("com.bumptech.glide.request.RequestOptions");
    }

    private void validateGlideOptionOverride(ExecutableElement element) {
        int overrideType = this.processorUtil.getOverrideType(element);
        boolean isOverridingRequestOptionsMethod = this.isMethodInRequestOptions(element);
        if (isOverridingRequestOptionsMethod && overrideType == 0) {
            throw new IllegalArgumentException("Accidentally attempting to override a method in RequestOptions. Add an 'override' value in the @GlideOption annotation if this is intentional. Offending method: " + element.getEnclosingElement() + "#" + element);
        }
        if (!isOverridingRequestOptionsMethod && overrideType != 0) {
            throw new IllegalArgumentException("Requested to override an existing method in RequestOptions, but no such method was found. Offending method: " + element.getEnclosingElement() + "#" + element);
        }
    }

    private boolean isMethodInRequestOptions(ExecutableElement toFind) {
        TypeElement requestOptionsType = this.processingEnvironment.getElementUtils().getTypeElement("com.bumptech.glide.request.RequestOptions");
        List<String> toFindParameterNames = GlideExtensionValidator.getComparableParameterNames(toFind, true);
        String toFindSimpleName = toFind.getSimpleName().toString();
        for (Element element : requestOptionsType.getEnclosedElements()) {
            List<String> parameterNamesInBase;
            ExecutableElement inBase;
            if (element.getKind() != ElementKind.METHOD || !toFindSimpleName.equals((inBase = (ExecutableElement)element).getSimpleName().toString()) || !(parameterNamesInBase = GlideExtensionValidator.getComparableParameterNames(inBase, false)).equals(toFindParameterNames)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getComparableParameterNames(ExecutableElement element, boolean skipFirst) {
        List<? extends VariableElement> parameters = element.getParameters();
        if (skipFirst) {
            parameters = parameters.subList(1, parameters.size());
        }
        ArrayList<String> result = new ArrayList<String>(parameters.size());
        for (VariableElement variableElement : parameters) {
            result.add(variableElement.asType().toString());
        }
        return result;
    }

    private void validateGlideType(ExecutableElement executableElement) {
        if (GlideExtensionValidator.returnsVoid(executableElement)) {
            GlideExtensionValidator.validateDeprecatedGlideType(executableElement);
        } else {
            this.validateNewGlideType(executableElement);
        }
    }

    private void validateNewGlideType(ExecutableElement executableElement) {
        TypeMirror returnType = executableElement.getReturnType();
        this.validateNewGlideTypeAnnotations(executableElement);
        if (!this.isRequestBuilder(returnType) || !this.typeMatchesExpected(returnType, executableElement)) {
            String expectedClassName = this.getGlideTypeValue(executableElement);
            throw new IllegalArgumentException("@GlideType methods should return a RequestBuilder<" + expectedClassName + "> object, but given: " + returnType + ". If you're using old style @GlideType methods, your method may have a void return type, but doing so is deprecated and support will be removed in a future version");
        }
        GlideExtensionValidator.validateGlideTypeParameters(executableElement);
    }

    private String getGlideTypeValue(ExecutableElement executableElement) {
        return this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(executableElement, GlideType.class).iterator().next();
    }

    private boolean typeMatchesExpected(TypeMirror returnType, ExecutableElement executableElement) {
        if (!(returnType instanceof DeclaredType)) {
            return false;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)returnType).getTypeArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        TypeMirror argument = typeArguments.get(0);
        String expected = this.getGlideTypeValue(executableElement);
        return argument.toString().equals(expected);
    }

    private boolean isRequestBuilder(TypeMirror typeMirror) {
        TypeMirror toCompare = this.processingEnvironment.getTypeUtils().erasure(typeMirror);
        return toCompare.toString().equals("com.bumptech.glide.RequestBuilder");
    }

    private static void validateDeprecatedGlideType(ExecutableElement executableElement) {
        GlideExtensionValidator.validateStaticVoid(executableElement, GlideType.class);
        GlideExtensionValidator.validateGlideTypeParameters(executableElement);
    }

    private static void validateGlideTypeParameters(ExecutableElement executableElement) {
        if (executableElement.getParameters().size() != 1) {
            throw new IllegalArgumentException("@GlideType methods must take a RequestBuilder object as their first and only parameter, but given multiple for: " + executableElement.getEnclosingElement() + "#" + executableElement);
        }
        VariableElement first = executableElement.getParameters().get(0);
        TypeMirror argumentType = first.asType();
        if (!argumentType.toString().startsWith("com.bumptech.glide.RequestBuilder")) {
            throw new IllegalArgumentException("@GlideType methods must take a RequestBuilder object as their first and only parameter, but given: " + argumentType);
        }
    }

    private void validateNewGlideTypeAnnotations(ExecutableElement executableElement) {
        this.validateAnnotatedNonNull(executableElement);
    }

    private void validateAnnotatedNonNull(ExecutableElement executableElement) {
        ImmutableSet<String> annotationNames = FluentIterable.from(executableElement.getAnnotationMirrors()).transform(new Function<AnnotationMirror, String>(){

            @Override
            public String apply(AnnotationMirror input) {
                return input.getAnnotationType().asElement().toString();
            }
        }).toSet();
        if (!annotationNames.contains("android.support.annotation.NonNull")) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, executableElement.getEnclosingElement() + "#" + executableElement.getSimpleName() + " is missing the " + "android.support.annotation.NonNull" + " annotation, please add it to ensure that your extension methods are always returning non-null values");
        }
    }

    private static void validateStatic(ExecutableElement executableElement, Class<?> clazz) {
        if (!executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new IllegalArgumentException("@" + clazz.getSimpleName() + " methods must be static");
        }
    }

    private static boolean returnsVoid(ExecutableElement executableElement) {
        TypeMirror returnType = executableElement.getReturnType();
        return returnType.getKind() == TypeKind.VOID;
    }

    private static void validateVoid(ExecutableElement executableElement, Class<?> clazz) {
        if (!GlideExtensionValidator.returnsVoid(executableElement)) {
            throw new IllegalArgumentException("@" + clazz.getSimpleName() + " methods must return void");
        }
    }

    private static void validateStaticVoid(ExecutableElement executableElement, Class<?> clazz) {
        GlideExtensionValidator.validateStatic(executableElement, clazz);
        GlideExtensionValidator.validateVoid(executableElement, clazz);
    }
}

